/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Hashtable;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import libcore.io.IoUtils;

public class FileHandler
extends StreamHandler {
    private static final String LCK_EXT = ".lck";
    private static final int DEFAULT_COUNT = 1;
    private static final int DEFAULT_LIMIT = 0;
    private static final boolean DEFAULT_APPEND = false;
    private static final String DEFAULT_PATTERN = "%h/java%u.log";
    private static final Hashtable<String, FileLock> allLocks = new Hashtable();
    private int count;
    private int limit;
    private boolean append;
    private String pattern;
    private LogManager manager;
    private MeasureOutputStream output;
    private File[] files;
    FileLock lock = null;
    String fileName = null;
    int uniqueID = -1;

    public FileHandler() throws IOException {
        this.init(null, null, null, null);
    }

    private void init(String p, Boolean a, Integer l, Integer c) throws IOException {
        this.manager = LogManager.getLogManager();
        this.manager.checkAccess();
        this.initProperties(p, a, l, c);
        this.initOutputFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initOutputFiles() throws FileNotFoundException, IOException {
        while (true) {
            ++this.uniqueID;
            for (int generation = 0; generation < this.count; ++generation) {
                this.files[generation] = new File(this.parseFileName(generation));
            }
            this.fileName = this.files[0].getAbsolutePath();
            Hashtable<String, FileLock> hashtable = allLocks;
            synchronized (hashtable) {
                if (allLocks.get(this.fileName) != null) {
                    continue;
                }
                if (this.files[0].exists() && (!this.append || this.files[0].length() >= (long)this.limit)) {
                    for (int i = this.count - 1; i > 0; --i) {
                        if (this.files[i].exists()) {
                            this.files[i].delete();
                        }
                        this.files[i - 1].renameTo(this.files[i]);
                    }
                }
                FileOutputStream fileStream = new FileOutputStream(this.fileName + LCK_EXT);
                FileChannel channel = fileStream.getChannel();
                this.lock = channel.tryLock();
                if (this.lock != null) {
                    allLocks.put(this.fileName, this.lock);
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 5] lbl26 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.output = new MeasureOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName, this.append)), this.files[0].length());
                    this.setOutputStream(this.output);
                    return;
                }
                IoUtils.closeQuietly(fileStream);
            }
        }
    }

    private void initProperties(String p, Boolean a, Integer l, Integer c) {
        super.initProperties("ALL", null, "java.util.logging.XMLFormatter", null);
        String className = this.getClass().getName();
        String string = this.pattern = p == null ? this.getStringProperty(className + ".pattern", DEFAULT_PATTERN) : p;
        if (this.pattern == null || this.pattern.isEmpty()) {
            throw new NullPointerException("Pattern cannot be empty or null");
        }
        this.append = a == null ? this.getBooleanProperty(className + ".append", false) : a.booleanValue();
        this.count = c == null ? this.getIntProperty(className + ".count", 1) : c.intValue();
        this.limit = l == null ? this.getIntProperty(className + ".limit", 0) : l.intValue();
        this.count = this.count < 1 ? 1 : this.count;
        this.limit = this.limit < 0 ? 0 : this.limit;
        this.files = new File[this.count];
    }

    void findNextGeneration() {
        super.close();
        for (int i = this.count - 1; i > 0; --i) {
            if (this.files[i].exists()) {
                this.files[i].delete();
            }
            this.files[i - 1].renameTo(this.files[i]);
        }
        try {
            this.output = new MeasureOutputStream(new BufferedOutputStream(new FileOutputStream(this.files[0])));
        }
        catch (FileNotFoundException e1) {
            this.getErrorManager().error("Error opening log file", e1, 4);
        }
        this.setOutputStream(this.output);
    }

    private String parseFileName(int gen) {
        int cur = 0;
        int next = 0;
        boolean hasUniqueID = false;
        boolean hasGeneration = false;
        String tempPath = System.getProperty("java.io.tmpdir");
        boolean tempPathHasSepEnd = tempPath == null ? false : tempPath.endsWith(File.separator);
        String homePath = System.getProperty("user.home");
        boolean homePathHasSepEnd = homePath == null ? false : homePath.endsWith(File.separator);
        StringBuilder sb = new StringBuilder();
        this.pattern = this.pattern.replace('/', File.separatorChar);
        char[] value = this.pattern.toCharArray();
        while ((next = this.pattern.indexOf(37, cur)) >= 0) {
            if (++next >= this.pattern.length()) continue;
            switch (value[next]) {
                case 'g': {
                    sb.append(value, cur, next - cur - 1).append(gen);
                    hasGeneration = true;
                    break;
                }
                case 'u': {
                    sb.append(value, cur, next - cur - 1).append(this.uniqueID);
                    hasUniqueID = true;
                    break;
                }
                case 't': {
                    sb.append(value, cur, next - cur - 1).append(tempPath);
                    if (tempPathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case 'h': {
                    sb.append(value, cur, next - cur - 1).append(homePath);
                    if (homePathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case '%': {
                    sb.append(value, cur, next - cur - 1).append('%');
                    break;
                }
                default: {
                    sb.append(value, cur, next - cur);
                }
            }
            cur = ++next;
        }
        sb.append(value, cur, value.length - cur);
        if (!hasGeneration && this.count > 1) {
            sb.append(".").append(gen);
        }
        if (!hasUniqueID && this.uniqueID > 0) {
            sb.append(".").append(this.uniqueID);
        }
        return sb.toString();
    }

    private boolean getBooleanProperty(String key, boolean defaultValue) {
        String property = this.manager.getProperty(key);
        if (property == null) {
            return defaultValue;
        }
        boolean result = defaultValue;
        if ("true".equalsIgnoreCase(property)) {
            result = true;
        } else if ("false".equalsIgnoreCase(property)) {
            result = false;
        }
        return result;
    }

    private String getStringProperty(String key, String defaultValue) {
        String property = this.manager.getProperty(key);
        return property == null ? defaultValue : property;
    }

    private int getIntProperty(String key, int defaultValue) {
        String property = this.manager.getProperty(key);
        int result = defaultValue;
        if (property != null) {
            try {
                result = Integer.parseInt(property);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public FileHandler(String pattern) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        this.init(pattern, null, 0, 1);
    }

    public FileHandler(String pattern, boolean append) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        this.init(pattern, append, 0, 1);
    }

    public FileHandler(String pattern, int limit, int count) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException("limit < 0 || count < 1");
        }
        this.init(pattern, null, limit, count);
    }

    public FileHandler(String pattern, int limit, int count, boolean append) throws IOException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException("limit < 0 || count < 1");
        }
        this.init(pattern, append, limit, count);
    }

    public void close() {
        super.close();
        allLocks.remove(this.fileName);
        try {
            FileChannel channel = this.lock.channel();
            this.lock.release();
            channel.close();
            File file = new File(this.fileName + LCK_EXT);
            file.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void publish(LogRecord record) {
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.output.getLength() >= (long)this.limit) {
            this.findNextGeneration();
        }
    }

    static class MeasureOutputStream
    extends OutputStream {
        OutputStream wrapped;
        long length;

        public MeasureOutputStream(OutputStream stream, long currentLength) {
            this.wrapped = stream;
            this.length = currentLength;
        }

        public MeasureOutputStream(OutputStream stream) {
            this(stream, 0L);
        }

        public void write(int oneByte) throws IOException {
            this.wrapped.write(oneByte);
            ++this.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.wrapped.write(b, off, len);
            this.length += (long)len;
        }

        public void close() throws IOException {
            this.wrapped.close();
        }

        public void flush() throws IOException {
            this.wrapped.flush();
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long newLength) {
            this.length = newLength;
        }
    }
}

