/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public abstract class Handler {
    private static final Level DEFAULT_LEVEL = Level.ALL;
    private ErrorManager errorMan = new ErrorManager();
    private String encoding = null;
    private Level level = DEFAULT_LEVEL;
    private Formatter formatter = null;
    private Filter filter = null;
    private String prefix = this.getClass().getName();

    protected Handler() {
    }

    private Object getDefaultInstance(String className) {
        Object result = null;
        if (className == null) {
            return result;
        }
        try {
            result = Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Object getCustomizeInstance(String className) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        Class<?> c = loader.loadClass(className);
        return c.newInstance();
    }

    void printInvalidPropMessage(String key, String value, Exception e) {
        String msg = "Invalid property value for " + this.prefix + ":" + key + "/" + value;
        this.errorMan.error(msg, e, 0);
    }

    void initProperties(String defaultLevel, String defaultFilter, String defaultFormatter, String defaultEncoding) {
        String formatterName;
        String levelName;
        LogManager manager = LogManager.getLogManager();
        String filterName = manager.getProperty(this.prefix + ".filter");
        if (filterName != null) {
            try {
                this.filter = (Filter)this.getCustomizeInstance(filterName);
            }
            catch (Exception e1) {
                this.printInvalidPropMessage("filter", filterName, e1);
                this.filter = (Filter)this.getDefaultInstance(defaultFilter);
            }
        } else {
            this.filter = (Filter)this.getDefaultInstance(defaultFilter);
        }
        if ((levelName = manager.getProperty(this.prefix + ".level")) != null) {
            try {
                this.level = Level.parse(levelName);
            }
            catch (Exception e) {
                this.printInvalidPropMessage("level", levelName, e);
                this.level = Level.parse(defaultLevel);
            }
        } else {
            this.level = Level.parse(defaultLevel);
        }
        if ((formatterName = manager.getProperty(this.prefix + ".formatter")) != null) {
            try {
                this.formatter = (Formatter)this.getCustomizeInstance(formatterName);
            }
            catch (Exception e) {
                this.printInvalidPropMessage("formatter", formatterName, e);
                this.formatter = (Formatter)this.getDefaultInstance(defaultFormatter);
            }
        } else {
            this.formatter = (Formatter)this.getDefaultInstance(defaultFormatter);
        }
        String encodingName = manager.getProperty(this.prefix + ".encoding");
        try {
            this.internalSetEncoding(encodingName);
        }
        catch (UnsupportedEncodingException e) {
            this.printInvalidPropMessage("encoding", encodingName, e);
        }
    }

    public abstract void close();

    public abstract void flush();

    public abstract void publish(LogRecord var1);

    public String getEncoding() {
        return this.encoding;
    }

    public ErrorManager getErrorManager() {
        LogManager.getLogManager().checkAccess();
        return this.errorMan;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isLoggable(LogRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        if (this.level.intValue() == Level.OFF.intValue()) {
            return false;
        }
        if (record.getLevel().intValue() >= this.level.intValue()) {
            return this.filter == null || this.filter.isLoggable(record);
        }
        return false;
    }

    protected void reportError(String msg, Exception ex, int code) {
        this.errorMan.error(msg, ex, code);
    }

    void internalSetEncoding(String newEncoding) throws UnsupportedEncodingException {
        if (newEncoding == null) {
            this.encoding = null;
        } else if (Charset.isSupported(newEncoding)) {
            this.encoding = newEncoding;
        } else {
            throw new UnsupportedEncodingException(newEncoding);
        }
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        LogManager.getLogManager().checkAccess();
        this.internalSetEncoding(encoding);
    }

    public void setErrorManager(ErrorManager em) {
        LogManager.getLogManager().checkAccess();
        if (em == null) {
            throw new NullPointerException();
        }
        this.errorMan = em;
    }

    public void setFilter(Filter newFilter) {
        LogManager.getLogManager().checkAccess();
        this.filter = newFilter;
    }

    void internalSetFormatter(Formatter newFormatter) {
        if (newFormatter == null) {
            throw new NullPointerException();
        }
        this.formatter = newFormatter;
    }

    public void setFormatter(Formatter newFormatter) {
        LogManager.getLogManager().checkAccess();
        this.internalSetFormatter(newFormatter);
    }

    public void setLevel(Level newLevel) {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        LogManager.getLogManager().checkAccess();
        this.level = newLevel;
    }
}

