/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class StreamHandler
extends Handler {
    private OutputStream os;
    private Writer writer;
    private boolean writerNotInitialized;

    public StreamHandler() {
        this.initProperties("INFO", null, "java.util.logging.SimpleFormatter", null);
        this.os = null;
        this.writer = null;
        this.writerNotInitialized = true;
    }

    StreamHandler(OutputStream os) {
        this();
        this.os = os;
    }

    StreamHandler(String defaultLevel, String defaultFilter, String defaultFormatter, String defaultEncoding) {
        this.initProperties(defaultLevel, defaultFilter, defaultFormatter, defaultEncoding);
        this.os = null;
        this.writer = null;
        this.writerNotInitialized = true;
    }

    public StreamHandler(OutputStream os, Formatter formatter) {
        this();
        if (os == null) {
            throw new NullPointerException("os == null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter == null");
        }
        this.os = os;
        this.internalSetFormatter(formatter);
    }

    private void initializeWriter() {
        this.writerNotInitialized = false;
        if (this.getEncoding() == null) {
            this.writer = new OutputStreamWriter(this.os);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.os, this.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.write(this.getFormatter().getHead(this));
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (Exception e) {
            this.getErrorManager().error("Exception occurred when writing to the output stream", e, 1);
        }
    }

    void internalSetOutputStream(OutputStream newOs) {
        this.os = newOs;
    }

    protected void setOutputStream(OutputStream os) {
        if (os == null) {
            throw new NullPointerException();
        }
        LogManager.getLogManager().checkAccess();
        this.close(true);
        this.writer = null;
        this.os = os;
        this.writerNotInitialized = true;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.flush();
        super.setEncoding(encoding);
        if (this.writer != null) {
            if (this.getEncoding() == null) {
                this.writer = new OutputStreamWriter(this.os);
            } else {
                try {
                    this.writer = new OutputStreamWriter(this.os, this.getEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    void close(boolean closeStream) {
        if (this.os != null) {
            if (this.writerNotInitialized) {
                this.initializeWriter();
            }
            this.write(this.getFormatter().getTail(this));
            try {
                this.writer.flush();
                if (closeStream) {
                    this.writer.close();
                    this.writer = null;
                    this.os = null;
                }
            }
            catch (Exception e) {
                this.getErrorManager().error("Exception occurred when closing the output stream", e, 3);
            }
        }
    }

    public void close() {
        LogManager.getLogManager().checkAccess();
        this.close(true);
    }

    public void flush() {
        if (this.os != null) {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                } else {
                    this.os.flush();
                }
            }
            catch (Exception e) {
                this.getErrorManager().error("Exception occurred when flushing the output stream", e, 2);
            }
        }
    }

    public synchronized void publish(LogRecord record) {
        block5: {
            try {
                if (!this.isLoggable(record)) break block5;
                if (this.writerNotInitialized) {
                    this.initializeWriter();
                }
                String msg = null;
                try {
                    msg = this.getFormatter().format(record);
                }
                catch (Exception e) {
                    this.getErrorManager().error("Exception occurred when formatting the log record", e, 5);
                }
                this.write(msg);
            }
            catch (Exception e) {
                this.getErrorManager().error("Exception occurred when logging the record", e, 0);
            }
        }
    }

    public boolean isLoggable(LogRecord record) {
        if (record == null) {
            return false;
        }
        return this.os != null && super.isLoggable(record);
    }
}

