/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.MatchResult;
import java.util.regex.MatchResultImpl;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    private Pattern pattern;
    private int address;
    private String input;
    private int regionStart;
    private int regionEnd;
    private int findPos;
    private int appendPos;
    private boolean matchFound;
    private int[] matchOffsets;
    private boolean anchoringBounds = true;
    private boolean transparentBounds;

    Matcher(Pattern pattern, CharSequence input) {
        this.usePattern(pattern);
        this.reset(input);
    }

    public Matcher appendReplacement(StringBuffer buffer, String replacement) {
        buffer.append(this.input.substring(this.appendPos, this.start()));
        this.appendEvaluated(buffer, replacement);
        this.appendPos = this.end();
        return this;
    }

    private void appendEvaluated(StringBuffer buffer, String s) {
        boolean escape = false;
        boolean dollar = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && !escape) {
                escape = true;
                continue;
            }
            if (c == '$' && !escape) {
                dollar = true;
                continue;
            }
            if (c >= '0' && c <= '9' && dollar) {
                buffer.append(this.group(c - 48));
                dollar = false;
                continue;
            }
            buffer.append(c);
            dollar = false;
            escape = false;
        }
        if (escape) {
            throw new ArrayIndexOutOfBoundsException(s.length());
        }
    }

    public Matcher reset() {
        return this.reset(this.input, 0, this.input.length());
    }

    public Matcher reset(CharSequence input) {
        return this.reset(input, 0, input.length());
    }

    private Matcher reset(CharSequence input, int start, int end) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        if (start < 0 || end < 0 || start > input.length() || end > input.length() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        this.input = ((Object)input).toString();
        this.regionStart = start;
        this.regionEnd = end;
        this.resetForInput();
        this.matchFound = false;
        this.findPos = this.regionStart;
        this.appendPos = 0;
        return this;
    }

    public Matcher usePattern(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern;
        if (this.address != 0) {
            Matcher.closeImpl(this.address);
            this.address = 0;
        }
        this.address = Matcher.openImpl(pattern.address);
        if (this.input != null) {
            this.resetForInput();
        }
        this.matchOffsets = new int[(this.groupCount() + 1) * 2];
        this.matchFound = false;
        return this;
    }

    private void resetForInput() {
        Matcher.setInputImpl(this.address, this.input, this.regionStart, this.regionEnd);
        Matcher.useAnchoringBoundsImpl(this.address, this.anchoringBounds);
        Matcher.useTransparentBoundsImpl(this.address, this.transparentBounds);
    }

    public Matcher region(int start, int end) {
        return this.reset(this.input, start, end);
    }

    public StringBuffer appendTail(StringBuffer buffer) {
        if (this.appendPos < this.regionEnd) {
            buffer.append(this.input.substring(this.appendPos, this.regionEnd));
        }
        return buffer;
    }

    public String replaceFirst(String replacement) {
        this.reset();
        StringBuffer buffer = new StringBuffer(this.input.length());
        if (this.find()) {
            this.appendReplacement(buffer, replacement);
        }
        return this.appendTail(buffer).toString();
    }

    public String replaceAll(String replacement) {
        this.reset();
        StringBuffer buffer = new StringBuffer(this.input.length());
        while (this.find()) {
            this.appendReplacement(buffer, replacement);
        }
        return this.appendTail(buffer).toString();
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public String group(int group) {
        this.ensureMatch();
        int from = this.matchOffsets[group * 2];
        int to = this.matchOffsets[group * 2 + 1];
        if (from == -1 || to == -1) {
            return null;
        }
        return this.input.substring(from, to);
    }

    public String group() {
        return this.group(0);
    }

    public boolean find(int start) {
        this.findPos = start;
        if (this.findPos < this.regionStart) {
            this.findPos = this.regionStart;
        } else if (this.findPos >= this.regionEnd) {
            this.matchFound = false;
            return false;
        }
        this.matchFound = Matcher.findImpl(this.address, this.input, this.findPos, this.matchOffsets);
        if (this.matchFound) {
            this.findPos = this.matchOffsets[1];
        }
        return this.matchFound;
    }

    public boolean find() {
        this.matchFound = Matcher.findNextImpl(this.address, this.input, this.matchOffsets);
        if (this.matchFound) {
            this.findPos = this.matchOffsets[1];
        }
        return this.matchFound;
    }

    public boolean lookingAt() {
        this.matchFound = Matcher.lookingAtImpl(this.address, this.input, this.matchOffsets);
        if (this.matchFound) {
            this.findPos = this.matchOffsets[1];
        }
        return this.matchFound;
    }

    public boolean matches() {
        this.matchFound = Matcher.matchesImpl(this.address, this.input, this.matchOffsets);
        if (this.matchFound) {
            this.findPos = this.matchOffsets[1];
        }
        return this.matchFound;
    }

    public int start(int group) throws IllegalStateException {
        this.ensureMatch();
        return this.matchOffsets[group * 2];
    }

    public int end(int group) {
        this.ensureMatch();
        return this.matchOffsets[group * 2 + 1];
    }

    public static String quoteReplacement(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$') {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }

    public int start() {
        return this.start(0);
    }

    public int groupCount() {
        return Matcher.groupCountImpl(this.address);
    }

    public int end() {
        return this.end(0);
    }

    public MatchResult toMatchResult() {
        this.ensureMatch();
        return new MatchResultImpl(this.input, this.matchOffsets);
    }

    public Matcher useAnchoringBounds(boolean value) {
        this.anchoringBounds = value;
        Matcher.useAnchoringBoundsImpl(this.address, value);
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useTransparentBounds(boolean value) {
        this.transparentBounds = value;
        Matcher.useTransparentBoundsImpl(this.address, value);
        return this;
    }

    private void ensureMatch() {
        if (!this.matchFound) {
            throw new IllegalStateException("No successful match so far");
        }
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public int regionStart() {
        return this.regionStart;
    }

    public int regionEnd() {
        return this.regionEnd;
    }

    public boolean requireEnd() {
        return Matcher.requireEndImpl(this.address);
    }

    public boolean hitEnd() {
        return Matcher.hitEndImpl(this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Matcher.closeImpl(this.address);
        }
        finally {
            super.finalize();
        }
    }

    private static native void closeImpl(int var0);

    private static native boolean findImpl(int var0, String var1, int var2, int[] var3);

    private static native boolean findNextImpl(int var0, String var1, int[] var2);

    private static native int groupCountImpl(int var0);

    private static native boolean hitEndImpl(int var0);

    private static native boolean lookingAtImpl(int var0, String var1, int[] var2);

    private static native boolean matchesImpl(int var0, String var1, int[] var2);

    private static native int openImpl(int var0);

    private static native boolean requireEndImpl(int var0);

    private static native void setInputImpl(int var0, String var1, int var2, int var3);

    private static native void useAnchoringBoundsImpl(int var0, boolean var1);

    private static native void useTransparentBoundsImpl(int var0, boolean var1);
}

