/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter {
    private static final String METACHARACTERS = "\\?*+[](){}^$.|";

    private Splitter() {
    }

    public static String[] fastSplit(String re, String input, int limit) {
        int end;
        int len = re.length();
        if (len == 0) {
            return null;
        }
        char ch = re.charAt(0);
        if (len != 1 || METACHARACTERS.indexOf(ch) != -1) {
            if (len == 2 && ch == '\\') {
                ch = re.charAt(1);
                if (METACHARACTERS.indexOf(ch) == -1) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (input.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> list = new ArrayList<String>();
        int maxSize = limit <= 0 ? Integer.MAX_VALUE : limit;
        int begin = 0;
        while ((end = input.indexOf(ch, begin)) != -1 && list.size() + 1 < maxSize) {
            list.add(input.substring(begin, end));
            begin = end + 1;
        }
        return Splitter.finishSplit(list, input, begin, maxSize, limit);
    }

    public static String[] split(Pattern pattern, String re, String input, int limit) {
        String[] fastResult = Splitter.fastSplit(re, input, limit);
        if (fastResult != null) {
            return fastResult;
        }
        if (input.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> list = new ArrayList<String>();
        int maxSize = limit <= 0 ? Integer.MAX_VALUE : limit;
        Matcher matcher = new Matcher(pattern, input);
        int begin = 0;
        while (matcher.find() && list.size() + 1 < maxSize) {
            list.add(input.substring(begin, matcher.start()));
            begin = matcher.end();
        }
        return Splitter.finishSplit(list, input, begin, maxSize, limit);
    }

    private static String[] finishSplit(List<String> list, String input, int begin, int maxSize, int limit) {
        if (begin < input.length()) {
            list.add(input.substring(begin));
        } else if (limit != 0) {
            list.add("");
        }
        if (limit == 0) {
            for (int i = list.size() - 1; i >= 0 && list.get(i).isEmpty(); --i) {
                list.remove(i);
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

