/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import libcore.io.Streams;

public class DeflaterOutputStream
extends FilterOutputStream {
    static final int BUF_SIZE = 512;
    protected byte[] buf;
    protected Deflater def;
    boolean done = false;
    private final boolean syncFlush;

    public DeflaterOutputStream(OutputStream os, Deflater def) {
        this(os, def, 512, false);
    }

    public DeflaterOutputStream(OutputStream os) {
        this(os, new Deflater(), 512, false);
    }

    public DeflaterOutputStream(OutputStream os, Deflater def, int bsize) {
        this(os, def, bsize, false);
    }

    public DeflaterOutputStream(OutputStream os, boolean syncFlush) {
        this(os, new Deflater(), 512, syncFlush);
    }

    public DeflaterOutputStream(OutputStream os, Deflater def, boolean syncFlush) {
        this(os, def, 512, syncFlush);
    }

    public DeflaterOutputStream(OutputStream os, Deflater def, int bsize, boolean syncFlush) {
        super(os);
        if (os == null || def == null) {
            throw new NullPointerException();
        }
        if (bsize <= 0) {
            throw new IllegalArgumentException();
        }
        this.def = def;
        this.syncFlush = syncFlush;
        this.buf = new byte[bsize];
    }

    protected void deflate() throws IOException {
        int byteCount;
        while ((byteCount = this.def.deflate(this.buf)) != 0) {
            this.out.write(this.buf, 0, byteCount);
        }
    }

    public void close() throws IOException {
        if (!this.def.finished()) {
            this.finish();
        }
        this.def.end();
        this.out.close();
    }

    public void finish() throws IOException {
        if (this.done) {
            return;
        }
        this.def.finish();
        while (!this.def.finished()) {
            int byteCount = this.def.deflate(this.buf);
            this.out.write(this.buf, 0, byteCount);
        }
        this.done = true;
    }

    public void write(int i) throws IOException {
        Streams.writeSingleByte(this, i);
    }

    public void write(byte[] buffer, int offset, int byteCount) throws IOException {
        if (this.done) {
            throw new IOException("attempt to write after finish");
        }
        Arrays.checkOffsetAndCount(buffer.length, offset, byteCount);
        if (!this.def.needsInput()) {
            throw new IOException();
        }
        this.def.setInput(buffer, offset, byteCount);
        this.deflate();
    }

    public void flush() throws IOException {
        if (this.syncFlush) {
            int byteCount;
            while ((byteCount = this.def.deflate(this.buf, 0, this.buf.length, 2)) != 0) {
                this.out.write(this.buf, 0, byteCount);
            }
        }
        this.out.flush();
    }
}

