/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charsets;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipConstants;
import java.util.zip.ZipException;
import libcore.io.BufferIterator;
import libcore.io.HeapBufferIterator;
import libcore.io.Streams;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    String comment;
    long compressedSize = -1L;
    long crc = -1L;
    long size = -1L;
    int compressionMethod = -1;
    int time = -1;
    int modDate = -1;
    byte[] extra;
    int nameLength = -1;
    long mLocalHeaderRelOffset = -1L;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;

    public ZipEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException("Name too long: " + name.length());
        }
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.compressionMethod;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        if (this.time != -1) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(14, 0);
            cal.set(1980 + (this.modDate >> 9 & 0x7F), (this.modDate >> 5 & 0xF) - 1, this.modDate & 0x1F, this.time >> 11 & 0x1F, this.time >> 5 & 0x3F, (this.time & 0x1F) << 1);
            return cal.getTime().getTime();
        }
        return -1L;
    }

    public boolean isDirectory() {
        return this.name.charAt(this.name.length() - 1) == '/';
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public void setCompressedSize(long value) {
        this.compressedSize = value;
    }

    public void setCrc(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Bad CRC32: " + value);
        }
        this.crc = value;
    }

    public void setExtra(byte[] data) {
        if (data != null && data.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = data;
    }

    public void setMethod(int value) {
        if (value != 0 && value != 8) {
            throw new IllegalArgumentException("Bad method: " + value);
        }
        this.compressionMethod = value;
    }

    public void setSize(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Bad size: " + value);
        }
        this.size = value;
    }

    public void setTime(long value) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(value));
        int year = cal.get(1);
        if (year < 1980) {
            this.modDate = 33;
            this.time = 0;
        } else {
            this.modDate = cal.get(5);
            this.modDate = cal.get(2) + 1 << 5 | this.modDate;
            this.modDate = cal.get(1) - 1980 << 9 | this.modDate;
            this.time = cal.get(13) >> 1;
            this.time = cal.get(12) << 5 | this.time;
            this.time = cal.get(11) << 11 | this.time;
        }
    }

    public String toString() {
        return this.name;
    }

    public ZipEntry(ZipEntry ze) {
        this.name = ze.name;
        this.comment = ze.comment;
        this.time = ze.time;
        this.size = ze.size;
        this.compressedSize = ze.compressedSize;
        this.crc = ze.crc;
        this.compressionMethod = ze.compressionMethod;
        this.modDate = ze.modDate;
        this.extra = ze.extra;
        this.nameLength = ze.nameLength;
        this.mLocalHeaderRelOffset = ze.mLocalHeaderRelOffset;
    }

    public Object clone() {
        try {
            ZipEntry result = (ZipEntry)super.clone();
            result.extra = this.extra != null ? (byte[])this.extra.clone() : null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    ZipEntry(byte[] hdrBuf, InputStream in) throws IOException {
        Streams.readFully(in, hdrBuf, 0, hdrBuf.length);
        BufferIterator it = HeapBufferIterator.iterator(hdrBuf, 0, hdrBuf.length, ByteOrder.LITTLE_ENDIAN);
        int sig = it.readInt();
        if ((long)sig != 33639248L) {
            throw new ZipException("Central Directory Entry not found");
        }
        it.seek(10);
        this.compressionMethod = it.readShort();
        this.time = it.readShort();
        this.modDate = it.readShort();
        this.crc = (long)it.readInt() & 0xFFFFFFFFL;
        this.compressedSize = (long)it.readInt() & 0xFFFFFFFFL;
        this.size = (long)it.readInt() & 0xFFFFFFFFL;
        this.nameLength = it.readShort();
        short extraLength = it.readShort();
        short commentLength = it.readShort();
        it.seek(42);
        this.mLocalHeaderRelOffset = (long)it.readInt() & 0xFFFFFFFFL;
        byte[] nameBytes = new byte[this.nameLength];
        Streams.readFully(in, nameBytes, 0, nameBytes.length);
        this.name = new String(nameBytes, 0, nameBytes.length, Charsets.UTF_8);
        if (commentLength > 0) {
            byte[] commentBytes = new byte[commentLength];
            Streams.readFully(in, commentBytes, 0, commentLength);
            this.comment = new String(commentBytes, 0, commentBytes.length, Charsets.UTF_8);
        }
        if (extraLength > 0) {
            this.extra = new byte[extraLength];
            Streams.readFully(in, this.extra, 0, extraLength);
        }
    }
}

