/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import dalvik.system.CloseGuard;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import libcore.io.BufferIterator;
import libcore.io.HeapBufferIterator;
import libcore.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    static final int GPBF_DATA_DESCRIPTOR_FLAG = 8;
    static final int GPBF_UTF8_FLAG = 2048;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String fileName;
    private File fileToDeleteOnClose;
    private RandomAccessFile mRaf;
    private final LinkedHashMap<String, ZipEntry> mEntries = new LinkedHashMap();
    private final CloseGuard guard = CloseGuard.get();

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        this.fileName = file.getPath();
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException();
        }
        this.fileToDeleteOnClose = (mode & 4) != 0 ? file : null;
        this.mRaf = new RandomAccessFile(this.fileName, "r");
        this.readCentralDir();
        this.guard.open("close");
    }

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.guard.close();
        RandomAccessFile raf = this.mRaf;
        if (raf != null) {
            RandomAccessFile randomAccessFile = raf;
            synchronized (randomAccessFile) {
                this.mRaf = null;
                raf.close();
            }
            if (this.fileToDeleteOnClose != null) {
                this.fileToDeleteOnClose.delete();
                this.fileToDeleteOnClose = null;
            }
        }
    }

    private void checkNotClosed() {
        if (this.mRaf == null) {
            throw new IllegalStateException("Zip file closed");
        }
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.checkNotClosed();
        final Iterator iterator = this.mEntries.values().iterator();
        return new Enumeration<ZipEntry>(){

            @Override
            public boolean hasMoreElements() {
                ZipFile.this.checkNotClosed();
                return iterator.hasNext();
            }

            @Override
            public ZipEntry nextElement() {
                ZipFile.this.checkNotClosed();
                return (ZipEntry)iterator.next();
            }
        };
    }

    public ZipEntry getEntry(String entryName) {
        this.checkNotClosed();
        if (entryName == null) {
            throw new NullPointerException();
        }
        ZipEntry ze = this.mEntries.get(entryName);
        if (ze == null) {
            ze = this.mEntries.get(entryName + "/");
        }
        return ze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        RandomAccessFile raf;
        if ((entry = this.getEntry(entry.getName())) == null) {
            return null;
        }
        RandomAccessFile randomAccessFile = raf = this.mRaf;
        synchronized (randomAccessFile) {
            RAFStream rafstrm = new RAFStream(raf, entry.mLocalHeaderRelOffset + 28L);
            DataInputStream is = new DataInputStream(rafstrm);
            short localExtraLenOrWhatever = Short.reverseBytes(is.readShort());
            is.close();
            rafstrm.skip(entry.nameLength + localExtraLenOrWhatever);
            rafstrm.mLength = rafstrm.mOffset + entry.compressedSize;
            if (entry.compressionMethod == 8) {
                int bufSize = Math.max(1024, (int)Math.min(entry.getSize(), 65535L));
                return new ZipInflaterInputStream(rafstrm, new Inflater(true), bufSize, entry);
            }
            return rafstrm;
        }
    }

    public String getName() {
        return this.fileName;
    }

    public int size() {
        this.checkNotClosed();
        return this.mEntries.size();
    }

    private void readCentralDir() throws IOException {
        block5: {
            long scanOffset = this.mRaf.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("too short to be Zip");
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            int ENDHEADERMAGIC = 101010256;
            do {
                this.mRaf.seek(scanOffset);
                if (Integer.reverseBytes(this.mRaf.readInt()) == 101010256) break block5;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("EOCD not found; not a Zip archive?");
        }
        byte[] eocd = new byte[18];
        this.mRaf.readFully(eocd);
        BufferIterator it = HeapBufferIterator.iterator(eocd, 0, eocd.length, ByteOrder.LITTLE_ENDIAN);
        short diskNumber = it.readShort();
        short diskWithCentralDir = it.readShort();
        int numEntries = it.readShort();
        short totalNumEntries = it.readShort();
        it.skip(4);
        int centralDirOffset = it.readInt();
        if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new ZipException("spanned archives not supported");
        }
        RAFStream rafs = new RAFStream(this.mRaf, centralDirOffset);
        BufferedInputStream bin = new BufferedInputStream(rafs, 4096);
        byte[] hdrBuf = new byte[46];
        for (int i = 0; i < numEntries; ++i) {
            ZipEntry newEntry = new ZipEntry(hdrBuf, bin);
            this.mEntries.put(newEntry.getName(), newEntry);
        }
    }

    static class ZipInflaterInputStream
    extends InflaterInputStream {
        ZipEntry entry;
        long bytesRead = 0L;

        public ZipInflaterInputStream(InputStream is, Inflater inf, int bsize, ZipEntry entry) {
            super(is, inf, bsize);
            this.entry = entry;
        }

        public int read(byte[] buffer, int off, int nbytes) throws IOException {
            int i = super.read(buffer, off, nbytes);
            if (i != -1) {
                this.bytesRead += (long)i;
            }
            return i;
        }

        public int available() throws IOException {
            if (this.closed) {
                return 0;
            }
            return super.available() == 0 ? 0 : (int)(this.entry.getSize() - this.bytesRead);
        }
    }

    static class RAFStream
    extends InputStream {
        RandomAccessFile mSharedRaf;
        long mOffset;
        long mLength;

        public RAFStream(RandomAccessFile raf, long pos) throws IOException {
            this.mSharedRaf = raf;
            this.mOffset = pos;
            this.mLength = raf.length();
        }

        public int available() throws IOException {
            return this.mOffset < this.mLength ? 1 : 0;
        }

        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            RandomAccessFile randomAccessFile = this.mSharedRaf;
            synchronized (randomAccessFile) {
                int count;
                this.mSharedRaf.seek(this.mOffset);
                if ((long)len > this.mLength - this.mOffset) {
                    len = (int)(this.mLength - this.mOffset);
                }
                if ((count = this.mSharedRaf.read(b, off, len)) > 0) {
                    this.mOffset += (long)count;
                    return count;
                }
                return -1;
            }
        }

        public long skip(long byteCount) throws IOException {
            if (byteCount > this.mLength - this.mOffset) {
                byteCount = this.mLength - this.mOffset;
            }
            this.mOffset += byteCount;
            return byteCount;
        }
    }
}

