/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    private static final int ZIPLocalHeaderVersionNeeded = 20;
    private String comment;
    private final ArrayList<String> entries = new ArrayList();
    private int compressMethod = 8;
    private int compressLevel = -1;
    private ByteArrayOutputStream cDir = new ByteArrayOutputStream();
    private ZipEntry currentEntry;
    private final CRC32 crc = new CRC32();
    private int offset = 0;
    private int curOffset = 0;
    private int nameLength;
    private byte[] nameBytes;

    public ZipOutputStream(OutputStream p1) {
        super(p1, new Deflater(-1, true));
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.finish();
            this.def.end();
            this.out.close();
            this.out = null;
        }
    }

    public void closeEntry() throws IOException {
        this.checkClosed();
        if (this.currentEntry == null) {
            return;
        }
        if (this.currentEntry.getMethod() == 8) {
            super.finish();
        }
        if (this.currentEntry.getMethod() == 0) {
            if (this.crc.getValue() != this.currentEntry.crc) {
                throw new ZipException("CRC mismatch");
            }
            if (this.currentEntry.size != this.crc.tbytes) {
                throw new ZipException("Size mismatch");
            }
        }
        this.curOffset = 30;
        if (this.currentEntry.getMethod() != 0) {
            this.curOffset += 16;
            this.writeLong(this.out, 134695760L);
            this.currentEntry.crc = this.crc.getValue();
            this.writeLong(this.out, this.currentEntry.crc);
            this.currentEntry.compressedSize = this.def.getTotalOut();
            this.writeLong(this.out, this.currentEntry.compressedSize);
            this.currentEntry.size = this.def.getTotalIn();
            this.writeLong(this.out, this.currentEntry.size);
        }
        int flags = this.currentEntry.getMethod() == 0 ? 0 : 8;
        flags |= 0x800;
        this.writeLong(this.cDir, 33639248L);
        this.writeShort(this.cDir, 20);
        this.writeShort(this.cDir, 20);
        this.writeShort(this.cDir, flags);
        this.writeShort(this.cDir, this.currentEntry.getMethod());
        this.writeShort(this.cDir, this.currentEntry.time);
        this.writeShort(this.cDir, this.currentEntry.modDate);
        this.writeLong(this.cDir, this.crc.getValue());
        if (this.currentEntry.getMethod() == 8) {
            this.curOffset = (int)((long)this.curOffset + this.writeLong(this.cDir, this.def.getTotalOut()));
            this.writeLong(this.cDir, this.def.getTotalIn());
        } else {
            this.curOffset = (int)((long)this.curOffset + this.writeLong(this.cDir, this.crc.tbytes));
            this.writeLong(this.cDir, this.crc.tbytes);
        }
        this.curOffset += this.writeShort(this.cDir, this.nameLength);
        if (this.currentEntry.extra != null) {
            this.curOffset += this.writeShort(this.cDir, this.currentEntry.extra.length);
        } else {
            this.writeShort(this.cDir, 0);
        }
        String c = this.currentEntry.getComment();
        if (c != null) {
            this.writeShort(this.cDir, c.length());
        } else {
            this.writeShort(this.cDir, 0);
        }
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, 0);
        this.writeLong(this.cDir, 0L);
        this.writeLong(this.cDir, this.offset);
        this.cDir.write(this.nameBytes);
        this.nameBytes = null;
        if (this.currentEntry.extra != null) {
            this.cDir.write(this.currentEntry.extra);
        }
        this.offset += this.curOffset;
        if (c != null) {
            this.cDir.write(c.getBytes());
        }
        this.currentEntry = null;
        this.crc.reset();
        this.def.reset();
        this.done = false;
    }

    public void finish() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream is closed");
        }
        if (this.cDir == null) {
            return;
        }
        if (this.entries.isEmpty()) {
            throw new ZipException("No entries");
        }
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        int cdirSize = this.cDir.size();
        this.writeLong(this.cDir, 101010256L);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, this.entries.size());
        this.writeShort(this.cDir, this.entries.size());
        this.writeLong(this.cDir, cdirSize);
        this.writeLong(this.cDir, this.offset);
        if (this.comment != null) {
            this.writeShort(this.cDir, this.comment.length());
            this.cDir.write(this.comment.getBytes());
        } else {
            this.writeShort(this.cDir, 0);
        }
        this.out.write(this.cDir.toByteArray());
        this.cDir = null;
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        if (ze.getMethod() == 0 || this.compressMethod == 0 && ze.getMethod() == -1) {
            if (ze.crc == -1L) {
                throw new ZipException("CRC mismatch");
            }
            if (ze.size == -1L && ze.compressedSize == -1L) {
                throw new ZipException("Size mismatch");
            }
            if (ze.size != ze.compressedSize && ze.compressedSize != -1L && ze.size != -1L) {
                throw new ZipException("Size mismatch");
            }
        }
        this.checkClosed();
        if (this.entries.contains(ze.name)) {
            throw new ZipException("Entry already exists: " + ze.name);
        }
        this.nameBytes = ze.name.getBytes(Charsets.UTF_8);
        this.nameLength = this.nameBytes.length;
        if (this.nameLength > 65535) {
            throw new IllegalArgumentException("Name too long: " + this.nameLength + " UTF-8 bytes");
        }
        this.def.setLevel(this.compressLevel);
        this.currentEntry = ze;
        this.entries.add(this.currentEntry.name);
        if (this.currentEntry.getMethod() == -1) {
            this.currentEntry.setMethod(this.compressMethod);
        }
        int flags = this.currentEntry.getMethod() == 0 ? 0 : 8;
        this.writeLong(this.out, 67324752L);
        this.writeShort(this.out, 20);
        this.writeShort(this.out, flags |= 0x800);
        this.writeShort(this.out, this.currentEntry.getMethod());
        if (this.currentEntry.getTime() == -1L) {
            this.currentEntry.setTime(System.currentTimeMillis());
        }
        this.writeShort(this.out, this.currentEntry.time);
        this.writeShort(this.out, this.currentEntry.modDate);
        if (this.currentEntry.getMethod() == 0) {
            if (this.currentEntry.size == -1L) {
                this.currentEntry.size = this.currentEntry.compressedSize;
            } else if (this.currentEntry.compressedSize == -1L) {
                this.currentEntry.compressedSize = this.currentEntry.size;
            }
            this.writeLong(this.out, this.currentEntry.crc);
            this.writeLong(this.out, this.currentEntry.size);
            this.writeLong(this.out, this.currentEntry.size);
        } else {
            this.writeLong(this.out, 0L);
            this.writeLong(this.out, 0L);
            this.writeLong(this.out, 0L);
        }
        this.writeShort(this.out, this.nameLength);
        if (this.currentEntry.extra != null) {
            this.writeShort(this.out, this.currentEntry.extra.length);
        } else {
            this.writeShort(this.out, 0);
        }
        this.out.write(this.nameBytes);
        if (this.currentEntry.extra != null) {
            this.out.write(this.currentEntry.extra);
        }
    }

    public void setComment(String comment) {
        if (comment.length() > 65535) {
            throw new IllegalArgumentException("Comment too long: " + comment.length() + " characters");
        }
        this.comment = comment;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException();
        }
        this.compressLevel = level;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException();
        }
        this.compressMethod = method;
    }

    private long writeLong(OutputStream os, long i) throws IOException {
        os.write((int)(i & 0xFFL));
        os.write((int)(i >> 8) & 0xFF);
        os.write((int)(i >> 16) & 0xFF);
        os.write((int)(i >> 24) & 0xFF);
        return i;
    }

    private int writeShort(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
        return i;
    }

    public void write(byte[] buffer, int offset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, offset, byteCount);
        if (this.currentEntry == null) {
            throw new ZipException("No active entry");
        }
        if (this.currentEntry.getMethod() == 0) {
            this.out.write(buffer, offset, byteCount);
        } else {
            super.write(buffer, offset, byteCount);
        }
        this.crc.update(buffer, offset, byteCount);
    }

    private void checkClosed() throws IOException {
        if (this.cDir == null) {
            throw new IOException("Stream is closed");
        }
    }
}

