/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import libcore.io.Streams;

public class CipherInputStream
extends FilterInputStream {
    private static final int I_BUFFER_SIZE = 20;
    private final Cipher cipher;
    private final byte[] inputBuffer = new byte[20];
    private int index;
    private byte[] outputBuffer;
    private boolean finished;

    public CipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.cipher = c;
    }

    protected CipherInputStream(InputStream is) {
        this(is, new NullCipher());
    }

    public int read() throws IOException {
        if (this.finished) {
            return this.outputBuffer == null || this.index == this.outputBuffer.length ? -1 : this.outputBuffer[this.index++] & 0xFF;
        }
        if (this.outputBuffer != null && this.index < this.outputBuffer.length) {
            return this.outputBuffer[this.index++] & 0xFF;
        }
        this.index = 0;
        this.outputBuffer = null;
        while (this.outputBuffer == null) {
            int byteCount = this.in.read(this.inputBuffer);
            if (byteCount == -1) {
                try {
                    this.outputBuffer = this.cipher.doFinal();
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                this.finished = true;
                break;
            }
            this.outputBuffer = this.cipher.update(this.inputBuffer, 0, byteCount);
        }
        return this.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int i;
        if (this.in == null) {
            throw new NullPointerException("Underlying input stream is null");
        }
        for (i = 0; i < len; ++i) {
            int b = this.read();
            if (b == -1) {
                return i == 0 ? -1 : i;
            }
            if (buf == null) continue;
            buf[off + i] = (byte)b;
        }
        return i;
    }

    public long skip(long byteCount) throws IOException {
        return Streams.skipByReading(this, byteCount);
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
        try {
            this.cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        return false;
    }
}

