/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultHostnameVerifier
implements HostnameVerifier {
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};

    DefaultHostnameVerifier() {
    }

    @Override
    public final boolean verify(String host, SSLSession session) {
        Certificate[] certs;
        try {
            certs = session.getPeerCertificates();
        }
        catch (SSLException e) {
            return false;
        }
        X509Certificate x509 = (X509Certificate)certs[0];
        String hostName = host.trim().toLowerCase(Locale.ENGLISH);
        String firstCn = this.getFirstCn(x509);
        if (this.matches(hostName, firstCn)) {
            return true;
        }
        for (String cn : this.getDNSSubjectAlts(x509)) {
            if (!this.matches(hostName, cn)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String hostName, String cn) {
        if (cn == null) {
            return false;
        }
        if ((cn = cn.toLowerCase(Locale.ENGLISH)).startsWith("*.")) {
            int matchLength = cn.length() - 1;
            return hostName.regionMatches(hostName.length() - matchLength, cn, 1, matchLength) && cn.indexOf(46, 2) != -1 && this.acceptableCountryWildcard(cn) && !InetAddress.isNumeric(hostName);
        }
        return hostName.equals(cn);
    }

    private boolean acceptableCountryWildcard(String cn) {
        int cnLen = cn.length();
        if (cnLen >= 7 && cnLen <= 9 && cn.charAt(cnLen - 3) == '.') {
            String s = cn.substring(2, cnLen - 3);
            int x = Arrays.binarySearch(BAD_COUNTRY_2LDS, s);
            return x < 0;
        }
        return true;
    }

    private String getFirstCn(X509Certificate cert) {
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        for (String token : subjectPrincipal.split(",")) {
            int x = token.indexOf("CN=");
            if (x < 0) continue;
            return token.substring(x + 3);
        }
        return null;
    }

    private List<String> getDNSSubjectAlts(X509Certificate cert) {
        Collection<List<?>> subjectAlternativeNames;
        try {
            subjectAlternativeNames = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            System.logI("Error parsing certificate", cpe);
            return Collections.emptyList();
        }
        if (subjectAlternativeNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> subjectAltList = new ArrayList<String>();
        for (List<?> pair : subjectAlternativeNames) {
            int type = (Integer)pair.get(0);
            if (type != 2) continue;
            subjectAltList.add((String)pair.get(1));
        }
        return subjectAltList;
    }

    static {
        Arrays.sort(BAD_COUNTRY_2LDS);
    }
}

