/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFactoryFinder;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

public abstract class XPathFactory {
    public static final String DEFAULT_PROPERTY_NAME = "javax.xml.xpath.XPathFactory";
    public static final String DEFAULT_OBJECT_MODEL_URI = "http://java.sun.com/jaxp/xpath/dom";

    protected XPathFactory() {
    }

    public static final XPathFactory newInstance() {
        try {
            return XPathFactory.newInstance(DEFAULT_OBJECT_MODEL_URI);
        }
        catch (XPathFactoryConfigurationException xpathFactoryConfigurationException) {
            throw new RuntimeException("XPathFactory#newInstance() failed to create an XPathFactory for the default object model: http://java.sun.com/jaxp/xpath/dom with the XPathFactoryConfigurationException: " + xpathFactoryConfigurationException.toString());
        }
    }

    public static final XPathFactory newInstance(String uri) throws XPathFactoryConfigurationException {
        XPathFactory xpathFactory;
        if (uri == null) {
            throw new NullPointerException("XPathFactory#newInstance(String uri) cannot be called with uri == null");
        }
        if (uri.length() == 0) {
            throw new IllegalArgumentException("XPathFactory#newInstance(String uri) cannot be called with uri == \"\"");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = XPathFactory.class.getClassLoader();
        }
        if ((xpathFactory = new XPathFactoryFinder(classLoader).newFactory(uri)) == null) {
            throw new XPathFactoryConfigurationException("No XPathFactory implementation found for the object model: " + uri);
        }
        return xpathFactory;
    }

    public static XPathFactory newInstance(String uri, String factoryClassName, ClassLoader classLoader) throws XPathFactoryConfigurationException {
        XPathFactory xpathFactory;
        if (uri == null) {
            throw new NullPointerException("XPathFactory#newInstance(String uri) cannot be called with uri == null");
        }
        if (uri.length() == 0) {
            throw new IllegalArgumentException("XPathFactory#newInstance(String uri) cannot be called with uri == \"\"");
        }
        if (factoryClassName == null) {
            throw new XPathFactoryConfigurationException("factoryClassName cannot be null.");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((xpathFactory = new XPathFactoryFinder(classLoader).createInstance(factoryClassName)) == null || !xpathFactory.isObjectModelSupported(uri)) {
            throw new XPathFactoryConfigurationException("No XPathFactory implementation found for the object model: " + uri);
        }
        return xpathFactory;
    }

    public abstract boolean isObjectModelSupported(String var1);

    public abstract void setFeature(String var1, boolean var2) throws XPathFactoryConfigurationException;

    public abstract boolean getFeature(String var1) throws XPathFactoryConfigurationException;

    public abstract void setXPathVariableResolver(XPathVariableResolver var1);

    public abstract void setXPathFunctionResolver(XPathFunctionResolver var1);

    public abstract XPath newXPath();
}

