/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

public final class ErrorCode
extends Exception {
    public static final int U_ZERO_ERROR = 0;
    private static final int U_ILLEGAL_ARGUMENT_ERROR = 1;
    private static final int U_INDEX_OUTOFBOUNDS_ERROR = 8;
    public static final int U_INVALID_CHAR_FOUND = 10;
    public static final int U_TRUNCATED_CHAR_FOUND = 11;
    public static final int U_ILLEGAL_CHAR_FOUND = 12;
    public static final int U_BUFFER_OVERFLOW_ERROR = 15;
    private static final int U_UNSUPPORTED_ERROR = 16;
    private static final int U_ERROR_LIMIT = 21;
    private static final String[] ERROR_NAMES = new String[]{"U_ZERO_ERROR", "U_ILLEGAL_ARGUMENT_ERROR", "U_MISSING_RESOURCE_ERROR", "U_INVALID_FORMAT_ERROR", "U_FILE_ACCESS_ERROR", "U_INTERNAL_PROGRAM_ERROR", "U_MESSAGE_PARSE_ERROR", "U_MEMORY_ALLOCATION_ERROR", "U_INDEX_OUTOFBOUNDS_ERROR", "U_PARSE_ERROR", "U_INVALID_CHAR_FOUND", "U_TRUNCATED_CHAR_FOUND", "U_ILLEGAL_CHAR_FOUND", "U_INVALID_TABLE_FORMAT", "U_INVALID_TABLE_FILE", "U_BUFFER_OVERFLOW_ERROR", "U_UNSUPPORTED_ERROR", "U_RESOURCE_TYPE_MISMATCH", "U_ILLEGAL_ESCAPE_SEQUENCE", "U_UNSUPPORTED_ESCAPE_SEQUENCE"};

    public static boolean isFailure(int error) {
        return error > 0 && error < 21;
    }

    public static RuntimeException throwException(int error) {
        if (error <= 0 && error >= 21) {
            return null;
        }
        switch (error) {
            case 1: {
                return new IllegalArgumentException(ERROR_NAMES[error]);
            }
            case 8: 
            case 15: {
                return new ArrayIndexOutOfBoundsException(ERROR_NAMES[error]);
            }
            case 16: {
                return new UnsupportedOperationException(ERROR_NAMES[error]);
            }
        }
        throw new RuntimeException(ERROR_NAMES[error]);
    }
}

