/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;

public final class NativeBreakIterator
implements Cloneable {
    private static final int BI_CHAR_INSTANCE = 1;
    private static final int BI_WORD_INSTANCE = 2;
    private static final int BI_LINE_INSTANCE = 3;
    private static final int BI_SENT_INSTANCE = 4;
    private final int address;
    private final int type;
    private CharacterIterator charIter;

    private NativeBreakIterator(int address, int type) {
        this.address = address;
        this.type = type;
        this.charIter = new StringCharacterIterator("");
    }

    public Object clone() {
        int cloneAddr = NativeBreakIterator.cloneImpl(this.address);
        NativeBreakIterator clone = new NativeBreakIterator(cloneAddr, this.type);
        clone.charIter = this.charIter;
        return clone;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NativeBreakIterator)) {
            return false;
        }
        NativeBreakIterator rhs = (NativeBreakIterator)object;
        return this.type == rhs.type && this.charIter.equals(rhs.charIter);
    }

    public int hashCode() {
        return 42;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NativeBreakIterator.closeBreakIteratorImpl(this.address);
        }
        finally {
            super.finalize();
        }
    }

    public int current() {
        return NativeBreakIterator.currentImpl(this.address);
    }

    public int first() {
        return NativeBreakIterator.firstImpl(this.address);
    }

    public int following(int offset) {
        return NativeBreakIterator.followingImpl(this.address, offset);
    }

    public CharacterIterator getText() {
        int newLoc = NativeBreakIterator.currentImpl(this.address);
        this.charIter.setIndex(newLoc);
        return this.charIter;
    }

    public int last() {
        return NativeBreakIterator.lastImpl(this.address);
    }

    public int next(int n) {
        return NativeBreakIterator.nextImpl(this.address, n);
    }

    public int next() {
        return NativeBreakIterator.nextImpl(this.address, 1);
    }

    public int previous() {
        return NativeBreakIterator.previousImpl(this.address);
    }

    public void setText(CharacterIterator newText) {
        StringBuilder sb = new StringBuilder();
        char c = newText.first();
        while (c != '\uffff') {
            sb.append(c);
            c = newText.next();
        }
        this.setText(sb.toString(), newText);
    }

    public void setText(String newText) {
        this.setText(newText, new StringCharacterIterator(newText));
    }

    private void setText(String s, CharacterIterator it) {
        this.charIter = it;
        NativeBreakIterator.setTextImpl(this.address, s);
    }

    public boolean isBoundary(int offset) {
        return NativeBreakIterator.isBoundaryImpl(this.address, offset);
    }

    public int preceding(int offset) {
        return NativeBreakIterator.precedingImpl(this.address, offset);
    }

    public static NativeBreakIterator getCharacterInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getCharacterInstanceImpl(where.toString()), 1);
    }

    public static NativeBreakIterator getLineInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getLineInstanceImpl(where.toString()), 3);
    }

    public static NativeBreakIterator getSentenceInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getSentenceInstanceImpl(where.toString()), 4);
    }

    public static NativeBreakIterator getWordInstance(Locale where) {
        return new NativeBreakIterator(NativeBreakIterator.getWordInstanceImpl(where.toString()), 2);
    }

    private static native int getCharacterInstanceImpl(String var0);

    private static native int getWordInstanceImpl(String var0);

    private static native int getLineInstanceImpl(String var0);

    private static native int getSentenceInstanceImpl(String var0);

    private static native void closeBreakIteratorImpl(int var0);

    private static native void setTextImpl(int var0, String var1);

    private static native int cloneImpl(int var0);

    private static native int precedingImpl(int var0, int var1);

    private static native boolean isBoundaryImpl(int var0, int var1);

    private static native int nextImpl(int var0, int var1);

    private static native int previousImpl(int var0);

    private static native int currentImpl(int var0);

    private static native int firstImpl(int var0);

    private static native int followingImpl(int var0, int var1);

    private static native int lastImpl(int var0);
}

