/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.NoSuchElementException;
import libcore.icu.LocaleData;

public final class NativeDecimalFormat {
    private static final int UNUM_DECIMAL_SEPARATOR_SYMBOL = 0;
    private static final int UNUM_GROUPING_SEPARATOR_SYMBOL = 1;
    private static final int UNUM_PATTERN_SEPARATOR_SYMBOL = 2;
    private static final int UNUM_PERCENT_SYMBOL = 3;
    private static final int UNUM_ZERO_DIGIT_SYMBOL = 4;
    private static final int UNUM_DIGIT_SYMBOL = 5;
    private static final int UNUM_MINUS_SIGN_SYMBOL = 6;
    private static final int UNUM_PLUS_SIGN_SYMBOL = 7;
    private static final int UNUM_CURRENCY_SYMBOL = 8;
    private static final int UNUM_INTL_CURRENCY_SYMBOL = 9;
    private static final int UNUM_MONETARY_SEPARATOR_SYMBOL = 10;
    private static final int UNUM_EXPONENTIAL_SYMBOL = 11;
    private static final int UNUM_PERMILL_SYMBOL = 12;
    private static final int UNUM_PAD_ESCAPE_SYMBOL = 13;
    private static final int UNUM_INFINITY_SYMBOL = 14;
    private static final int UNUM_NAN_SYMBOL = 15;
    private static final int UNUM_SIGNIFICANT_DIGIT_SYMBOL = 16;
    private static final int UNUM_MONETARY_GROUPING_SEPARATOR_SYMBOL = 17;
    private static final int UNUM_FORMAT_SYMBOL_COUNT = 18;
    private static final int UNUM_PARSE_INT_ONLY = 0;
    private static final int UNUM_GROUPING_USED = 1;
    private static final int UNUM_DECIMAL_ALWAYS_SHOWN = 2;
    private static final int UNUM_MAX_INTEGER_DIGITS = 3;
    private static final int UNUM_MIN_INTEGER_DIGITS = 4;
    private static final int UNUM_INTEGER_DIGITS = 5;
    private static final int UNUM_MAX_FRACTION_DIGITS = 6;
    private static final int UNUM_MIN_FRACTION_DIGITS = 7;
    private static final int UNUM_FRACTION_DIGITS = 8;
    private static final int UNUM_MULTIPLIER = 9;
    private static final int UNUM_GROUPING_SIZE = 10;
    private static final int UNUM_ROUNDING_MODE = 11;
    private static final int UNUM_ROUNDING_INCREMENT = 12;
    private static final int UNUM_FORMAT_WIDTH = 13;
    private static final int UNUM_PADDING_POSITION = 14;
    private static final int UNUM_SECONDARY_GROUPING_SIZE = 15;
    private static final int UNUM_SIGNIFICANT_DIGITS_USED = 16;
    private static final int UNUM_MIN_SIGNIFICANT_DIGITS = 17;
    private static final int UNUM_MAX_SIGNIFICANT_DIGITS = 18;
    private static final int UNUM_LENIENT_PARSE = 19;
    private static final int UNUM_POSITIVE_PREFIX = 0;
    private static final int UNUM_POSITIVE_SUFFIX = 1;
    private static final int UNUM_NEGATIVE_PREFIX = 2;
    private static final int UNUM_NEGATIVE_SUFFIX = 3;
    private static final int UNUM_PADDING_CHARACTER = 4;
    private static final int UNUM_CURRENCY_CODE = 5;
    private static final int UNUM_DEFAULT_RULESET = 6;
    private static final int UNUM_PUBLIC_RULESETS = 7;
    private int address;
    private String lastPattern;
    private boolean negPrefNull;
    private boolean negSuffNull;
    private boolean posPrefNull;
    private boolean posSuffNull;
    private transient boolean parseBigDecimal;
    private BigDecimal multiplierBigDecimal = null;

    public NativeDecimalFormat(String pattern, DecimalFormatSymbols dfs) {
        try {
            this.address = NativeDecimalFormat.open(pattern, dfs.getCurrencySymbol(), dfs.getDecimalSeparator(), dfs.getDigit(), dfs.getExponentSeparator(), dfs.getGroupingSeparator(), dfs.getInfinity(), dfs.getInternationalCurrencySymbol(), dfs.getMinusSign(), dfs.getMonetaryDecimalSeparator(), dfs.getNaN(), dfs.getPatternSeparator(), dfs.getPercent(), dfs.getPerMill(), dfs.getZeroDigit());
            this.lastPattern = pattern;
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("syntax error: " + re.getMessage() + ": " + pattern);
        }
    }

    public NativeDecimalFormat(String pattern, LocaleData data) {
        this.address = NativeDecimalFormat.open(pattern, data.currencySymbol, data.decimalSeparator, '#', data.exponentSeparator, data.groupingSeparator, data.infinity, data.internationalCurrencySymbol, data.minusSign, data.monetarySeparator, data.NaN, data.patternSeparator, data.percent, data.perMill, data.zeroDigit);
        this.lastPattern = pattern;
    }

    private NativeDecimalFormat(NativeDecimalFormat other) {
        this.address = NativeDecimalFormat.cloneImpl(other.address);
        this.lastPattern = other.lastPattern;
        this.negPrefNull = other.negPrefNull;
        this.negSuffNull = other.negSuffNull;
        this.posPrefNull = other.posPrefNull;
        this.posSuffNull = other.posSuffNull;
    }

    public int hashCode() {
        return this.getPositivePrefix().hashCode();
    }

    public synchronized void close() {
        if (this.address != 0) {
            NativeDecimalFormat.close(this.address);
            this.address = 0;
        }
    }

    public Object clone() {
        return new NativeDecimalFormat(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NativeDecimalFormat)) {
            return false;
        }
        NativeDecimalFormat obj = (NativeDecimalFormat)object;
        if (obj.address == this.address) {
            return true;
        }
        return obj.toPattern().equals(this.toPattern()) && obj.isDecimalSeparatorAlwaysShown() == this.isDecimalSeparatorAlwaysShown() && obj.getGroupingSize() == this.getGroupingSize() && obj.getMultiplier() == this.getMultiplier() && obj.getNegativePrefix().equals(this.getNegativePrefix()) && obj.getNegativeSuffix().equals(this.getNegativeSuffix()) && obj.getPositivePrefix().equals(this.getPositivePrefix()) && obj.getPositiveSuffix().equals(this.getPositiveSuffix()) && obj.getMaximumIntegerDigits() == this.getMaximumIntegerDigits() && obj.getMaximumFractionDigits() == this.getMaximumFractionDigits() && obj.getMinimumIntegerDigits() == this.getMinimumIntegerDigits() && obj.getMinimumFractionDigits() == this.getMinimumFractionDigits() && obj.isGroupingUsed() == this.isGroupingUsed();
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols dfs) {
        NativeDecimalFormat.setDecimalFormatSymbols(this.address, dfs.getCurrencySymbol(), dfs.getDecimalSeparator(), dfs.getDigit(), dfs.getExponentSeparator(), dfs.getGroupingSeparator(), dfs.getInfinity(), dfs.getInternationalCurrencySymbol(), dfs.getMinusSign(), dfs.getMonetaryDecimalSeparator(), dfs.getNaN(), dfs.getPatternSeparator(), dfs.getPercent(), dfs.getPerMill(), dfs.getZeroDigit());
    }

    public void setDecimalFormatSymbols(LocaleData localeData) {
        NativeDecimalFormat.setDecimalFormatSymbols(this.address, localeData.currencySymbol, localeData.decimalSeparator, '#', localeData.exponentSeparator, localeData.groupingSeparator, localeData.infinity, localeData.internationalCurrencySymbol, localeData.minusSign, localeData.monetarySeparator, localeData.NaN, localeData.patternSeparator, localeData.percent, localeData.perMill, localeData.zeroDigit);
    }

    public char[] formatBigDecimal(BigDecimal value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatDigitList(this.address, value.toString(), fpi);
        if (fpi != null) {
            FieldPositionIterator.setFieldPosition(fpi, field);
        }
        return result;
    }

    public char[] formatBigInteger(BigInteger value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatDigitList(this.address, value.toString(10), fpi);
        if (fpi != null) {
            FieldPositionIterator.setFieldPosition(fpi, field);
        }
        return result;
    }

    public char[] formatLong(long value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatLong(this.address, value, fpi);
        if (fpi != null) {
            FieldPositionIterator.setFieldPosition(fpi, field);
        }
        return result;
    }

    public char[] formatDouble(double value, FieldPosition field) {
        FieldPositionIterator fpi = FieldPositionIterator.forFieldPosition(field);
        char[] result = NativeDecimalFormat.formatDouble(this.address, value, fpi);
        if (fpi != null) {
            FieldPositionIterator.setFieldPosition(fpi, field);
        }
        return result;
    }

    public void applyLocalizedPattern(String pattern) {
        NativeDecimalFormat.applyPattern(this.address, true, pattern);
        this.lastPattern = null;
    }

    public void applyPattern(String pattern) {
        if (this.lastPattern != null && pattern.equals(this.lastPattern)) {
            return;
        }
        NativeDecimalFormat.applyPattern(this.address, false, pattern);
        this.lastPattern = pattern;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        String text;
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException();
        }
        Number number = (Number)object;
        FieldPositionIterator fpIter = new FieldPositionIterator();
        if (number instanceof BigInteger || number instanceof BigDecimal) {
            text = new String(NativeDecimalFormat.formatDigitList(this.address, number.toString(), fpIter));
        } else if (number instanceof Double || number instanceof Float) {
            double dv = number.doubleValue();
            text = new String(NativeDecimalFormat.formatDouble(this.address, dv, fpIter));
        } else {
            long lv = number.longValue();
            text = new String(NativeDecimalFormat.formatLong(this.address, lv, fpIter));
        }
        AttributedString as = new AttributedString(text);
        while (fpIter.next()) {
            Format.Field field = fpIter.field();
            as.addAttribute(field, field, fpIter.start(), fpIter.limit());
        }
        return as.getIterator();
    }

    private int makeScalePositive(int scale, StringBuilder val) {
        if (scale < 0) {
            for (int i = scale = -scale; i > 0; --i) {
                val.append('0');
            }
            scale = 0;
        }
        return scale;
    }

    public String toLocalizedPattern() {
        return NativeDecimalFormat.toPatternImpl(this.address, true);
    }

    public String toPattern() {
        return NativeDecimalFormat.toPatternImpl(this.address, false);
    }

    public Number parse(String string, ParsePosition position) {
        return NativeDecimalFormat.parse(this.address, string, position, this.parseBigDecimal);
    }

    public int getMaximumFractionDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 6);
    }

    public int getMaximumIntegerDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 3);
    }

    public int getMinimumFractionDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 7);
    }

    public int getMinimumIntegerDigits() {
        return NativeDecimalFormat.getAttribute(this.address, 4);
    }

    public int getGroupingSize() {
        return NativeDecimalFormat.getAttribute(this.address, 10);
    }

    public int getMultiplier() {
        return NativeDecimalFormat.getAttribute(this.address, 9);
    }

    public String getNegativePrefix() {
        if (this.negPrefNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 2);
    }

    public String getNegativeSuffix() {
        if (this.negSuffNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 3);
    }

    public String getPositivePrefix() {
        if (this.posPrefNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 0);
    }

    public String getPositiveSuffix() {
        if (this.posSuffNull) {
            return null;
        }
        return NativeDecimalFormat.getTextAttribute(this.address, 1);
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return NativeDecimalFormat.getAttribute(this.address, 2) != 0;
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public boolean isParseIntegerOnly() {
        return NativeDecimalFormat.getAttribute(this.address, 0) != 0;
    }

    public boolean isGroupingUsed() {
        return NativeDecimalFormat.getAttribute(this.address, 1) != 0;
    }

    public void setDecimalSeparatorAlwaysShown(boolean value) {
        int i = value ? -1 : 0;
        NativeDecimalFormat.setAttribute(this.address, 2, i);
    }

    public void setCurrency(Currency currency) {
        NativeDecimalFormat.setSymbol(this.address, 8, currency.getSymbol());
        NativeDecimalFormat.setSymbol(this.address, 9, currency.getCurrencyCode());
    }

    public void setGroupingSize(int value) {
        NativeDecimalFormat.setAttribute(this.address, 10, value);
    }

    public void setGroupingUsed(boolean value) {
        int i = value ? -1 : 0;
        NativeDecimalFormat.setAttribute(this.address, 1, i);
    }

    public void setMaximumFractionDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 6, value);
    }

    public void setMaximumIntegerDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 3, value);
    }

    public void setMinimumFractionDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 7, value);
    }

    public void setMinimumIntegerDigits(int value) {
        NativeDecimalFormat.setAttribute(this.address, 4, value);
    }

    public void setMultiplier(int value) {
        NativeDecimalFormat.setAttribute(this.address, 9, value);
        this.multiplierBigDecimal = BigDecimal.valueOf(value);
    }

    public void setNegativePrefix(String value) {
        boolean bl = this.negPrefNull = value == null;
        if (!this.negPrefNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 2, value);
        }
    }

    public void setNegativeSuffix(String value) {
        boolean bl = this.negSuffNull = value == null;
        if (!this.negSuffNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 3, value);
        }
    }

    public void setPositivePrefix(String value) {
        boolean bl = this.posPrefNull = value == null;
        if (!this.posPrefNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 0, value);
        }
    }

    public void setPositiveSuffix(String value) {
        boolean bl = this.posSuffNull = value == null;
        if (!this.posSuffNull) {
            NativeDecimalFormat.setTextAttribute(this.address, 1, value);
        }
    }

    public void setParseBigDecimal(boolean value) {
        this.parseBigDecimal = value;
    }

    public void setParseIntegerOnly(boolean value) {
        int i = value ? -1 : 0;
        NativeDecimalFormat.setAttribute(this.address, 0, i);
    }

    private static void applyPattern(int addr, boolean localized, String pattern) {
        try {
            NativeDecimalFormat.applyPatternImpl(addr, localized, pattern);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("syntax error: " + re.getMessage() + ": " + pattern);
        }
    }

    public void setRoundingMode(RoundingMode roundingMode, double roundingIncrement) {
        int nativeRoundingMode;
        switch (roundingMode) {
            case CEILING: {
                nativeRoundingMode = 0;
                break;
            }
            case FLOOR: {
                nativeRoundingMode = 1;
                break;
            }
            case DOWN: {
                nativeRoundingMode = 2;
                break;
            }
            case UP: {
                nativeRoundingMode = 3;
                break;
            }
            case HALF_EVEN: {
                nativeRoundingMode = 4;
                break;
            }
            case HALF_DOWN: {
                nativeRoundingMode = 5;
                break;
            }
            case HALF_UP: {
                nativeRoundingMode = 6;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        NativeDecimalFormat.setRoundingMode(this.address, nativeRoundingMode, roundingIncrement);
    }

    private static native void applyPatternImpl(int var0, boolean var1, String var2);

    private static native int cloneImpl(int var0);

    private static native void close(int var0);

    private static native char[] formatLong(int var0, long var1, FieldPositionIterator var3);

    private static native char[] formatDouble(int var0, double var1, FieldPositionIterator var3);

    private static native char[] formatDigitList(int var0, String var1, FieldPositionIterator var2);

    private static native int getAttribute(int var0, int var1);

    private static native String getTextAttribute(int var0, int var1);

    private static native int open(String var0, String var1, char var2, char var3, String var4, char var5, String var6, String var7, char var8, char var9, String var10, char var11, char var12, char var13, char var14);

    private static native Number parse(int var0, String var1, ParsePosition var2, boolean var3);

    private static native void setDecimalFormatSymbols(int var0, String var1, char var2, char var3, String var4, char var5, String var6, String var7, char var8, char var9, String var10, char var11, char var12, char var13, char var14);

    private static native void setSymbol(int var0, int var1, String var2);

    private static native void setAttribute(int var0, int var1, int var2);

    private static native void setRoundingMode(int var0, int var1, double var2);

    private static native void setTextAttribute(int var0, int var1, String var2);

    private static native String toPatternImpl(int var0, boolean var1);

    private static class FieldPositionIterator {
        private int[] data;
        private int pos = -3;
        private static Format.Field[] fields = new Format.Field[]{NumberFormat.Field.INTEGER, NumberFormat.Field.FRACTION, NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SIGN, NumberFormat.Field.EXPONENT, NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.CURRENCY, NumberFormat.Field.PERCENT, NumberFormat.Field.PERMILLE, NumberFormat.Field.SIGN};

        private FieldPositionIterator() {
        }

        public static FieldPositionIterator forFieldPosition(FieldPosition fp) {
            if (fp != null && fp.getField() != -1) {
                return new FieldPositionIterator();
            }
            return null;
        }

        private static int getNativeFieldPositionId(FieldPosition fp) {
            Format.Field attr;
            int id = fp.getField();
            if (id < -1 || id > 1) {
                id = -1;
            }
            if (id == -1 && (attr = fp.getFieldAttribute()) != null) {
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].equals(attr)) continue;
                    id = i;
                    break;
                }
            }
            return id;
        }

        private static void setFieldPosition(FieldPositionIterator fpi, FieldPosition fp) {
            int field;
            if (fpi != null && fp != null && (field = FieldPositionIterator.getNativeFieldPositionId(fp)) != -1) {
                while (fpi.next()) {
                    if (fpi.fieldId() != field) continue;
                    fp.setBeginIndex(fpi.start());
                    fp.setEndIndex(fpi.limit());
                    break;
                }
            }
        }

        public boolean next() {
            if (this.data == null || this.pos == this.data.length) {
                throw new NoSuchElementException();
            }
            this.pos += 3;
            return this.pos < this.data.length;
        }

        private void checkValid() {
            if (this.data == null || this.pos < 0 || this.pos == this.data.length) {
                throw new NoSuchElementException();
            }
        }

        public int fieldId() {
            return this.data[this.pos];
        }

        public Format.Field field() {
            this.checkValid();
            return fields[this.data[this.pos]];
        }

        public int start() {
            this.checkValid();
            return this.data[this.pos + 1];
        }

        public int limit() {
            this.checkValid();
            return this.data[this.pos + 2];
        }

        private void setData(int[] data) {
            this.data = data;
            this.pos = -3;
        }
    }
}

