/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.nio.ByteOrder;

public final class Memory {
    private Memory() {
    }

    public static native void unsafeBulkGet(Object var0, int var1, int var2, byte[] var3, int var4, int var5, boolean var6);

    public static native void unsafeBulkPut(byte[] var0, int var1, int var2, Object var3, int var4, int var5, boolean var6);

    public static int peekInt(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
        }
        return (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 0;
            int l = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 24;
        int h = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static short peekShort(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset] << 8 | src[offset + 1] & 0xFF);
        }
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static void pokeInt(byte[] dst, int offset, int value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 24 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset] = (byte)(value >> 24 & 0xFF);
        }
    }

    public static void pokeLong(byte[] dst, int offset, long value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            i = (int)value;
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset] = (byte)(i >> 0 & 0xFF);
        } else {
            int i = (int)value;
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset] = (byte)(i >> 24 & 0xFF);
        }
    }

    public static void pokeShort(byte[] dst, int offset, short value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset] = (byte)(value >> 8 & 0xFF);
        }
    }

    public static native void memmove(Object var0, int var1, Object var2, int var3, long var4);

    public static native byte peekByte(int var0);

    public static native int peekInt(int var0, boolean var1);

    public static native long peekLong(int var0, boolean var1);

    public static native short peekShort(int var0, boolean var1);

    public static native void peekByteArray(int var0, byte[] var1, int var2, int var3);

    public static native void peekCharArray(int var0, char[] var1, int var2, int var3, boolean var4);

    public static native void peekDoubleArray(int var0, double[] var1, int var2, int var3, boolean var4);

    public static native void peekFloatArray(int var0, float[] var1, int var2, int var3, boolean var4);

    public static native void peekIntArray(int var0, int[] var1, int var2, int var3, boolean var4);

    public static native void peekLongArray(int var0, long[] var1, int var2, int var3, boolean var4);

    public static native void peekShortArray(int var0, short[] var1, int var2, int var3, boolean var4);

    public static native void pokeByte(int var0, byte var1);

    public static native void pokeInt(int var0, int var1, boolean var2);

    public static native void pokeLong(int var0, long var1, boolean var3);

    public static native void pokeShort(int var0, short var1, boolean var2);

    public static native void pokeByteArray(int var0, byte[] var1, int var2, int var3);

    public static native void pokeCharArray(int var0, char[] var1, int var2, int var3, boolean var4);

    public static native void pokeDoubleArray(int var0, double[] var1, int var2, int var3, boolean var4);

    public static native void pokeFloatArray(int var0, float[] var1, int var2, int var3, boolean var4);

    public static native void pokeIntArray(int var0, int[] var1, int var2, int var3, boolean var4);

    public static native void pokeLongArray(int var0, long[] var1, int var2, int var3, boolean var4);

    public static native void pokeShortArray(int var0, short[] var1, int var2, int var3, boolean var4);
}

