/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;
import java.util.Arrays;
import libcore.io.Streams;
import libcore.net.http.AbstractHttpInputStream;
import libcore.net.http.HttpEngine;

final class ChunkedInputStream
extends AbstractHttpInputStream {
    private static final int MIN_LAST_CHUNK_LENGTH = "\r\n0\r\n\r\n".length();
    private static final int NO_CHUNK_YET = -1;
    private int bytesRemainingInChunk = -1;
    private boolean hasMoreChunks = true;

    ChunkedInputStream(InputStream is, CacheRequest cacheRequest, HttpEngine httpEngine) throws IOException {
        super(is, httpEngine, cacheRequest);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        int read;
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        this.checkNotClosed();
        if (!this.hasMoreChunks) {
            return -1;
        }
        if (this.bytesRemainingInChunk == 0 || this.bytesRemainingInChunk == -1) {
            this.readChunkSize();
            if (!this.hasMoreChunks) {
                return -1;
            }
        }
        if ((read = this.in.read(buffer, offset, Math.min(count, this.bytesRemainingInChunk))) == -1) {
            this.unexpectedEndOfInput();
            throw new IOException("unexpected end of stream");
        }
        this.bytesRemainingInChunk -= read;
        this.cacheWrite(buffer, offset, read);
        if (this.bytesRemainingInChunk == 0 && this.in.available() >= MIN_LAST_CHUNK_LENGTH) {
            this.readChunkSize();
        }
        return read;
    }

    private void readChunkSize() throws IOException {
        String chunkSizeString;
        int index;
        if (this.bytesRemainingInChunk != -1) {
            Streams.readAsciiLine(this.in);
        }
        if ((index = (chunkSizeString = Streams.readAsciiLine(this.in)).indexOf(";")) != -1) {
            chunkSizeString = chunkSizeString.substring(0, index);
        }
        try {
            this.bytesRemainingInChunk = Integer.parseInt(chunkSizeString.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Expected a hex chunk size, but was " + chunkSizeString);
        }
        if (this.bytesRemainingInChunk == 0) {
            this.hasMoreChunks = false;
            this.httpEngine.readTrailers();
            this.endOfInput(true);
        }
    }

    public int available() throws IOException {
        this.checkNotClosed();
        if (!this.hasMoreChunks || this.bytesRemainingInChunk == -1) {
            return 0;
        }
        return Math.min(this.in.available(), this.bytesRemainingInChunk);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.hasMoreChunks) {
            this.unexpectedEndOfInput();
        }
    }
}

