/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import libcore.net.http.AbstractHttpOutputStream;

final class ChunkedOutputStream
extends AbstractHttpOutputStream {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] FINAL_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private final byte[] hex = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 13, 10};
    private final OutputStream socketOut;
    private final int maxChunkLength;
    private final ByteArrayOutputStream bufferedChunk;

    public ChunkedOutputStream(OutputStream socketOut, int maxChunkLength) {
        this.socketOut = socketOut;
        this.maxChunkLength = Math.max(1, this.dataLength(maxChunkLength));
        this.bufferedChunk = new ByteArrayOutputStream(maxChunkLength);
    }

    private int dataLength(int dataPlusHeaderLength) {
        int headerLength = 4;
        for (int i = dataPlusHeaderLength - headerLength; i > 0; i >>= 4) {
            ++headerLength;
        }
        return dataPlusHeaderLength - headerLength;
    }

    public synchronized void write(byte[] buffer, int offset, int count) throws IOException {
        this.checkNotClosed();
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        while (count > 0) {
            int numBytesWritten;
            if (this.bufferedChunk.size() > 0 || count < this.maxChunkLength) {
                numBytesWritten = Math.min(count, this.maxChunkLength - this.bufferedChunk.size());
                this.bufferedChunk.write(buffer, offset, numBytesWritten);
                if (this.bufferedChunk.size() == this.maxChunkLength) {
                    this.writeBufferedChunkToSocket();
                }
            } else {
                numBytesWritten = this.maxChunkLength;
                this.writeHex(numBytesWritten);
                this.socketOut.write(buffer, offset, numBytesWritten);
                this.socketOut.write(CRLF);
            }
            offset += numBytesWritten;
            count -= numBytesWritten;
        }
    }

    private void writeHex(int i) throws IOException {
        int cursor = 8;
        do {
            this.hex[--cursor] = HEX_DIGITS[i & 0xF];
        } while ((i >>>= 4) != 0);
        this.socketOut.write(this.hex, cursor, this.hex.length - cursor);
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeBufferedChunkToSocket();
        this.socketOut.flush();
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.writeBufferedChunkToSocket();
        this.socketOut.write(FINAL_CHUNK);
    }

    private void writeBufferedChunkToSocket() throws IOException {
        int size = this.bufferedChunk.size();
        if (size <= 0) {
            return;
        }
        this.writeHex(size);
        this.bufferedChunk.writeTo(this.socketOut);
        this.bufferedChunk.reset();
        this.socketOut.write(CRLF);
    }
}

