/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;
import java.util.Arrays;
import libcore.net.http.AbstractHttpInputStream;
import libcore.net.http.HttpEngine;

final class FixedLengthInputStream
extends AbstractHttpInputStream {
    private int bytesRemaining;

    public FixedLengthInputStream(InputStream is, CacheRequest cacheRequest, HttpEngine httpEngine, int length) throws IOException {
        super(is, httpEngine, cacheRequest);
        this.bytesRemaining = length;
        if (this.bytesRemaining == 0) {
            this.endOfInput(true);
        }
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        this.checkNotClosed();
        if (this.bytesRemaining == 0) {
            return -1;
        }
        int read = this.in.read(buffer, offset, Math.min(count, this.bytesRemaining));
        if (read == -1) {
            this.unexpectedEndOfInput();
            throw new IOException("unexpected end of stream");
        }
        this.bytesRemaining -= read;
        this.cacheWrite(buffer, offset, read);
        if (this.bytesRemaining == 0) {
            this.endOfInput(true);
        }
        return read;
    }

    public int available() throws IOException {
        this.checkNotClosed();
        return this.bytesRemaining == 0 ? 0 : Math.min(this.in.available(), this.bytesRemaining);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.bytesRemaining != 0) {
            this.unexpectedEndOfInput();
        }
    }
}

