/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import libcore.net.http.AbstractHttpOutputStream;

final class FixedLengthOutputStream
extends AbstractHttpOutputStream {
    private final OutputStream socketOut;
    private int bytesRemaining;

    public FixedLengthOutputStream(OutputStream socketOut, int bytesRemaining) {
        this.socketOut = socketOut;
        this.bytesRemaining = bytesRemaining;
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.checkNotClosed();
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        if (count > this.bytesRemaining) {
            throw new IOException("expected " + this.bytesRemaining + " bytes but received " + count);
        }
        this.socketOut.write(buffer, offset, count);
        this.bytesRemaining -= count;
    }

    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        this.socketOut.flush();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.bytesRemaining > 0) {
            throw new IOException("unexpected end of stream");
        }
    }
}

