/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import libcore.io.IoUtils;
import libcore.net.http.HttpConnectionPool;
import libcore.util.Objects;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl;

final class HttpConnection {
    private final Address address;
    private final Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SSLSocket unverifiedSocket;
    private SSLSocket sslSocket;
    private InputStream sslInputStream;
    private OutputStream sslOutputStream;

    private HttpConnection(Address config, int connectTimeout) throws IOException {
        this.address = config;
        Socket socketCandidate = null;
        InetAddress[] addresses = InetAddress.getAllByName(config.socketHost);
        for (int i = 0; i < addresses.length; ++i) {
            socketCandidate = config.proxy != null && config.proxy.type() != Proxy.Type.HTTP ? new Socket(config.proxy) : new Socket();
            try {
                socketCandidate.connect(new InetSocketAddress(addresses[i], config.socketPort), connectTimeout);
                break;
            }
            catch (IOException e) {
                if (i != addresses.length - 1) continue;
                throw e;
            }
        }
        this.socket = socketCandidate;
    }

    public static HttpConnection connect(URI uri, Proxy proxy, boolean requiresTunnel, int connectTimeout) throws IOException {
        if (proxy != null) {
            Address address = proxy.type() == Proxy.Type.DIRECT ? new Address(uri) : new Address(uri, proxy, requiresTunnel);
            return HttpConnectionPool.INSTANCE.get(address, connectTimeout);
        }
        ProxySelector selector = ProxySelector.getDefault();
        List<Proxy> proxyList = selector.select(uri);
        if (proxyList != null) {
            for (Proxy selectedProxy : proxyList) {
                if (selectedProxy.type() == Proxy.Type.DIRECT) continue;
                try {
                    Address address = new Address(uri, selectedProxy, requiresTunnel);
                    return HttpConnectionPool.INSTANCE.get(address, connectTimeout);
                }
                catch (IOException e) {
                    selector.connectFailed(uri, selectedProxy.address(), e);
                }
            }
        }
        return HttpConnectionPool.INSTANCE.get(new Address(uri), connectTimeout);
    }

    public void closeSocketAndStreams() {
        IoUtils.closeQuietly(this.sslOutputStream);
        IoUtils.closeQuietly(this.sslInputStream);
        IoUtils.closeQuietly(this.sslSocket);
        IoUtils.closeQuietly(this.outputStream);
        IoUtils.closeQuietly(this.inputStream);
        IoUtils.closeQuietly(this.socket);
    }

    public void setSoTimeout(int readTimeout) throws SocketException {
        this.socket.setSoTimeout(readTimeout);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.sslSocket != null) {
            if (this.sslOutputStream == null) {
                this.sslOutputStream = this.sslSocket.getOutputStream();
            }
            return this.sslOutputStream;
        }
        if (this.outputStream == null) {
            this.outputStream = this.socket.getOutputStream();
        }
        return this.outputStream;
    }

    public InputStream getInputStream() throws IOException {
        if (this.sslSocket != null) {
            if (this.sslInputStream == null) {
                this.sslInputStream = this.sslSocket.getInputStream();
            }
            return this.sslInputStream;
        }
        if (this.inputStream == null) {
            int bufferSize = 128;
            this.inputStream = this.address.requiresTunnel ? this.socket.getInputStream() : new BufferedInputStream(this.socket.getInputStream(), bufferSize);
        }
        return this.inputStream;
    }

    protected Socket getSocket() {
        return this.sslSocket != null ? this.sslSocket : this.socket;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setupSecureSocket(SSLSocketFactory sslSocketFactory, boolean tlsTolerant) throws IOException {
        this.unverifiedSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, this.address.uriHost, this.address.uriPort, true);
        if (tlsTolerant && this.unverifiedSocket instanceof OpenSSLSocketImpl) {
            OpenSSLSocketImpl openSslSocket = (OpenSSLSocketImpl)this.unverifiedSocket;
            openSslSocket.setEnabledCompressionMethods(new String[]{"ZLIB"});
            openSslSocket.setUseSessionTickets(true);
            openSslSocket.setHostname(this.address.socketHost);
        } else {
            this.unverifiedSocket.setEnabledProtocols(new String[]{"SSLv3"});
        }
        this.unverifiedSocket.startHandshake();
    }

    public SSLSocket verifySecureSocketHostname(HostnameVerifier hostnameVerifier) throws IOException {
        if (!hostnameVerifier.verify(this.address.uriHost, this.unverifiedSocket.getSession())) {
            throw new IOException("Hostname '" + this.address.uriHost + "' was not verified");
        }
        this.sslSocket = this.unverifiedSocket;
        return this.sslSocket;
    }

    public SSLSocket getSecureSocketIfConnected() {
        return this.sslSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isStale() throws IOException {
        if (!this.isEligibleForRecycling()) {
            return true;
        }
        InputStream in = this.getInputStream();
        if (in.available() > 0) {
            return false;
        }
        Socket socket = this.getSocket();
        int soTimeout = socket.getSoTimeout();
        try {
            socket.setSoTimeout(1);
            in.mark(1);
            int byteRead = in.read();
            if (byteRead != -1) {
                in.reset();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            socket.setSoTimeout(soTimeout);
        }
    }

    protected boolean isEligibleForRecycling() {
        return !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public static final class Address {
        private final Proxy proxy;
        private final boolean requiresTunnel;
        private final String uriHost;
        private final int uriPort;
        private final String socketHost;
        private final int socketPort;

        public Address(URI uri) {
            this.proxy = null;
            this.requiresTunnel = false;
            this.uriHost = uri.getHost();
            this.uriPort = uri.getEffectivePort();
            this.socketHost = this.uriHost;
            this.socketPort = this.uriPort;
        }

        public Address(URI uri, Proxy proxy, boolean requiresTunnel) {
            this.proxy = proxy;
            this.requiresTunnel = requiresTunnel;
            this.uriHost = uri.getHost();
            this.uriPort = uri.getEffectivePort();
            SocketAddress proxyAddress = proxy.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Proxy.address() is not an InetSocketAddress: " + proxyAddress.getClass());
            }
            InetSocketAddress proxySocketAddress = (InetSocketAddress)proxyAddress;
            this.socketHost = proxySocketAddress.getHostName();
            this.socketPort = proxySocketAddress.getPort();
        }

        public Proxy getProxy() {
            return this.proxy;
        }

        public boolean equals(Object other) {
            if (other instanceof Address) {
                Address that = (Address)other;
                return Objects.equal(this.proxy, that.proxy) && this.uriHost.equals(that.uriHost) && this.uriPort == that.uriPort && this.requiresTunnel == that.requiresTunnel;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.uriHost.hashCode();
            result = 31 * result + this.uriPort;
            result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
            result = 31 * result + (this.requiresTunnel ? 1 : 0);
            return result;
        }

        public HttpConnection connect(int connectTimeout) throws IOException {
            return new HttpConnection(this, connectTimeout);
        }
    }
}

