/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import dalvik.system.SocketTagger;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import libcore.net.http.HttpConnection;

final class HttpConnectionPool {
    public static final HttpConnectionPool INSTANCE = new HttpConnectionPool();
    private final int maxConnections;
    private final HashMap<HttpConnection.Address, List<HttpConnection>> connectionPool = new HashMap();

    private HttpConnectionPool() {
        String keepAlive = System.getProperty("http.keepAlive");
        if (keepAlive != null && !Boolean.parseBoolean(keepAlive)) {
            this.maxConnections = 0;
            return;
        }
        String maxConnectionsString = System.getProperty("http.maxConnections");
        this.maxConnections = maxConnectionsString != null ? Integer.parseInt(maxConnectionsString) : 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection get(HttpConnection.Address address, int connectTimeout) throws IOException {
        HashMap<HttpConnection.Address, List<HttpConnection>> hashMap = this.connectionPool;
        synchronized (hashMap) {
            List<HttpConnection> connections = this.connectionPool.get(address);
            if (connections != null) {
                while (!connections.isEmpty()) {
                    HttpConnection connection = connections.remove(connections.size() - 1);
                    if (connection.isStale()) continue;
                    Socket socket = connection.getSocket();
                    SocketTagger.get().tag(socket);
                    return connection;
                }
                this.connectionPool.remove(address);
            }
        }
        return address.connect(connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(HttpConnection connection) {
        Socket socket = connection.getSocket();
        try {
            SocketTagger.get().untag(socket);
        }
        catch (SocketException e) {
            System.logW("Unable to untagSocket(): " + e);
            connection.closeSocketAndStreams();
            return;
        }
        if (this.maxConnections > 0 && connection.isEligibleForRecycling()) {
            HttpConnection.Address address = connection.getAddress();
            HashMap<HttpConnection.Address, List<HttpConnection>> hashMap = this.connectionPool;
            synchronized (hashMap) {
                List<HttpConnection> connections = this.connectionPool.get(address);
                if (connections == null) {
                    connections = new ArrayList<HttpConnection>();
                    this.connectionPool.put(address, connections);
                }
                if (connections.size() < this.maxConnections) {
                    connections.add(connection);
                    return;
                }
            }
        }
        connection.closeSocketAndStreams();
    }
}

