/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import libcore.io.IoUtils;
import libcore.io.Streams;
import libcore.net.http.AbstractHttpOutputStream;
import libcore.net.http.ChunkedInputStream;
import libcore.net.http.ChunkedOutputStream;
import libcore.net.http.FixedLengthInputStream;
import libcore.net.http.FixedLengthOutputStream;
import libcore.net.http.HttpConnection;
import libcore.net.http.HttpConnectionPool;
import libcore.net.http.HttpResponseCache;
import libcore.net.http.HttpURLConnectionImpl;
import libcore.net.http.RawHeaders;
import libcore.net.http.RequestHeaders;
import libcore.net.http.ResponseHeaders;
import libcore.net.http.ResponseSource;
import libcore.net.http.RetryableOutputStream;
import libcore.net.http.UnknownLengthHttpInputStream;
import libcore.util.EmptyArray;

public class HttpEngine {
    private static final CacheResponse BAD_GATEWAY_RESPONSE = new CacheResponse(){

        @Override
        public Map<String, List<String>> getHeaders() throws IOException {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            result.put(null, Collections.singletonList("HTTP/1.1 502 Bad Gateway"));
            return result;
        }

        @Override
        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(EmptyArray.BYTE);
        }
    };
    private static final int MAX_REQUEST_BUFFER_LENGTH = 32768;
    public static final int DEFAULT_CHUNK_LENGTH = 1024;
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    public static final String CONNECT = "CONNECT";
    public static final int HTTP_CONTINUE = 100;
    public static final int MAX_REDIRECTS = 5;
    protected final HttpURLConnectionImpl policy;
    protected final String method;
    private ResponseSource responseSource;
    protected HttpConnection connection;
    private InputStream socketIn;
    private OutputStream socketOut;
    private OutputStream requestOut;
    private AbstractHttpOutputStream requestBodyOut;
    private InputStream responseBodyIn;
    private final ResponseCache responseCache = ResponseCache.getDefault();
    private CacheResponse cacheResponse;
    private CacheRequest cacheRequest;
    private long sentRequestMillis = -1L;
    private boolean transparentGzip;
    boolean sendChunked;
    private int httpMinorVersion = 1;
    private final URI uri;
    private final RequestHeaders requestHeaders;
    private ResponseHeaders responseHeaders;
    private ResponseHeaders cachedResponseHeaders;
    private InputStream cachedResponseBody;
    private boolean automaticallyReleaseConnectionToPool;
    private boolean connectionReleased;

    public HttpEngine(HttpURLConnectionImpl policy, String method, RawHeaders requestHeaders, HttpConnection connection, RetryableOutputStream requestBodyOut) throws IOException {
        this.policy = policy;
        this.method = method;
        this.connection = connection;
        this.requestBodyOut = requestBodyOut;
        try {
            this.uri = policy.getURL().toURILenient();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.requestHeaders = new RequestHeaders(this.uri, new RawHeaders(requestHeaders));
    }

    public final void sendRequest() throws IOException {
        if (this.responseSource != null) {
            return;
        }
        this.prepareRawRequestHeaders();
        this.initResponseSource();
        if (this.responseCache instanceof HttpResponseCache) {
            ((HttpResponseCache)this.responseCache).trackResponse(this.responseSource);
        }
        if (this.requestHeaders.isOnlyIfCached() && this.responseSource.requiresConnection()) {
            if (this.responseSource == ResponseSource.CONDITIONAL_CACHE) {
                IoUtils.closeQuietly(this.cachedResponseBody);
            }
            this.responseSource = ResponseSource.CACHE;
            this.cacheResponse = BAD_GATEWAY_RESPONSE;
            RawHeaders rawResponseHeaders = RawHeaders.fromMultimap(this.cacheResponse.getHeaders());
            this.setResponse(new ResponseHeaders(this.uri, rawResponseHeaders), this.cacheResponse.getBody());
        }
        if (this.responseSource.requiresConnection()) {
            this.sendSocketRequest();
        } else if (this.connection != null) {
            HttpConnectionPool.INSTANCE.recycle(this.connection);
            this.connection = null;
        }
    }

    private void initResponseSource() throws IOException {
        this.responseSource = ResponseSource.NETWORK;
        if (!this.policy.getUseCaches() || this.responseCache == null) {
            return;
        }
        CacheResponse candidate = this.responseCache.get(this.uri, this.method, this.requestHeaders.getHeaders().toMultimap());
        if (candidate == null) {
            return;
        }
        Map<String, List<String>> responseHeadersMap = candidate.getHeaders();
        this.cachedResponseBody = candidate.getBody();
        if (!this.acceptCacheResponseType(candidate) || responseHeadersMap == null || this.cachedResponseBody == null) {
            IoUtils.closeQuietly(this.cachedResponseBody);
            return;
        }
        RawHeaders rawResponseHeaders = RawHeaders.fromMultimap(responseHeadersMap);
        this.cachedResponseHeaders = new ResponseHeaders(this.uri, rawResponseHeaders);
        long now = System.currentTimeMillis();
        this.responseSource = this.cachedResponseHeaders.chooseResponseSource(now, this.requestHeaders);
        if (this.responseSource == ResponseSource.CACHE) {
            this.cacheResponse = candidate;
            this.setResponse(this.cachedResponseHeaders, this.cachedResponseBody);
        } else if (this.responseSource == ResponseSource.CONDITIONAL_CACHE) {
            this.cacheResponse = candidate;
        } else if (this.responseSource == ResponseSource.NETWORK) {
            IoUtils.closeQuietly(this.cachedResponseBody);
        } else {
            throw new AssertionError();
        }
    }

    private void sendSocketRequest() throws IOException {
        if (this.connection == null) {
            this.connect();
        }
        if (this.socketOut != null || this.requestOut != null || this.socketIn != null) {
            throw new IllegalStateException();
        }
        this.requestOut = this.socketOut = this.connection.getOutputStream();
        this.socketIn = this.connection.getInputStream();
        if (this.hasRequestBody()) {
            this.initRequestBodyOut();
        }
    }

    protected void connect() throws IOException {
        if (this.connection == null) {
            this.connection = this.openSocketConnection();
        }
    }

    protected final HttpConnection openSocketConnection() throws IOException {
        HttpConnection result = HttpConnection.connect(this.uri, this.policy.getProxy(), this.requiresTunnel(), this.policy.getConnectTimeout());
        Proxy proxy = result.getAddress().getProxy();
        if (proxy != null) {
            this.policy.setProxy(proxy);
        }
        result.setSoTimeout(this.policy.getReadTimeout());
        return result;
    }

    protected void initRequestBodyOut() throws IOException {
        int chunkLength = this.policy.getChunkLength();
        if (chunkLength > 0 || this.requestHeaders.isChunked()) {
            this.sendChunked = true;
            if (chunkLength == -1) {
                chunkLength = 1024;
            }
        }
        if (this.socketOut == null) {
            throw new IllegalStateException("No socket to write to; was a POST cached?");
        }
        if (this.httpMinorVersion == 0) {
            this.sendChunked = false;
        }
        int fixedContentLength = this.policy.getFixedContentLength();
        if (this.requestBodyOut == null) {
            if (fixedContentLength != -1) {
                this.writeRequestHeaders(fixedContentLength);
                this.requestBodyOut = new FixedLengthOutputStream(this.requestOut, fixedContentLength);
            } else if (this.sendChunked) {
                this.writeRequestHeaders(-1);
                this.requestBodyOut = new ChunkedOutputStream(this.requestOut, chunkLength);
            } else if (this.requestHeaders.getContentLength() != -1) {
                this.writeRequestHeaders(this.requestHeaders.getContentLength());
                this.requestBodyOut = new RetryableOutputStream(this.requestHeaders.getContentLength());
            } else {
                this.requestBodyOut = new RetryableOutputStream();
            }
        }
    }

    private void setResponse(ResponseHeaders headers, InputStream body) throws IOException {
        if (this.responseBodyIn != null) {
            throw new IllegalStateException();
        }
        this.responseHeaders = headers;
        this.httpMinorVersion = this.responseHeaders.getHeaders().getHttpMinorVersion();
        if (body != null) {
            this.initContentStream(body);
        }
    }

    private boolean hasRequestBody() {
        return this.method == POST || this.method == PUT;
    }

    public final OutputStream getRequestBody() {
        if (this.responseSource == null) {
            throw new IllegalStateException();
        }
        return this.requestBodyOut;
    }

    public final boolean hasResponse() {
        return this.responseHeaders != null;
    }

    public final RequestHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public final ResponseHeaders getResponseHeaders() {
        if (this.responseHeaders == null) {
            throw new IllegalStateException();
        }
        return this.responseHeaders;
    }

    public final int getResponseCode() {
        if (this.responseHeaders == null) {
            throw new IllegalStateException();
        }
        return this.responseHeaders.getHeaders().getResponseCode();
    }

    public final InputStream getResponseBody() {
        if (this.responseHeaders == null) {
            throw new IllegalStateException();
        }
        return this.responseBodyIn;
    }

    public final CacheResponse getCacheResponse() {
        if (this.responseHeaders == null) {
            throw new IllegalStateException();
        }
        return this.cacheResponse;
    }

    public final HttpConnection getConnection() {
        return this.connection;
    }

    protected boolean acceptCacheResponseType(CacheResponse cacheResponse) {
        return true;
    }

    private void maybeCache() throws IOException {
        if (!this.policy.getUseCaches() || this.responseCache == null) {
            return;
        }
        if (!this.responseHeaders.isCacheable(this.requestHeaders)) {
            return;
        }
        this.cacheRequest = this.responseCache.put(this.uri, this.getHttpConnectionToCache());
    }

    protected HttpURLConnection getHttpConnectionToCache() {
        return this.policy;
    }

    public final void automaticallyReleaseConnectionToPool() {
        this.automaticallyReleaseConnectionToPool = true;
        if (this.connection != null && this.connectionReleased) {
            HttpConnectionPool.INSTANCE.recycle(this.connection);
            this.connection = null;
        }
    }

    public final void release(boolean reusable) {
        if (this.responseBodyIn == this.cachedResponseBody) {
            IoUtils.closeQuietly(this.responseBodyIn);
        }
        if (!this.connectionReleased && this.connection != null) {
            this.connectionReleased = true;
            if (this.requestBodyOut != null && !this.requestBodyOut.closed) {
                reusable = false;
            }
            if (this.hasConnectionCloseHeader()) {
                reusable = false;
            }
            if (this.responseBodyIn instanceof UnknownLengthHttpInputStream) {
                reusable = false;
            }
            if (reusable && this.responseBodyIn != null) {
                try {
                    Streams.skipAll(this.responseBodyIn);
                }
                catch (IOException e) {
                    reusable = false;
                }
            }
            if (!reusable) {
                this.connection.closeSocketAndStreams();
                this.connection = null;
            } else if (this.automaticallyReleaseConnectionToPool) {
                HttpConnectionPool.INSTANCE.recycle(this.connection);
                this.connection = null;
            }
        }
    }

    private void initContentStream(InputStream transferStream) throws IOException {
        if (this.transparentGzip && this.responseHeaders.isContentEncodingGzip()) {
            this.responseHeaders.stripContentEncoding();
            this.responseBodyIn = new GZIPInputStream(transferStream);
        } else {
            this.responseBodyIn = transferStream;
        }
    }

    private InputStream getTransferStream() throws IOException {
        if (!this.hasResponseBody()) {
            return new FixedLengthInputStream(this.socketIn, this.cacheRequest, this, 0);
        }
        if (this.responseHeaders.isChunked()) {
            return new ChunkedInputStream(this.socketIn, this.cacheRequest, this);
        }
        if (this.responseHeaders.getContentLength() != -1) {
            return new FixedLengthInputStream(this.socketIn, this.cacheRequest, this, this.responseHeaders.getContentLength());
        }
        return new UnknownLengthHttpInputStream(this.socketIn, this.cacheRequest, this);
    }

    private void readResponseHeaders() throws IOException {
        RawHeaders headers;
        do {
            headers = new RawHeaders();
            headers.setStatusLine(Streams.readAsciiLine(this.socketIn));
            this.readHeaders(headers);
        } while (headers.getResponseCode() == 100);
        this.setResponse(new ResponseHeaders(this.uri, headers), null);
    }

    public final boolean hasResponseBody() {
        int responseCode = this.responseHeaders.getHeaders().getResponseCode();
        if (this.method != HEAD && this.method != CONNECT && (responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return this.responseHeaders.getContentLength() != -1 || this.responseHeaders.isChunked();
    }

    final void readTrailers() throws IOException {
        this.readHeaders(this.responseHeaders.getHeaders());
    }

    private void readHeaders(RawHeaders headers) throws IOException {
        String line;
        while (!(line = Streams.readAsciiLine(this.socketIn)).isEmpty()) {
            headers.addLine(line);
        }
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler != null) {
            cookieHandler.put(this.uri, headers.toMultimap());
        }
    }

    private void writeRequestHeaders(int contentLength) throws IOException {
        if (this.sentRequestMillis != -1L) {
            throw new IllegalStateException();
        }
        RawHeaders headersToSend = this.getNetworkRequestHeaders();
        byte[] bytes = headersToSend.toHeaderString().getBytes(Charsets.ISO_8859_1);
        if (contentLength != -1 && bytes.length + contentLength <= 32768) {
            this.requestOut = new BufferedOutputStream(this.socketOut, bytes.length + contentLength);
        }
        this.sentRequestMillis = System.currentTimeMillis();
        this.requestOut.write(bytes);
    }

    protected RawHeaders getNetworkRequestHeaders() throws IOException {
        this.requestHeaders.getHeaders().setStatusLine(this.getRequestLine());
        int fixedContentLength = this.policy.getFixedContentLength();
        if (fixedContentLength != -1) {
            this.requestHeaders.setContentLength(fixedContentLength);
        } else if (this.sendChunked) {
            this.requestHeaders.setChunked();
        } else if (this.requestBodyOut instanceof RetryableOutputStream) {
            int contentLength = ((RetryableOutputStream)this.requestBodyOut).contentLength();
            this.requestHeaders.setContentLength(contentLength);
        }
        return this.requestHeaders.getHeaders();
    }

    private void prepareRawRequestHeaders() throws IOException {
        CookieHandler cookieHandler;
        long ifModifiedSince;
        this.requestHeaders.getHeaders().setStatusLine(this.getRequestLine());
        if (this.requestHeaders.getUserAgent() == null) {
            this.requestHeaders.setUserAgent(this.getDefaultUserAgent());
        }
        if (this.requestHeaders.getHost() == null) {
            this.requestHeaders.setHost(this.getOriginAddress(this.policy.getURL()));
        }
        if (this.httpMinorVersion > 0 && this.requestHeaders.getConnection() == null) {
            this.requestHeaders.setConnection("Keep-Alive");
        }
        if (this.requestHeaders.getAcceptEncoding() == null) {
            this.transparentGzip = true;
            this.requestHeaders.setAcceptEncoding("gzip");
        }
        if (this.hasRequestBody() && this.requestHeaders.getContentType() == null) {
            this.requestHeaders.setContentType("application/x-www-form-urlencoded");
        }
        if ((ifModifiedSince = this.policy.getIfModifiedSince()) != 0L) {
            this.requestHeaders.setIfModifiedSince(new Date(ifModifiedSince));
        }
        if ((cookieHandler = CookieHandler.getDefault()) != null) {
            this.requestHeaders.addCookies(cookieHandler.get(this.uri, this.requestHeaders.getHeaders().toMultimap()));
        }
    }

    private String getRequestLine() {
        String protocol = this.httpMinorVersion == 0 ? "HTTP/1.0" : "HTTP/1.1";
        return this.method + " " + this.requestString() + " " + protocol;
    }

    private String requestString() {
        URL url = this.policy.getURL();
        if (this.includeAuthorityInRequestLine()) {
            return url.toString();
        }
        String fileOnly = url.getFile();
        if (fileOnly == null) {
            fileOnly = "/";
        } else if (!fileOnly.startsWith("/")) {
            fileOnly = "/" + fileOnly;
        }
        return fileOnly;
    }

    protected boolean includeAuthorityInRequestLine() {
        return this.policy.usingProxy();
    }

    protected final String getDefaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    private boolean hasConnectionCloseHeader() {
        return this.responseHeaders != null && this.responseHeaders.hasConnectionClose() || this.requestHeaders.hasConnectionClose();
    }

    protected final String getOriginAddress(URL url) {
        int port = url.getPort();
        String result = url.getHost();
        if (port > 0 && port != this.policy.getDefaultPort()) {
            result = result + ":" + port;
        }
        return result;
    }

    protected boolean requiresTunnel() {
        return false;
    }

    public final void readResponse() throws IOException {
        if (this.hasResponse()) {
            return;
        }
        if (this.responseSource == null) {
            throw new IllegalStateException("readResponse() without sendRequest()");
        }
        if (!this.responseSource.requiresConnection()) {
            return;
        }
        if (this.sentRequestMillis == -1L) {
            int contentLength = this.requestBodyOut instanceof RetryableOutputStream ? ((RetryableOutputStream)this.requestBodyOut).contentLength() : -1;
            this.writeRequestHeaders(contentLength);
        }
        if (this.requestBodyOut != null) {
            this.requestBodyOut.close();
            if (this.requestBodyOut instanceof RetryableOutputStream) {
                ((RetryableOutputStream)this.requestBodyOut).writeToSocket(this.requestOut);
            }
        }
        this.requestOut.flush();
        this.requestOut = this.socketOut;
        this.readResponseHeaders();
        this.responseHeaders.setLocalTimestamps(this.sentRequestMillis, System.currentTimeMillis());
        if (this.responseSource == ResponseSource.CONDITIONAL_CACHE) {
            if (this.cachedResponseHeaders.validate(this.responseHeaders)) {
                if (this.responseCache instanceof HttpResponseCache) {
                    ((HttpResponseCache)this.responseCache).trackConditionalCacheHit();
                }
                this.release(true);
                this.setResponse(this.cachedResponseHeaders.combine(this.responseHeaders), this.cachedResponseBody);
                return;
            }
            IoUtils.closeQuietly(this.cachedResponseBody);
        }
        if (this.hasResponseBody()) {
            this.maybeCache();
        }
        this.initContentStream(this.getTransferStream());
    }
}

