/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.SecureCacheResponse;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import libcore.io.Base64;
import libcore.io.DiskLruCache;
import libcore.io.IoUtils;
import libcore.io.Streams;
import libcore.net.http.HttpEngine;
import libcore.net.http.HttpURLConnectionImpl;
import libcore.net.http.HttpsURLConnectionImpl;
import libcore.net.http.RawHeaders;
import libcore.net.http.ResponseHeaders;
import libcore.net.http.ResponseSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpResponseCache
extends ResponseCache {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public HttpResponseCache(File directory, long maxSize) throws IOException {
        this.cache = DiskLruCache.open(directory, 201105, 2, maxSize);
    }

    private String uriToKey(URI uri) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] md5bytes = messageDigest.digest(uri.toString().getBytes(Charsets.UTF_8));
            return IntegralToString.bytesToHexString(md5bytes, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public CacheResponse get(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) {
        Entry entry;
        DiskLruCache.Snapshot snapshot;
        String key = this.uriToKey(uri);
        try {
            snapshot = this.cache.get(key);
            if (snapshot == null) {
                return null;
            }
            entry = new Entry(new BufferedInputStream(snapshot.getInputStream(0)));
        }
        catch (IOException e) {
            return null;
        }
        if (!entry.matches(uri, requestMethod, requestHeaders)) {
            snapshot.close();
            return null;
        }
        InputStream body = this.newBodyInputStream(snapshot);
        return entry.isHttps() ? entry.newSecureCacheResponse(body) : entry.newCacheResponse(body);
    }

    private InputStream newBodyInputStream(final DiskLruCache.Snapshot snapshot) {
        return new FilterInputStream(snapshot.getInputStream(1)){

            public void close() throws IOException {
                snapshot.close();
                super.close();
            }
        };
    }

    @Override
    public CacheRequest put(URI uri, URLConnection urlConnection) throws IOException {
        if (!(urlConnection instanceof HttpURLConnection)) {
            return null;
        }
        HttpURLConnection httpConnection = (HttpURLConnection)urlConnection;
        String requestMethod = httpConnection.getRequestMethod();
        String key = this.uriToKey(uri);
        if (requestMethod.equals("POST") || requestMethod.equals("PUT") || requestMethod.equals("DELETE")) {
            try {
                this.cache.remove(key);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return null;
        }
        if (!requestMethod.equals("GET")) {
            return null;
        }
        HttpEngine httpEngine = this.getHttpEngine(httpConnection);
        if (httpEngine == null) {
            return null;
        }
        ResponseHeaders response = httpEngine.getResponseHeaders();
        if (response.hasVaryAll()) {
            return null;
        }
        RawHeaders varyHeaders = httpEngine.getRequestHeaders().getHeaders().getAll(response.getVaryFields());
        Entry entry = new Entry(uri, varyHeaders, httpConnection);
        DiskLruCache.Editor editor = null;
        try {
            editor = this.cache.edit(key);
            if (editor == null) {
                return null;
            }
            entry.writeTo(editor);
            return new CacheRequestImpl(editor);
        }
        catch (IOException e) {
            try {
                if (editor != null) {
                    editor.abort();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return null;
        }
    }

    private HttpEngine getHttpEngine(HttpURLConnection httpConnection) {
        if (httpConnection instanceof HttpURLConnectionImpl) {
            return ((HttpURLConnectionImpl)httpConnection).getHttpEngine();
        }
        if (httpConnection instanceof HttpsURLConnectionImpl) {
            return ((HttpsURLConnectionImpl)httpConnection).getHttpEngine();
        }
        return null;
    }

    public DiskLruCache getCache() {
        return this.cache;
    }

    public synchronized int getWriteAbortCount() {
        return this.writeAbortCount;
    }

    public synchronized int getWriteSuccessCount() {
        return this.writeSuccessCount;
    }

    synchronized void trackResponse(ResponseSource source) {
        ++this.requestCount;
        switch (source) {
            case CACHE: {
                ++this.hitCount;
                break;
            }
            case CONDITIONAL_CACHE: 
            case NETWORK: {
                ++this.networkCount;
            }
        }
    }

    synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public synchronized int getNetworkCount() {
        return this.networkCount;
    }

    public synchronized int getHitCount() {
        return this.hitCount;
    }

    public synchronized int getRequestCount() {
        return this.requestCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry {
        private final String uri;
        private final RawHeaders varyHeaders;
        private final String requestMethod;
        private final RawHeaders responseHeaders;
        private final String cipherSuite;
        private final Certificate[] peerCertificates;
        private final Certificate[] localCertificates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entry(InputStream in) throws IOException {
            try {
                this.uri = Streams.readAsciiLine(in);
                this.requestMethod = Streams.readAsciiLine(in);
                this.varyHeaders = new RawHeaders();
                int varyRequestHeaderLineCount = this.readInt(in);
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    this.varyHeaders.addLine(Streams.readAsciiLine(in));
                }
                this.responseHeaders = new RawHeaders();
                this.responseHeaders.setStatusLine(Streams.readAsciiLine(in));
                int responseHeaderLineCount = this.readInt(in);
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    this.responseHeaders.addLine(Streams.readAsciiLine(in));
                }
                if (this.isHttps()) {
                    String blank = Streams.readAsciiLine(in);
                    if (!blank.isEmpty()) {
                        throw new IOException("expected \"\" but was \"" + blank + "\"");
                    }
                    this.cipherSuite = Streams.readAsciiLine(in);
                    this.peerCertificates = this.readCertArray(in);
                    this.localCertificates = this.readCertArray(in);
                } else {
                    this.cipherSuite = null;
                    this.peerCertificates = null;
                    this.localCertificates = null;
                }
            }
            finally {
                in.close();
            }
        }

        public Entry(URI uri, RawHeaders varyHeaders, HttpURLConnection httpConnection) {
            this.uri = uri.toString();
            this.varyHeaders = varyHeaders;
            this.requestMethod = httpConnection.getRequestMethod();
            this.responseHeaders = RawHeaders.fromMultimap(httpConnection.getHeaderFields());
            if (this.isHttps()) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)httpConnection;
                this.cipherSuite = httpsConnection.getCipherSuite();
                Certificate[] peerCertificatesNonFinal = null;
                try {
                    peerCertificatesNonFinal = httpsConnection.getServerCertificates();
                }
                catch (SSLPeerUnverifiedException ignored) {
                    // empty catch block
                }
                this.peerCertificates = peerCertificatesNonFinal;
                this.localCertificates = httpsConnection.getLocalCertificates();
            } else {
                this.cipherSuite = null;
                this.peerCertificates = null;
                this.localCertificates = null;
            }
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int i;
            OutputStream out = editor.newOutputStream(0);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, Charsets.UTF_8));
            writer.write(this.uri + '\n');
            writer.write(this.requestMethod + '\n');
            writer.write(Integer.toString(this.varyHeaders.length()) + '\n');
            for (i = 0; i < this.varyHeaders.length(); ++i) {
                writer.write(this.varyHeaders.getFieldName(i) + ": " + this.varyHeaders.getValue(i) + '\n');
            }
            writer.write(this.responseHeaders.getStatusLine() + '\n');
            writer.write(Integer.toString(this.responseHeaders.length()) + '\n');
            for (i = 0; i < this.responseHeaders.length(); ++i) {
                writer.write(this.responseHeaders.getFieldName(i) + ": " + this.responseHeaders.getValue(i) + '\n');
            }
            if (this.isHttps()) {
                ((Writer)writer).write(10);
                writer.write(this.cipherSuite + '\n');
                this.writeCertArray(writer, this.peerCertificates);
                this.writeCertArray(writer, this.localCertificates);
            }
            ((Writer)writer).close();
        }

        private boolean isHttps() {
            return this.uri.startsWith("https://");
        }

        private int readInt(InputStream in) throws IOException {
            String intString = Streams.readAsciiLine(in);
            try {
                return Integer.parseInt(intString);
            }
            catch (NumberFormatException e) {
                throw new IOException("expected an int but was \"" + intString + "\"");
            }
        }

        private Certificate[] readCertArray(InputStream in) throws IOException {
            int length = this.readInt(in);
            if (length == -1) {
                return null;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Certificate[] result = new Certificate[length];
                for (int i = 0; i < result.length; ++i) {
                    String line = Streams.readAsciiLine(in);
                    byte[] bytes = Base64.decode(line.getBytes(Charsets.US_ASCII));
                    result[i] = certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e);
            }
        }

        private void writeCertArray(Writer writer, Certificate[] certificates) throws IOException {
            if (certificates == null) {
                writer.write("-1\n");
                return;
            }
            try {
                writer.write(Integer.toString(certificates.length) + '\n');
                for (Certificate certificate : certificates) {
                    byte[] bytes = certificate.getEncoded();
                    String line = Base64.encode(bytes);
                    writer.write(line + '\n');
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e);
            }
        }

        public boolean matches(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) {
            return this.uri.equals(uri.toString()) && this.requestMethod.equals(requestMethod) && new ResponseHeaders(uri, this.responseHeaders).varyMatches(this.varyHeaders.toMultimap(), requestHeaders);
        }

        public CacheResponse newCacheResponse(final InputStream in) {
            return new CacheResponse(){

                @Override
                public Map<String, List<String>> getHeaders() {
                    return Entry.this.responseHeaders.toMultimap();
                }

                @Override
                public InputStream getBody() {
                    return in;
                }
            };
        }

        public SecureCacheResponse newSecureCacheResponse(final InputStream in) {
            return new SecureCacheResponse(){

                @Override
                public Map<String, List<String>> getHeaders() {
                    return Entry.this.responseHeaders.toMultimap();
                }

                @Override
                public InputStream getBody() {
                    return in;
                }

                @Override
                public String getCipherSuite() {
                    return Entry.this.cipherSuite;
                }

                @Override
                public List<Certificate> getServerCertificateChain() throws SSLPeerUnverifiedException {
                    if (Entry.this.peerCertificates == null || Entry.this.peerCertificates.length == 0) {
                        throw new SSLPeerUnverifiedException(null);
                    }
                    return Arrays.asList((Object[])Entry.this.peerCertificates.clone());
                }

                @Override
                public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                    if (Entry.this.peerCertificates == null || Entry.this.peerCertificates.length == 0) {
                        throw new SSLPeerUnverifiedException(null);
                    }
                    return ((X509Certificate)Entry.this.peerCertificates[0]).getSubjectX500Principal();
                }

                @Override
                public List<Certificate> getLocalCertificateChain() {
                    if (Entry.this.localCertificates == null || Entry.this.localCertificates.length == 0) {
                        return null;
                    }
                    return Arrays.asList((Object[])Entry.this.localCertificates.clone());
                }

                @Override
                public Principal getLocalPrincipal() {
                    if (Entry.this.localCertificates == null || Entry.this.localCertificates.length == 0) {
                        return null;
                    }
                    return ((X509Certificate)Entry.this.localCertificates[0]).getSubjectX500Principal();
                }
            };
        }
    }

    private final class CacheRequestImpl
    extends CacheRequest {
        private final DiskLruCache.Editor editor;
        private OutputStream cacheOut;
        private boolean done;
        private OutputStream body;

        public CacheRequestImpl(final DiskLruCache.Editor editor) throws IOException {
            this.editor = editor;
            this.cacheOut = editor.newOutputStream(1);
            this.body = new FilterOutputStream(this.cacheOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    HttpResponseCache httpResponseCache = HttpResponseCache.this;
                    synchronized (httpResponseCache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        HttpResponseCache.this.writeSuccessCount++;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            HttpResponseCache httpResponseCache = HttpResponseCache.this;
            synchronized (httpResponseCache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                HttpResponseCache.this.writeAbortCount++;
            }
            IoUtils.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public OutputStream getBody() throws IOException {
            return this.body;
        }
    }
}

