/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.nio.charset.Charsets;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import libcore.io.Base64;
import libcore.net.http.HttpConnection;
import libcore.net.http.HttpEngine;
import libcore.net.http.RawHeaders;
import libcore.net.http.ResponseHeaders;
import libcore.net.http.RetryableOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpURLConnectionImpl
extends HttpURLConnection {
    private final int defaultPort;
    private Proxy proxy;
    private final RawHeaders rawRequestHeaders = new RawHeaders();
    private int redirectionCount;
    protected IOException httpEngineFailure;
    protected HttpEngine httpEngine;

    protected HttpURLConnectionImpl(URL url, int port) {
        super(url);
        this.defaultPort = port;
    }

    protected HttpURLConnectionImpl(URL url, int port, Proxy proxy) {
        this(url, port);
        this.proxy = proxy;
    }

    @Override
    public final void connect() throws IOException {
        this.initHttpEngine();
        try {
            this.httpEngine.sendRequest();
        }
        catch (IOException e) {
            this.httpEngineFailure = e;
            throw e;
        }
    }

    @Override
    public final void disconnect() {
        if (this.httpEngine != null) {
            this.httpEngine.release(false);
        }
    }

    @Override
    public final InputStream getErrorStream() {
        try {
            HttpEngine response = this.getResponse();
            if (response.hasResponseBody() && response.getResponseCode() >= 400) {
                return response.getResponseBody();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(int position) {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().getValue(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(String fieldName) {
        try {
            RawHeaders rawHeaders = this.getResponse().getResponseHeaders().getHeaders();
            return fieldName == null ? rawHeaders.getStatusLine() : rawHeaders.get(fieldName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderFieldKey(int position) {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().getFieldName(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getHeaderFields() {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().toMultimap();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request header fields after connection is set");
        }
        return this.rawRequestHeaders.toMultimap();
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("This protocol does not support input");
        }
        HttpEngine response = this.getResponse();
        if (this.getResponseCode() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        InputStream result = response.getResponseBody();
        if (result == null) {
            throw new IOException("No response body exists; responseCode=" + this.getResponseCode());
        }
        return result;
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        this.connect();
        OutputStream result = this.httpEngine.getRequestBody();
        if (result == null) {
            throw new ProtocolException("method does not support a request body: " + this.method);
        }
        if (this.httpEngine.hasResponse()) {
            throw new ProtocolException("cannot write request body after response has been read");
        }
        return result;
    }

    @Override
    public final Permission getPermission() throws IOException {
        String connectToAddress = this.getConnectToHost() + ":" + this.getConnectToPort();
        return new SocketPermission(connectToAddress, "connect, resolve");
    }

    private String getConnectToHost() {
        return this.usingProxy() ? ((InetSocketAddress)this.proxy.address()).getHostName() : this.getURL().getHost();
    }

    private int getConnectToPort() {
        int hostPort = this.usingProxy() ? ((InetSocketAddress)this.proxy.address()).getPort() : this.getURL().getPort();
        return hostPort < 0 ? this.getDefaultPort() : hostPort;
    }

    @Override
    public final String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.rawRequestHeaders.get(field);
    }

    private void initHttpEngine() throws IOException {
        if (this.httpEngineFailure != null) {
            throw this.httpEngineFailure;
        }
        if (this.httpEngine != null) {
            return;
        }
        this.connected = true;
        try {
            if (this.doOutput) {
                if (this.method == "GET") {
                    this.method = "POST";
                } else if (this.method != "POST" && this.method != "PUT") {
                    throw new ProtocolException(this.method + " does not support writing");
                }
            }
            this.httpEngine = this.newHttpEngine(this.method, this.rawRequestHeaders, null, null);
        }
        catch (IOException e) {
            this.httpEngineFailure = e;
            throw e;
        }
    }

    protected HttpEngine newHttpEngine(String method, RawHeaders requestHeaders, HttpConnection connection, RetryableOutputStream requestBody) throws IOException {
        return new HttpEngine(this, method, requestHeaders, connection, requestBody);
    }

    private HttpEngine getResponse() throws IOException {
        this.initHttpEngine();
        if (this.httpEngine.hasResponse()) {
            return this.httpEngine;
        }
        try {
            while (true) {
                this.httpEngine.sendRequest();
                this.httpEngine.readResponse();
                Retry retry = this.processResponseHeaders();
                if (retry == Retry.NONE) break;
                String retryMethod = this.method;
                OutputStream requestBody = this.httpEngine.getRequestBody();
                int responseCode = this.getResponseCode();
                if (responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303) {
                    retryMethod = "GET";
                    requestBody = null;
                }
                if (requestBody != null && !(requestBody instanceof RetryableOutputStream)) {
                    throw new HttpRetryException("Cannot retry streamed HTTP body", this.httpEngine.getResponseCode());
                }
                if (retry == Retry.DIFFERENT_CONNECTION) {
                    this.httpEngine.automaticallyReleaseConnectionToPool();
                }
                this.httpEngine.release(true);
                this.httpEngine = this.newHttpEngine(retryMethod, this.rawRequestHeaders, this.httpEngine.getConnection(), (RetryableOutputStream)requestBody);
            }
            this.httpEngine.automaticallyReleaseConnectionToPool();
            return this.httpEngine;
        }
        catch (IOException e) {
            this.httpEngineFailure = e;
            throw e;
        }
    }

    HttpEngine getHttpEngine() {
        return this.httpEngine;
    }

    private Retry processResponseHeaders() throws IOException {
        switch (this.getResponseCode()) {
            case 407: {
                if (!this.usingProxy()) {
                    throw new IOException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
            }
            case 401: {
                boolean credentialsFound = this.processAuthHeader(this.getResponseCode(), this.httpEngine.getResponseHeaders(), this.rawRequestHeaders);
                return credentialsFound ? Retry.SAME_CONNECTION : Retry.NONE;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.getInstanceFollowRedirects()) {
                    return Retry.NONE;
                }
                if (++this.redirectionCount > 5) {
                    throw new ProtocolException("Too many redirects");
                }
                String location = this.getHeaderField("Location");
                if (location == null) {
                    return Retry.NONE;
                }
                URL previousUrl = this.url;
                this.url = new URL(previousUrl, location);
                if (!previousUrl.getProtocol().equals(this.url.getProtocol())) {
                    return Retry.NONE;
                }
                if (previousUrl.getHost().equals(this.url.getHost()) && previousUrl.getEffectivePort() == this.url.getEffectivePort()) {
                    return Retry.SAME_CONNECTION;
                }
                return Retry.DIFFERENT_CONNECTION;
            }
        }
        return Retry.NONE;
    }

    final boolean processAuthHeader(int responseCode, ResponseHeaders response, RawHeaders successorRequestHeaders) throws IOException {
        String challenge;
        if (responseCode != 407 && responseCode != 401) {
            throw new IllegalArgumentException();
        }
        String string = challenge = responseCode == 407 ? response.getProxyAuthenticate() : response.getWwwAuthenticate();
        if (challenge == null) {
            throw new IOException("Received authentication challenge is null");
        }
        String credentials = this.getAuthorizationCredentials(challenge);
        if (credentials == null) {
            return false;
        }
        String fieldName = responseCode == 407 ? "Proxy-Authorization" : "Authorization";
        successorRequestHeaders.set(fieldName, credentials);
        return true;
    }

    private String getAuthorizationCredentials(String challenge) throws IOException {
        PasswordAuthentication pa;
        int end;
        int idx = challenge.indexOf(" ");
        if (idx == -1) {
            return null;
        }
        String scheme = challenge.substring(0, idx);
        int realm = challenge.indexOf("realm=\"") + 7;
        String prompt = null;
        if (realm != -1 && (end = challenge.indexOf(34, realm)) != -1) {
            prompt = challenge.substring(realm, end);
        }
        if ((pa = Authenticator.requestPasswordAuthentication(this.getConnectToInetAddress(), this.getConnectToPort(), this.url.getProtocol(), prompt, scheme)) == null) {
            return null;
        }
        String usernameAndPassword = pa.getUserName() + ":" + new String(pa.getPassword());
        byte[] bytes = usernameAndPassword.getBytes(Charsets.ISO_8859_1);
        String encoded = Base64.encode(bytes);
        return scheme + " " + encoded;
    }

    private InetAddress getConnectToInetAddress() throws IOException {
        return this.usingProxy() ? ((InetSocketAddress)this.proxy.address()).getAddress() : InetAddress.getByName(this.getURL().getHost());
    }

    final int getDefaultPort() {
        return this.defaultPort;
    }

    final int getFixedContentLength() {
        return this.fixedContentLength;
    }

    final int getChunkLength() {
        return this.chunkLength;
    }

    final Proxy getProxy() {
        return this.proxy;
    }

    final void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public final boolean usingProxy() {
        return this.proxy != null && this.proxy.type() != Proxy.Type.DIRECT;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.getResponse().getResponseHeaders().getHeaders().getResponseMessage();
    }

    @Override
    public final int getResponseCode() throws IOException {
        return this.getResponse().getResponseCode();
    }

    @Override
    public final void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException("Cannot set request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        this.rawRequestHeaders.set(field, newValue);
    }

    @Override
    public final void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalStateException("Cannot add request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        this.rawRequestHeaders.add(field, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Retry {
        NONE,
        SAME_CONNECTION,
        DIFFERENT_CONNECTION;

    }
}

