/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SecureCacheResponse;
import java.net.URL;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import libcore.net.http.HttpConnection;
import libcore.net.http.HttpEngine;
import libcore.net.http.HttpURLConnectionImpl;
import libcore.net.http.RawHeaders;
import libcore.net.http.RequestHeaders;
import libcore.net.http.RetryableOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpsURLConnectionImpl
extends HttpsURLConnection {
    private final HttpUrlConnectionDelegate delegate;

    protected HttpsURLConnectionImpl(URL url, int port) {
        super(url);
        this.delegate = new HttpUrlConnectionDelegate(url, port);
    }

    protected HttpsURLConnectionImpl(URL url, int port, Proxy proxy) {
        super(url);
        this.delegate = new HttpUrlConnectionDelegate(url, port, proxy);
    }

    private void checkConnected() {
        if (this.delegate.getSSLSocket() == null) {
            throw new IllegalStateException("Connection has not yet been established");
        }
    }

    HttpEngine getHttpEngine() {
        return this.delegate.getHttpEngine();
    }

    @Override
    public String getCipherSuite() {
        SecureCacheResponse cacheResponse = this.delegate.getCacheResponse();
        if (cacheResponse != null) {
            return cacheResponse.getCipherSuite();
        }
        this.checkConnected();
        return this.delegate.getSSLSocket().getSession().getCipherSuite();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        SecureCacheResponse cacheResponse = this.delegate.getCacheResponse();
        if (cacheResponse != null) {
            List<Certificate> result = cacheResponse.getLocalCertificateChain();
            return result != null ? result.toArray(new Certificate[result.size()]) : null;
        }
        this.checkConnected();
        return this.delegate.getSSLSocket().getSession().getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        SecureCacheResponse cacheResponse = this.delegate.getCacheResponse();
        if (cacheResponse != null) {
            List<Certificate> result = cacheResponse.getServerCertificateChain();
            return result != null ? result.toArray(new Certificate[result.size()]) : null;
        }
        this.checkConnected();
        return this.delegate.getSSLSocket().getSession().getPeerCertificates();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        SecureCacheResponse cacheResponse = this.delegate.getCacheResponse();
        if (cacheResponse != null) {
            return cacheResponse.getPeerPrincipal();
        }
        this.checkConnected();
        return this.delegate.getSSLSocket().getSession().getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        SecureCacheResponse cacheResponse = this.delegate.getCacheResponse();
        if (cacheResponse != null) {
            return cacheResponse.getLocalPrincipal();
        }
        this.checkConnected();
        return this.delegate.getSSLSocket().getSession().getLocalPrincipal();
    }

    @Override
    public void disconnect() {
        this.delegate.disconnect();
    }

    @Override
    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    @Override
    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.delegate.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.delegate.getResponseMessage();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.delegate.setRequestMethod(method);
    }

    @Override
    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.delegate.getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.delegate.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void connect() throws IOException {
        this.connected = true;
        this.delegate.connect();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.delegate.getAllowUserInteraction();
    }

    @Override
    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    @Override
    public Object getContent(Class[] types) throws IOException {
        return this.delegate.getContent(types);
    }

    @Override
    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public long getDate() {
        return this.delegate.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.delegate.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.delegate.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.delegate.getDoOutput();
    }

    @Override
    public long getExpiration() {
        return this.delegate.getExpiration();
    }

    @Override
    public String getHeaderField(int pos) {
        return this.delegate.getHeaderField(pos);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.delegate.getHeaderFields();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.delegate.getRequestProperties();
    }

    @Override
    public void addRequestProperty(String field, String newValue) {
        this.delegate.addRequestProperty(field, newValue);
    }

    @Override
    public String getHeaderField(String key) {
        return this.delegate.getHeaderField(key);
    }

    @Override
    public long getHeaderFieldDate(String field, long defaultValue) {
        return this.delegate.getHeaderFieldDate(field, defaultValue);
    }

    @Override
    public int getHeaderFieldInt(String field, int defaultValue) {
        return this.delegate.getHeaderFieldInt(field, defaultValue);
    }

    @Override
    public String getHeaderFieldKey(int posn) {
        return this.delegate.getHeaderFieldKey(posn);
    }

    @Override
    public long getIfModifiedSince() {
        return this.delegate.getIfModifiedSince();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    @Override
    public long getLastModified() {
        return this.delegate.getLastModified();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.delegate.getPermission();
    }

    @Override
    public String getRequestProperty(String field) {
        return this.delegate.getRequestProperty(field);
    }

    @Override
    public URL getURL() {
        return this.delegate.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.delegate.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean newValue) {
        this.delegate.setAllowUserInteraction(newValue);
    }

    @Override
    public void setDefaultUseCaches(boolean newValue) {
        this.delegate.setDefaultUseCaches(newValue);
    }

    @Override
    public void setDoInput(boolean newValue) {
        this.delegate.setDoInput(newValue);
    }

    @Override
    public void setDoOutput(boolean newValue) {
        this.delegate.setDoOutput(newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        this.delegate.setIfModifiedSince(newValue);
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        this.delegate.setRequestProperty(field, newValue);
    }

    @Override
    public void setUseCaches(boolean newValue) {
        this.delegate.setUseCaches(newValue);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.delegate.setConnectTimeout(timeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.delegate.getConnectTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.delegate.setReadTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return this.delegate.getReadTimeout();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.delegate.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLength) {
        this.delegate.setChunkedStreamingMode(chunkLength);
    }

    private static class ProxyConnectEngine
    extends HttpEngine {
        public ProxyConnectEngine(HttpURLConnectionImpl policy, RawHeaders requestHeaders, HttpConnection connection) throws IOException {
            super(policy, "CONNECT", requestHeaders, connection, null);
        }

        protected RawHeaders getNetworkRequestHeaders() throws IOException {
            RequestHeaders privateHeaders = this.getRequestHeaders();
            URL url = this.policy.getURL();
            RawHeaders result = new RawHeaders();
            result.setStatusLine("CONNECT " + url.getHost() + ":" + url.getEffectivePort() + " HTTP/1.1");
            String host = privateHeaders.getHost();
            if (host == null) {
                host = this.getOriginAddress(url);
            }
            result.set("Host", host);
            String userAgent = privateHeaders.getUserAgent();
            if (userAgent == null) {
                userAgent = this.getDefaultUserAgent();
            }
            result.set("User-Agent", userAgent);
            String proxyAuthorization = privateHeaders.getProxyAuthorization();
            if (proxyAuthorization != null) {
                result.set("Proxy-Authorization", proxyAuthorization);
            }
            result.set("Proxy-Connection", "Keep-Alive");
            return result;
        }

        protected boolean requiresTunnel() {
            return true;
        }
    }

    private static class HttpsEngine
    extends HttpEngine {
        private SSLSocket sslSocket;
        private final HttpsURLConnectionImpl enclosing;

        private HttpsEngine(HttpURLConnectionImpl policy, String method, RawHeaders requestHeaders, HttpConnection connection, RetryableOutputStream requestBody, HttpsURLConnectionImpl enclosing) throws IOException {
            super(policy, method, requestHeaders, connection, requestBody);
            this.sslSocket = connection != null ? connection.getSecureSocketIfConnected() : null;
            this.enclosing = enclosing;
        }

        protected void connect() throws IOException {
            boolean connectionReused;
            try {
                connectionReused = this.makeSslConnection(true);
            }
            catch (IOException e) {
                if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
                    throw e;
                }
                this.release(false);
                connectionReused = this.makeSslConnection(false);
            }
            if (!connectionReused) {
                this.sslSocket = this.connection.verifySecureSocketHostname(this.enclosing.getHostnameVerifier());
            }
        }

        private boolean makeSslConnection(boolean tlsTolerant) throws IOException {
            if (this.connection == null) {
                this.connection = this.openSocketConnection();
                if (this.connection.getAddress().getProxy() != null) {
                    this.makeTunnel(this.policy, this.connection, this.getRequestHeaders());
                }
            }
            this.sslSocket = this.connection.getSecureSocketIfConnected();
            if (this.sslSocket != null) {
                return true;
            }
            this.connection.setupSecureSocket(this.enclosing.getSSLSocketFactory(), tlsTolerant);
            return false;
        }

        private void makeTunnel(HttpURLConnectionImpl policy, HttpConnection connection, RequestHeaders requestHeaders) throws IOException {
            int responseCode;
            RawHeaders rawRequestHeaders = requestHeaders.getHeaders();
            block4: while (true) {
                ProxyConnectEngine connect = new ProxyConnectEngine(policy, rawRequestHeaders, connection);
                connect.sendRequest();
                connect.readResponse();
                responseCode = connect.getResponseCode();
                switch (connect.getResponseCode()) {
                    case 200: {
                        return;
                    }
                    case 407: {
                        rawRequestHeaders = new RawHeaders(rawRequestHeaders);
                        boolean credentialsFound = policy.processAuthHeader(407, connect.getResponseHeaders(), rawRequestHeaders);
                        if (credentialsFound) continue block4;
                        throw new IOException("Failed to authenticate with proxy");
                    }
                }
                break;
            }
            throw new IOException("Unexpected response code for CONNECT: " + responseCode);
        }

        protected boolean acceptCacheResponseType(CacheResponse cacheResponse) {
            return cacheResponse instanceof SecureCacheResponse;
        }

        protected boolean includeAuthorityInRequestLine() {
            return false;
        }

        protected HttpURLConnection getHttpConnectionToCache() {
            return this.enclosing;
        }
    }

    private final class HttpUrlConnectionDelegate
    extends HttpURLConnectionImpl {
        private HttpUrlConnectionDelegate(URL url, int port) {
            super(url, port);
        }

        private HttpUrlConnectionDelegate(URL url, int port, Proxy proxy) {
            super(url, port, proxy);
        }

        protected HttpEngine newHttpEngine(String method, RawHeaders requestHeaders, HttpConnection connection, RetryableOutputStream requestBody) throws IOException {
            return new HttpsEngine(this, method, requestHeaders, connection, requestBody, HttpsURLConnectionImpl.this);
        }

        public SecureCacheResponse getCacheResponse() {
            HttpsEngine engine = (HttpsEngine)this.httpEngine;
            return engine != null ? (SecureCacheResponse)engine.getCacheResponse() : null;
        }

        public SSLSocket getSSLSocket() {
            HttpsEngine engine = (HttpsEngine)this.httpEngine;
            return engine != null ? engine.sslSocket : null;
        }
    }
}

