/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import libcore.net.http.AbstractHttpOutputStream;

final class RetryableOutputStream
extends AbstractHttpOutputStream {
    private final int limit;
    private final ByteArrayOutputStream content;

    public RetryableOutputStream(int limit) {
        this.limit = limit;
        this.content = new ByteArrayOutputStream(limit);
    }

    public RetryableOutputStream() {
        this.limit = -1;
        this.content = new ByteArrayOutputStream();
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.content.size() < this.limit) {
            throw new IOException("content-length promised " + this.limit + " bytes, but received " + this.content.size());
        }
    }

    public synchronized void write(byte[] buffer, int offset, int count) throws IOException {
        this.checkNotClosed();
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        if (this.limit != -1 && this.content.size() > this.limit - count) {
            throw new IOException("exceeded content-length limit of " + this.limit + " bytes");
        }
        this.content.write(buffer, offset, count);
    }

    public synchronized int contentLength() throws IOException {
        this.close();
        return this.content.size();
    }

    public void writeToSocket(OutputStream socketOut) throws IOException {
        this.content.writeTo(socketOut);
    }
}

