/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;
import java.util.Arrays;
import libcore.net.http.AbstractHttpInputStream;
import libcore.net.http.HttpEngine;

final class UnknownLengthHttpInputStream
extends AbstractHttpInputStream {
    private boolean inputExhausted;

    UnknownLengthHttpInputStream(InputStream is, CacheRequest cacheRequest, HttpEngine httpEngine) throws IOException {
        super(is, httpEngine, cacheRequest);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        this.checkNotClosed();
        if (this.in == null || this.inputExhausted) {
            return -1;
        }
        int read = this.in.read(buffer, offset, count);
        if (read == -1) {
            this.inputExhausted = true;
            this.endOfInput(false);
            return -1;
        }
        this.cacheWrite(buffer, offset, read);
        return read;
    }

    public int available() throws IOException {
        this.checkNotClosed();
        return this.in == null ? 0 : this.in.available();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.inputExhausted) {
            this.unexpectedEndOfInput();
        }
    }
}

