/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.url;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import libcore.net.url.FtpURLInputStream;

public class FtpURLConnection
extends URLConnection {
    private static final int FTP_PORT = 21;
    private static final int FTP_DATAOPEN = 125;
    private static final int FTP_OPENDATA = 150;
    private static final int FTP_OK = 200;
    private static final int FTP_USERREADY = 220;
    private static final int FTP_TRANSFEROK = 226;
    private static final int FTP_LOGGEDIN = 230;
    private static final int FTP_FILEOK = 250;
    private static final int FTP_PASWD = 331;
    private static final int FTP_NOTFOUND = 550;
    private Socket controlSocket;
    private Socket dataSocket;
    private ServerSocket acceptSocket;
    private InputStream ctrlInput;
    private InputStream inputStream;
    private OutputStream ctrlOutput;
    private int dataPort;
    private String username = "anonymous";
    private String password = "";
    private String replyCode;
    private String hostName;
    private Proxy proxy;
    private Proxy currentProxy;
    private URI uri;

    protected FtpURLConnection(URL url) {
        super(url);
        this.hostName = url.getHost();
        String parse = url.getUserInfo();
        if (parse != null) {
            int split = parse.indexOf(58);
            if (split >= 0) {
                this.username = parse.substring(0, split);
                this.password = parse.substring(split + 1);
            } else {
                this.username = parse;
            }
        }
        this.uri = null;
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected FtpURLConnection(URL url, Proxy proxy) {
        this(url);
        this.proxy = proxy;
    }

    private void cd() throws IOException {
        int idx = this.url.getFile().lastIndexOf(47);
        if (idx > 0) {
            String dir = this.url.getFile().substring(0, idx);
            this.write("CWD " + dir + "\r\n");
            int reply = this.getReply();
            if (reply != 250 && dir.length() > 0 && dir.charAt(0) == '/') {
                this.write("CWD " + dir.substring(1) + "\r\n");
                reply = this.getReply();
            }
            if (reply != 250) {
                throw new IOException("Unable to change directories");
            }
        }
    }

    public void connect() throws IOException {
        ProxySelector selector;
        List<Object> proxyList = null;
        if (this.proxy != null) {
            proxyList = new ArrayList<Proxy>(1);
            proxyList.add(this.proxy);
        } else {
            selector = ProxySelector.getDefault();
            if (selector != null) {
                proxyList = selector.select(this.uri);
            }
        }
        if (proxyList == null) {
            this.currentProxy = null;
            this.connectInternal();
        } else {
            selector = ProxySelector.getDefault();
            Iterator<Object> iter = proxyList.iterator();
            boolean connectOK = false;
            String failureReason = "";
            while (iter.hasNext() && !connectOK) {
                this.currentProxy = (Proxy)iter.next();
                try {
                    this.connectInternal();
                    connectOK = true;
                }
                catch (IOException ioe) {
                    failureReason = ioe.getLocalizedMessage();
                    if (selector == null || Proxy.NO_PROXY == this.currentProxy) continue;
                    selector.connectFailed(this.uri, this.currentProxy.address(), ioe);
                }
            }
            if (!connectOK) {
                throw new IOException("Unable to connect to server: " + failureReason);
            }
        }
    }

    private void connectInternal() throws IOException {
        int port = this.url.getPort();
        int connectTimeout = this.getConnectTimeout();
        if (port <= 0) {
            port = 21;
        }
        this.controlSocket = this.currentProxy == null || Proxy.Type.HTTP == this.currentProxy.type() ? new Socket() : new Socket(this.currentProxy);
        InetSocketAddress addr = new InetSocketAddress(this.hostName, port);
        this.controlSocket.connect(addr, connectTimeout);
        this.connected = true;
        this.ctrlOutput = this.controlSocket.getOutputStream();
        this.ctrlInput = this.controlSocket.getInputStream();
        this.login();
        this.setType();
        if (!this.getDoInput()) {
            this.cd();
        }
        try {
            this.acceptSocket = new ServerSocket(0);
            this.dataPort = this.acceptSocket.getLocalPort();
            this.port();
            if (connectTimeout == 0) {
                connectTimeout = 3000;
            }
            this.acceptSocket.setSoTimeout(this.getConnectTimeout());
            if (this.getDoInput()) {
                this.getFile();
            } else {
                this.sendFile();
            }
            this.dataSocket = this.acceptSocket.accept();
            this.dataSocket.setSoTimeout(this.getReadTimeout());
            this.acceptSocket.close();
        }
        catch (InterruptedIOException e) {
            throw new IOException("Could not establish data connection");
        }
        if (this.getDoInput()) {
            this.inputStream = new FtpURLInputStream(new BufferedInputStream(this.dataSocket.getInputStream()), this.controlSocket);
        }
    }

    public String getContentType() {
        String result = FtpURLConnection.guessContentTypeFromName(this.url.getFile());
        if (result == null) {
            return "content/unknown";
        }
        return result;
    }

    private void getFile() throws IOException {
        String file = this.url.getFile();
        this.write("RETR " + file + "\r\n");
        int reply = this.getReply();
        if (reply == 550 && file.length() > 0 && file.charAt(0) == '/') {
            this.write("RETR " + file.substring(1) + "\r\n");
            reply = this.getReply();
        }
        if (reply != 150 && reply != 226) {
            throw new FileNotFoundException("Unable to retrieve file: " + reply);
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    public Permission getPermission() throws IOException {
        int port = this.url.getPort();
        if (port <= 0) {
            port = 21;
        }
        return new SocketPermission(this.hostName + ":" + port, "connect, resolve");
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.dataSocket.getOutputStream();
    }

    private int getReply() throws IOException {
        byte[] code = new byte[3];
        for (int i = 0; i < code.length; ++i) {
            int tmp = this.ctrlInput.read();
            if (tmp == -1) {
                throw new EOFException();
            }
            code[i] = (byte)tmp;
        }
        this.replyCode = new String(code, 0, code.length, Charsets.ISO_8859_1);
        boolean multiline = false;
        if (this.ctrlInput.read() == 45) {
            multiline = true;
        }
        this.readLine();
        if (multiline) {
            while (this.readMultiLine()) {
            }
        }
        try {
            return Integer.parseInt(this.replyCode);
        }
        catch (NumberFormatException e) {
            throw (IOException)new IOException("reply code is invalid").initCause(e);
        }
    }

    private void login() throws IOException {
        int reply = this.getReply();
        if (reply != 220) {
            throw new IOException("Unable to connect to server: " + this.url.getHost());
        }
        this.write("USER " + this.username + "\r\n");
        reply = this.getReply();
        if (reply != 331 && reply != 230) {
            throw new IOException("Unable to log in to server (USER): " + this.url.getHost());
        }
        if (reply == 331) {
            this.write("PASS " + this.password + "\r\n");
            reply = this.getReply();
            if (reply != 200 && reply != 220 && reply != 230) {
                throw new IOException("Unable to log in to server (PASS): " + this.url.getHost());
            }
        }
    }

    private void port() throws IOException {
        this.write("PORT " + this.controlSocket.getLocalAddress().getHostAddress().replace('.', ',') + ',' + (this.dataPort >> 8) + ',' + (this.dataPort & 0xFF) + "\r\n");
        if (this.getReply() != 200) {
            throw new IOException("Unable to configure data port");
        }
    }

    private String readLine() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.ctrlInput.read()) != 10) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private boolean readMultiLine() throws IOException {
        String line = this.readLine();
        if (line.length() < 4) {
            return true;
        }
        return !line.substring(0, 3).equals(this.replyCode) || line.charAt(3) != ' ';
    }

    private void sendFile() throws IOException {
        this.write("STOR " + this.url.getFile().substring(this.url.getFile().lastIndexOf(47) + 1, this.url.getFile().length()) + "\r\n");
        int reply = this.getReply();
        if (reply != 150 && reply != 200 && reply != 125) {
            throw new IOException("Unable to store file");
        }
    }

    public void setDoInput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError();
        }
        this.doInput = newValue;
        this.doOutput = !newValue;
    }

    public void setDoOutput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError();
        }
        this.doOutput = newValue;
        this.doInput = !newValue;
    }

    private void setType() throws IOException {
        this.write("TYPE I\r\n");
        if (this.getReply() != 200) {
            throw new IOException("Unable to set transfer type");
        }
    }

    private void write(String command) throws IOException {
        this.ctrlOutput.write(command.getBytes(Charsets.ISO_8859_1));
    }
}

