/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.lang.annotation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;

public class AnnotationMember
implements Serializable {
    protected static final char ERROR = '!';
    protected static final char ARRAY = '[';
    protected static final char OTHER = '*';
    protected static final Object NO_VALUE = DefaultValues.NO_VALUE;
    protected final String name;
    protected final Object value;
    protected final char tag;
    protected transient Class<?> elementType;
    protected transient Method definingMethod;

    public AnnotationMember(String name, Object val) {
        this.name = name;
        Object object = this.value = val == null ? NO_VALUE : val;
        this.tag = this.value instanceof Throwable ? (char)33 : (this.value.getClass().isArray() ? (char)91 : (char)42);
    }

    public AnnotationMember(String name, Object val, Class type, Method m) {
        this(name, val);
        this.definingMethod = m;
        this.elementType = type == Integer.TYPE ? Integer.class : (type == Boolean.TYPE ? Boolean.class : (type == Character.TYPE ? Character.class : (type == Float.TYPE ? Float.class : (type == Double.TYPE ? Double.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Byte.TYPE ? Byte.class : type)))))));
    }

    protected AnnotationMember setDefinition(AnnotationMember copy) {
        this.definingMethod = copy.definingMethod;
        this.elementType = copy.elementType;
        return this;
    }

    public String toString() {
        if (this.tag == '[') {
            StringBuilder sb = new StringBuilder(80);
            sb.append(this.name).append("=[");
            int len = Array.getLength(this.value);
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(Array.get(this.value, i));
            }
            return sb.append("]").toString();
        }
        return this.name + "=" + this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AnnotationMember) {
            AnnotationMember that = (AnnotationMember)obj;
            if (this.name.equals(that.name) && this.tag == that.tag) {
                if (this.tag == '[') {
                    return this.equalArrayValue(that.value);
                }
                if (this.tag == '!') {
                    return false;
                }
                return this.value.equals(that.value);
            }
        }
        return false;
    }

    public boolean equalArrayValue(Object otherValue) {
        if (this.value instanceof Object[] && otherValue instanceof Object[]) {
            return Arrays.equals((Object[])this.value, (Object[])otherValue);
        }
        Class<?> type = this.value.getClass();
        if (type != otherValue.getClass()) {
            return false;
        }
        if (type == int[].class) {
            return Arrays.equals((int[])this.value, (int[])otherValue);
        }
        if (type == byte[].class) {
            return Arrays.equals((byte[])this.value, (byte[])otherValue);
        }
        if (type == short[].class) {
            return Arrays.equals((short[])this.value, (short[])otherValue);
        }
        if (type == long[].class) {
            return Arrays.equals((long[])this.value, (long[])otherValue);
        }
        if (type == char[].class) {
            return Arrays.equals((char[])this.value, (char[])otherValue);
        }
        if (type == boolean[].class) {
            return Arrays.equals((boolean[])this.value, (boolean[])otherValue);
        }
        if (type == float[].class) {
            return Arrays.equals((float[])this.value, (float[])otherValue);
        }
        if (type == double[].class) {
            return Arrays.equals((double[])this.value, (double[])otherValue);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.name.hashCode() * 127;
        if (this.tag == '[') {
            Class<?> type = this.value.getClass();
            if (type == int[].class) {
                return hash ^ Arrays.hashCode((int[])this.value);
            }
            if (type == byte[].class) {
                return hash ^ Arrays.hashCode((byte[])this.value);
            }
            if (type == short[].class) {
                return hash ^ Arrays.hashCode((short[])this.value);
            }
            if (type == long[].class) {
                return hash ^ Arrays.hashCode((long[])this.value);
            }
            if (type == char[].class) {
                return hash ^ Arrays.hashCode((char[])this.value);
            }
            if (type == boolean[].class) {
                return hash ^ Arrays.hashCode((boolean[])this.value);
            }
            if (type == float[].class) {
                return hash ^ Arrays.hashCode((float[])this.value);
            }
            if (type == double[].class) {
                return hash ^ Arrays.hashCode((double[])this.value);
            }
            return hash ^ Arrays.hashCode((Object[])this.value);
        }
        return hash ^ this.value.hashCode();
    }

    public void rethrowError() throws Throwable {
        if (this.tag == '!') {
            if (this.value instanceof TypeNotPresentException) {
                TypeNotPresentException tnpe = (TypeNotPresentException)this.value;
                throw new TypeNotPresentException(tnpe.typeName(), tnpe.getCause());
            }
            if (this.value instanceof EnumConstantNotPresentException) {
                EnumConstantNotPresentException ecnpe = (EnumConstantNotPresentException)this.value;
                throw new EnumConstantNotPresentException(ecnpe.enumType(), ecnpe.constantName());
            }
            if (this.value instanceof ArrayStoreException) {
                ArrayStoreException ase = (ArrayStoreException)this.value;
                throw new ArrayStoreException(ase.getMessage());
            }
            Throwable error = (Throwable)this.value;
            StackTraceElement[] ste = error.getStackTrace();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(ste == null ? 512 : (ste.length + 1) * 80);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(error);
            oos.flush();
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            error = (Throwable)ois.readObject();
            ois.close();
            throw error;
        }
    }

    public Object validateValue() throws Throwable {
        if (this.tag == '!') {
            this.rethrowError();
        }
        if (this.value == NO_VALUE) {
            return null;
        }
        if (this.elementType == this.value.getClass() || this.elementType.isInstance(this.value)) {
            return this.copyValue();
        }
        throw new AnnotationTypeMismatchException(this.definingMethod, this.value.getClass().getName());
    }

    public Object copyValue() throws Throwable {
        if (this.tag != '[' || Array.getLength(this.value) == 0) {
            return this.value;
        }
        Class<?> type = this.value.getClass();
        if (type == int[].class) {
            return ((int[])this.value).clone();
        }
        if (type == byte[].class) {
            return ((byte[])this.value).clone();
        }
        if (type == short[].class) {
            return ((short[])this.value).clone();
        }
        if (type == long[].class) {
            return ((long[])this.value).clone();
        }
        if (type == char[].class) {
            return ((char[])this.value).clone();
        }
        if (type == boolean[].class) {
            return ((boolean[])this.value).clone();
        }
        if (type == float[].class) {
            return ((float[])this.value).clone();
        }
        if (type == double[].class) {
            return ((double[])this.value).clone();
        }
        return ((Object[])this.value).clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DefaultValues {
        NO_VALUE;

    }
}

