/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.lang.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.harmony.luni.lang.reflect.ListOfTypes;

public final class ImplForType
implements ParameterizedType {
    private final ListOfTypes args;
    private final ImplForType ownerType0;
    private Type ownerTypeRes;
    private Class rawType;
    private final String rawTypeName;
    private ClassLoader loader;

    public ImplForType(ImplForType ownerType, String rawTypeName, ListOfTypes args, ClassLoader loader) {
        this.ownerType0 = ownerType;
        this.rawTypeName = rawTypeName;
        this.args = args;
        this.loader = loader;
    }

    public Type[] getActualTypeArguments() {
        return (Type[])this.args.getResolvedTypes().clone();
    }

    public Type getOwnerType() {
        if (this.ownerTypeRes == null) {
            this.ownerTypeRes = this.ownerType0 != null ? this.ownerType0.getResolvedType() : this.getRawType().getDeclaringClass();
        }
        return this.ownerTypeRes;
    }

    public Class getRawType() {
        if (this.rawType == null) {
            try {
                this.rawType = Class.forName(this.rawTypeName, false, this.loader);
            }
            catch (ClassNotFoundException e) {
                throw new TypeNotPresentException(this.rawTypeName, e);
            }
        }
        return this.rawType;
    }

    Type getResolvedType() {
        if (this.args.getResolvedTypes().length == 0) {
            return this.getRawType();
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawTypeName);
        if (this.args.length() > 0) {
            sb.append("<").append(this.args).append(">");
        }
        return sb.toString();
    }
}

