/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.harmony.security.fortress.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Services {
    private static final Map<String, Provider.Service> services = new HashMap<String, Provider.Service>(600);
    private static Provider.Service secureRandom;
    private static boolean needRefresh;
    static int refreshNumber;
    private static final List<Provider> providers;
    private static final Map<String, Provider> providersNames;

    private static void loadProviders() {
        String providerClassName = null;
        int i = 1;
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        while ((providerClassName = Security.getProperty("security.provider." + i++)) != null) {
            try {
                Provider p = (Provider)Class.forName(providerClassName.trim(), true, cl).newInstance();
                providers.add(p);
                providersNames.put(p.getName(), p);
                Services.initServiceInfo(p);
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException e) {}
        }
        Engine.door.renumProviders();
    }

    public static Provider[] getProviders() {
        return providers.toArray(new Provider[providers.size()]);
    }

    public static List<Provider> getProvidersList() {
        return new ArrayList<Provider>(providers);
    }

    public static Provider getProvider(String name) {
        if (name == null) {
            return null;
        }
        return providersNames.get(name);
    }

    public static int insertProviderAt(Provider provider, int position) {
        int size = providers.size();
        if (position < 1 || position > size) {
            position = size + 1;
        }
        providers.add(position - 1, provider);
        providersNames.put(provider.getName(), provider);
        Services.setNeedRefresh();
        return position;
    }

    public static void removeProvider(int providerNumber) {
        Provider p = providers.remove(providerNumber - 1);
        providersNames.remove(p.getName());
        Services.setNeedRefresh();
    }

    public static void initServiceInfo(Provider p) {
        for (Provider.Service serv : p.getServices()) {
            String key;
            String type = serv.getType();
            if (secureRandom == null && type.equals("SecureRandom")) {
                secureRandom = serv;
            }
            if (!services.containsKey(key = type + "." + serv.getAlgorithm().toUpperCase(Locale.US))) {
                services.put(key, serv);
            }
            for (String alias : Engine.door.getAliases(serv)) {
                key = type + "." + alias.toUpperCase(Locale.US);
                if (services.containsKey(key)) continue;
                services.put(key, serv);
            }
        }
    }

    public static void updateServiceInfo() {
        services.clear();
        secureRandom = null;
        for (Provider p : providers) {
            Services.initServiceInfo(p);
        }
        needRefresh = false;
    }

    public static boolean isEmpty() {
        return services.isEmpty();
    }

    public static Provider.Service getService(String key) {
        return services.get(key);
    }

    public static Provider.Service getSecureRandomService() {
        return secureRandom;
    }

    public static void setNeedRefresh() {
        needRefresh = true;
    }

    public static void refresh() {
        if (needRefresh) {
            ++refreshNumber;
            Services.updateServiceInfo();
        }
    }

    static {
        refreshNumber = 1;
        providers = new ArrayList<Provider>(20);
        providersNames = new HashMap<String, Provider>(20);
        Services.loadProviders();
    }
}

