/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.cert;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.provider.cert.X509CRLEntryImpl;
import org.apache.harmony.security.utils.AlgNameMapper;
import org.apache.harmony.security.x509.CertificateList;
import org.apache.harmony.security.x509.Extension;
import org.apache.harmony.security.x509.Extensions;
import org.apache.harmony.security.x509.TBSCertList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CRLImpl
extends X509CRL {
    private final CertificateList crl;
    private final TBSCertList tbsCertList;
    private byte[] tbsCertListEncoding;
    private final Extensions extensions;
    private X500Principal issuer;
    private ArrayList entries;
    private int entriesSize;
    private byte[] signature;
    private String sigAlgOID;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private byte[] encoding;
    private boolean nullSigAlgParams;
    private boolean entriesRetrieved;
    private boolean isIndirectCRL;
    private int nonIndirectEntriesSize;

    public X509CRLImpl(CertificateList crl) {
        this.crl = crl;
        this.tbsCertList = crl.getTbsCertList();
        this.extensions = this.tbsCertList.getCrlExtensions();
    }

    public X509CRLImpl(InputStream in) throws CRLException {
        try {
            this.crl = (CertificateList)CertificateList.ASN1.decode(in);
            this.tbsCertList = this.crl.getTbsCertList();
            this.extensions = this.tbsCertList.getCrlExtensions();
        }
        catch (IOException e) {
            throw new CRLException(e);
        }
    }

    public X509CRLImpl(byte[] encoding) throws IOException {
        this((CertificateList)CertificateList.ASN1.decode(encoding));
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        if (this.encoding == null) {
            this.encoding = this.crl.getEncoded();
        }
        byte[] result = new byte[this.encoding.length];
        System.arraycopy(this.encoding, 0, result, 0, this.encoding.length);
        return result;
    }

    @Override
    public int getVersion() {
        return this.tbsCertList.getVersion();
    }

    @Override
    public Principal getIssuerDN() {
        if (this.issuer == null) {
            this.issuer = this.tbsCertList.getIssuer().getX500Principal();
        }
        return this.issuer;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.issuer == null) {
            this.issuer = this.tbsCertList.getIssuer().getX500Principal();
        }
        return this.issuer;
    }

    @Override
    public Date getThisUpdate() {
        return this.tbsCertList.getThisUpdate();
    }

    @Override
    public Date getNextUpdate() {
        return this.tbsCertList.getNextUpdate();
    }

    private void retrieveEntries() {
        this.entriesRetrieved = true;
        List<TBSCertList.RevokedCertificate> rcerts = this.tbsCertList.getRevokedCertificates();
        if (rcerts == null) {
            return;
        }
        this.entriesSize = rcerts.size();
        this.entries = new ArrayList(this.entriesSize);
        X500Principal rcertIssuer = null;
        for (int i = 0; i < this.entriesSize; ++i) {
            TBSCertList.RevokedCertificate rcert = rcerts.get(i);
            X500Principal iss = rcert.getIssuer();
            if (iss != null) {
                rcertIssuer = iss;
                this.isIndirectCRL = true;
                this.nonIndirectEntriesSize = i;
            }
            this.entries.add(new X509CRLEntryImpl(rcert, rcertIssuer));
        }
    }

    @Override
    public X509CRLEntry getRevokedCertificate(X509Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException();
        }
        if (!this.entriesRetrieved) {
            this.retrieveEntries();
        }
        if (this.entries == null) {
            return null;
        }
        BigInteger serialN = certificate.getSerialNumber();
        if (this.isIndirectCRL) {
            X500Principal certIssuer = certificate.getIssuerX500Principal();
            if (certIssuer.equals(this.getIssuerX500Principal())) {
                certIssuer = null;
            }
            for (int i = 0; i < this.entriesSize; ++i) {
                X509CRLEntry entry = (X509CRLEntry)this.entries.get(i);
                if (!serialN.equals(entry.getSerialNumber())) continue;
                X500Principal iss = entry.getCertificateIssuer();
                if (!(certIssuer != null ? certIssuer.equals(iss) : iss == null)) continue;
                return entry;
            }
        } else {
            for (int i = 0; i < this.entriesSize; ++i) {
                X509CRLEntry entry = (X509CRLEntry)this.entries.get(i);
                if (!serialN.equals(entry.getSerialNumber())) continue;
                return entry;
            }
        }
        return null;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        if (!this.entriesRetrieved) {
            this.retrieveEntries();
        }
        if (this.entries == null) {
            return null;
        }
        for (int i = 0; i < this.nonIndirectEntriesSize; ++i) {
            X509CRLEntry entry = (X509CRLEntry)this.entries.get(i);
            if (!serialNumber.equals(entry.getSerialNumber())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Set<? extends X509CRLEntry> getRevokedCertificates() {
        if (!this.entriesRetrieved) {
            this.retrieveEntries();
        }
        if (this.entries == null) {
            return null;
        }
        return new HashSet(this.entries);
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertListEncoding == null) {
            this.tbsCertListEncoding = this.tbsCertList.getEncoded();
        }
        byte[] result = new byte[this.tbsCertListEncoding.length];
        System.arraycopy(this.tbsCertListEncoding, 0, result, 0, this.tbsCertListEncoding.length);
        return result;
    }

    @Override
    public byte[] getSignature() {
        if (this.signature == null) {
            this.signature = this.crl.getSignatureValue();
        }
        byte[] result = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, result, 0, this.signature.length);
        return result;
    }

    @Override
    public String getSigAlgName() {
        if (this.sigAlgOID == null) {
            this.sigAlgOID = this.tbsCertList.getSignature().getAlgorithm();
            this.sigAlgName = AlgNameMapper.map2AlgName(this.sigAlgOID);
            if (this.sigAlgName == null) {
                this.sigAlgName = this.sigAlgOID;
            }
        }
        return this.sigAlgName;
    }

    @Override
    public String getSigAlgOID() {
        if (this.sigAlgOID == null) {
            this.sigAlgOID = this.tbsCertList.getSignature().getAlgorithm();
            this.sigAlgName = AlgNameMapper.map2AlgName(this.sigAlgOID);
            if (this.sigAlgName == null) {
                this.sigAlgName = this.sigAlgOID;
            }
        }
        return this.sigAlgOID;
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.nullSigAlgParams) {
            return null;
        }
        if (this.sigAlgParams == null) {
            this.sigAlgParams = this.tbsCertList.getSignature().getParameters();
            if (this.sigAlgParams == null) {
                this.nullSigAlgParams = true;
                return null;
            }
        }
        return this.sigAlgParams;
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.getSigAlgName());
        signature.initVerify(key);
        byte[] tbsEncoding = this.tbsCertList.getEncoded();
        signature.update(tbsEncoding, 0, tbsEncoding.length);
        if (!signature.verify(this.crl.getSignatureValue())) {
            throw new SignatureException("Signature was not verified");
        }
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.getSigAlgName(), sigProvider);
        signature.initVerify(key);
        byte[] tbsEncoding = this.tbsCertList.getEncoded();
        signature.update(tbsEncoding, 0, tbsEncoding.length);
        if (!signature.verify(this.crl.getSignatureValue())) {
            throw new SignatureException("Signature was not verified");
        }
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return false;
        }
        return this.getRevokedCertificate((X509Certificate)cert) != null;
    }

    @Override
    public String toString() {
        return this.crl.toString();
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getNonCriticalExtensions();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getCriticalExtensions();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        Extension ext = this.extensions.getExtensionByOID(oid);
        return ext == null ? null : ext.getRawExtnValue();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCritical();
    }
}

