/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.cert;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charsets;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import libcore.io.Base64;
import libcore.io.Streams;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.pkcs7.ContentInfo;
import org.apache.harmony.security.pkcs7.SignedData;
import org.apache.harmony.security.provider.cert.Cache;
import org.apache.harmony.security.provider.cert.X509CRLImpl;
import org.apache.harmony.security.provider.cert.X509CertImpl;
import org.apache.harmony.security.provider.cert.X509CertPathImpl;
import org.apache.harmony.security.x509.CertificateList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CertFactoryImpl
extends CertificateFactorySpi {
    private static final int CERT_CACHE_SEED_LENGTH = 28;
    private static final Cache CERT_CACHE = new Cache(28);
    private static final int CRL_CACHE_SEED_LENGTH = 24;
    private static final Cache CRL_CACHE = new Cache(24);
    private static final byte[] PEM_BEGIN = "-----BEGIN".getBytes(Charsets.UTF_8);
    private static final byte[] PEM_END = "-----END".getBytes(Charsets.UTF_8);
    private static final byte[] FREE_BOUND_SUFFIX = null;
    private static final byte[] CERT_BOUND_SUFFIX = " CERTIFICATE-----".getBytes(Charsets.UTF_8);

    @Override
    public Certificate engineGenerateCertificate(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("inStream == null");
        }
        try {
            if (!inStream.markSupported()) {
                inStream = new RestoringInputStream(inStream);
            }
            inStream.mark(1);
            if (inStream.read() == 45) {
                return X509CertFactoryImpl.getCertificate(this.decodePEM(inStream, CERT_BOUND_SUFFIX));
            }
            inStream.reset();
            return X509CertFactoryImpl.getCertificate(inStream);
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("inStream == null");
        }
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        try {
            int ch;
            if (!inStream.markSupported()) {
                inStream = new RestoringInputStream(inStream);
            }
            byte[] encoding = null;
            int second_asn1_tag = -1;
            inStream.mark(1);
            while ((ch = inStream.read()) != -1) {
                if (ch == 45) {
                    encoding = this.decodePEM(inStream, FREE_BOUND_SUFFIX);
                } else if (ch == 48) {
                    encoding = null;
                    inStream.reset();
                    inStream.mark(28);
                } else {
                    if (result.size() == 0) {
                        throw new CertificateException("Unsupported encoding");
                    }
                    inStream.reset();
                    return result;
                }
                BerInputStream in = encoding == null ? new BerInputStream(inStream) : new BerInputStream(encoding);
                second_asn1_tag = in.next();
                if (encoding == null) {
                    inStream.reset();
                }
                if (second_asn1_tag != 48) {
                    if (result.size() == 0) break;
                    return result;
                }
                if (encoding == null) {
                    result.add(X509CertFactoryImpl.getCertificate(inStream));
                } else {
                    result.add(X509CertFactoryImpl.getCertificate(encoding));
                }
                inStream.mark(1);
            }
            if (result.size() != 0) {
                return result;
            }
            if (ch == -1) {
                throw new CertificateException("There is no data in the stream");
            }
            if (second_asn1_tag == 6) {
                ContentInfo info = (ContentInfo)(encoding != null ? ContentInfo.ASN1.decode(encoding) : ContentInfo.ASN1.decode(inStream));
                SignedData data = info.getSignedData();
                if (data == null) {
                    throw new CertificateException("Invalid PKCS7 data provided");
                }
                List<org.apache.harmony.security.x509.Certificate> certs = data.getCertificates();
                if (certs != null) {
                    for (org.apache.harmony.security.x509.Certificate cert : certs) {
                        result.add(new X509CertImpl(cert));
                    }
                }
                return result;
            }
            throw new CertificateException("Unsupported encoding");
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        if (inStream == null) {
            throw new CRLException("inStream == null");
        }
        try {
            if (!inStream.markSupported()) {
                inStream = new RestoringInputStream(inStream);
            }
            inStream.mark(1);
            if (inStream.read() == 45) {
                return X509CertFactoryImpl.getCRL(this.decodePEM(inStream, FREE_BOUND_SUFFIX));
            }
            inStream.reset();
            return X509CertFactoryImpl.getCRL(inStream);
        }
        catch (IOException e) {
            throw new CRLException(e);
        }
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream inStream) throws CRLException {
        if (inStream == null) {
            throw new CRLException("inStream == null");
        }
        ArrayList<CRL> result = new ArrayList<CRL>();
        try {
            int ch;
            if (!inStream.markSupported()) {
                inStream = new RestoringInputStream(inStream);
            }
            byte[] encoding = null;
            int second_asn1_tag = -1;
            inStream.mark(1);
            while ((ch = inStream.read()) != -1) {
                if (ch == 45) {
                    encoding = this.decodePEM(inStream, FREE_BOUND_SUFFIX);
                } else if (ch == 48) {
                    encoding = null;
                    inStream.reset();
                    inStream.mark(24);
                } else {
                    if (result.size() == 0) {
                        throw new CRLException("Unsupported encoding");
                    }
                    inStream.reset();
                    return result;
                }
                BerInputStream in = encoding == null ? new BerInputStream(inStream) : new BerInputStream(encoding);
                second_asn1_tag = in.next();
                if (encoding == null) {
                    inStream.reset();
                }
                if (second_asn1_tag != 48) {
                    if (result.size() == 0) break;
                    return result;
                }
                if (encoding == null) {
                    result.add(X509CertFactoryImpl.getCRL(inStream));
                } else {
                    result.add(X509CertFactoryImpl.getCRL(encoding));
                }
                inStream.mark(1);
            }
            if (result.size() != 0) {
                return result;
            }
            if (ch == -1) {
                throw new CRLException("There is no data in the stream");
            }
            if (second_asn1_tag == 6) {
                ContentInfo info = (ContentInfo)(encoding != null ? ContentInfo.ASN1.decode(encoding) : ContentInfo.ASN1.decode(inStream));
                SignedData data = info.getSignedData();
                if (data == null) {
                    throw new CRLException("Invalid PKCS7 data provided");
                }
                List<CertificateList> crls = data.getCRLs();
                if (crls != null) {
                    for (CertificateList crl : crls) {
                        result.add(new X509CRLImpl(crl));
                    }
                }
                return result;
            }
            throw new CRLException("Unsupported encoding");
        }
        catch (IOException e) {
            throw new CRLException(e);
        }
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("inStream == null");
        }
        return this.engineGenerateCertPath(inStream, "PkiPath");
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("inStream == null");
        }
        if (!inStream.markSupported()) {
            inStream = new RestoringInputStream(inStream);
        }
        try {
            inStream.mark(1);
            int ch = inStream.read();
            if (ch == 45) {
                return X509CertPathImpl.getInstance(this.decodePEM(inStream, FREE_BOUND_SUFFIX), encoding);
            }
            if (ch == 48) {
                inStream.reset();
                return X509CertPathImpl.getInstance(inStream, encoding);
            }
            throw new CertificateException("Unsupported encoding");
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        return new X509CertPathImpl(certificates);
    }

    @Override
    public Iterator<String> engineGetCertPathEncodings() {
        return X509CertPathImpl.encodings.iterator();
    }

    private byte[] decodePEM(InputStream inStream, byte[] boundary_suffix) throws IOException {
        int i;
        int ch;
        int i2;
        for (i2 = 1; i2 < PEM_BEGIN.length; ++i2) {
            ch = inStream.read();
            if (PEM_BEGIN[i2] == ch) continue;
            throw new IOException("Incorrect PEM encoding: '-----BEGIN" + (boundary_suffix == null ? "" : new String(boundary_suffix)) + "' is expected as opening delimiter boundary.");
        }
        if (boundary_suffix == null) {
            while ((ch = inStream.read()) != 10) {
                if (ch != -1) continue;
                throw new IOException("Incorrect PEM encoding: EOF before content");
            }
        } else {
            for (i2 = 0; i2 < boundary_suffix.length; ++i2) {
                if (boundary_suffix[i2] == inStream.read()) continue;
                throw new IOException("Incorrect PEM encoding: '-----BEGIN" + new String(boundary_suffix) + "' is expected as opening delimiter boundary.");
            }
            ch = inStream.read();
            if (ch == 13) {
                ch = inStream.read();
            }
            if (ch != 10) {
                throw new IOException("Incorrect PEM encoding: newline expected after opening delimiter boundary");
            }
        }
        int size = 1024;
        byte[] buff = new byte[size];
        int index = 0;
        while ((ch = inStream.read()) != 45) {
            if (ch == -1) {
                throw new IOException("Incorrect Base64 encoding: EOF without closing delimiter");
            }
            buff[index++] = (byte)ch;
            if (index != size) continue;
            byte[] newbuff = new byte[size + 1024];
            System.arraycopy(buff, 0, newbuff, 0, size);
            buff = newbuff;
            size += 1024;
        }
        if (buff[index - 1] != 10) {
            throw new IOException("Incorrect Base64 encoding: newline expected before closing boundary delimiter");
        }
        for (i = 1; i < PEM_END.length; ++i) {
            if (PEM_END[i] == inStream.read()) continue;
            throw this.badEnd(boundary_suffix);
        }
        if (boundary_suffix == null) {
            while ((ch = inStream.read()) != -1 && ch != 10 && ch != 13) {
            }
        } else {
            for (i = 0; i < boundary_suffix.length; ++i) {
                if (boundary_suffix[i] == inStream.read()) continue;
                throw this.badEnd(boundary_suffix);
            }
        }
        inStream.mark(1);
        while ((ch = inStream.read()) != -1 && (ch == 10 || ch == 13)) {
            inStream.mark(1);
        }
        inStream.reset();
        buff = Base64.decode(buff, index);
        if (buff == null) {
            throw new IOException("Incorrect Base64 encoding");
        }
        return buff;
    }

    private IOException badEnd(byte[] boundary_suffix) throws IOException {
        String s = boundary_suffix == null ? "" : new String(boundary_suffix);
        throw new IOException("Incorrect PEM encoding: '-----END" + s + "' is expected as closing delimiter boundary.");
    }

    private static byte[] readBytes(InputStream source, int length) throws IOException {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            int bytik = source.read();
            if (bytik == -1) {
                return null;
            }
            result[i] = (byte)bytik;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Certificate getCertificate(byte[] encoding) throws CertificateException, IOException {
        if (encoding.length < 28) {
            throw new CertificateException("encoding.length < CERT_CACHE_SEED_LENGTH");
        }
        Cache cache = CERT_CACHE;
        synchronized (cache) {
            Certificate res;
            long hash = CERT_CACHE.getHash(encoding);
            if (CERT_CACHE.contains(hash) && (res = (Certificate)CERT_CACHE.get(hash, encoding)) != null) {
                return res;
            }
            res = new X509CertImpl(encoding);
            CERT_CACHE.put(hash, encoding, res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Certificate getCertificate(InputStream inStream) throws CertificateException, IOException {
        Cache cache = CERT_CACHE;
        synchronized (cache) {
            inStream.mark(28);
            byte[] buff = X509CertFactoryImpl.readBytes(inStream, 28);
            inStream.reset();
            if (buff == null) {
                throw new CertificateException("InputStream doesn't contain enough data");
            }
            long hash = CERT_CACHE.getHash(buff);
            if (CERT_CACHE.contains(hash)) {
                byte[] encoding = new byte[BerInputStream.getLength(buff)];
                if (encoding.length < 28) {
                    throw new CertificateException("Bad Certificate encoding");
                }
                Streams.readFully(inStream, encoding);
                Certificate res = (Certificate)CERT_CACHE.get(hash, encoding);
                if (res != null) {
                    return res;
                }
                res = new X509CertImpl(encoding);
                CERT_CACHE.put(hash, encoding, res);
                return res;
            }
            inStream.reset();
            X509CertImpl res = new X509CertImpl(inStream);
            CERT_CACHE.put(hash, ((Certificate)res).getEncoded(), res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CRL getCRL(byte[] encoding) throws CRLException, IOException {
        if (encoding.length < 24) {
            throw new CRLException("encoding.length < CRL_CACHE_SEED_LENGTH");
        }
        Cache cache = CRL_CACHE;
        synchronized (cache) {
            X509CRL res;
            long hash = CRL_CACHE.getHash(encoding);
            if (CRL_CACHE.contains(hash) && (res = (X509CRL)CRL_CACHE.get(hash, encoding)) != null) {
                return res;
            }
            res = new X509CRLImpl(encoding);
            CRL_CACHE.put(hash, encoding, res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CRL getCRL(InputStream inStream) throws CRLException, IOException {
        Cache cache = CRL_CACHE;
        synchronized (cache) {
            inStream.mark(24);
            byte[] buff = X509CertFactoryImpl.readBytes(inStream, 24);
            inStream.reset();
            if (buff == null) {
                throw new CRLException("InputStream doesn't contain enough data");
            }
            long hash = CRL_CACHE.getHash(buff);
            if (CRL_CACHE.contains(hash)) {
                byte[] encoding = new byte[BerInputStream.getLength(buff)];
                if (encoding.length < 24) {
                    throw new CRLException("Bad CRL encoding");
                }
                Streams.readFully(inStream, encoding);
                CRL res = (CRL)CRL_CACHE.get(hash, encoding);
                if (res != null) {
                    return res;
                }
                res = new X509CRLImpl(encoding);
                CRL_CACHE.put(hash, encoding, res);
                return res;
            }
            X509CRLImpl res = new X509CRLImpl(inStream);
            CRL_CACHE.put(hash, ((X509CRL)res).getEncoded(), res);
            return res;
        }
    }

    private static class RestoringInputStream
    extends InputStream {
        private final InputStream inStream;
        private static final int BUFF_SIZE = 32;
        private final int[] buff = new int[64];
        private int pos = -1;
        private int bar = 0;
        private int end = 0;

        public RestoringInputStream(InputStream inStream) {
            this.inStream = inStream;
        }

        public int available() throws IOException {
            return this.bar - this.pos + this.inStream.available();
        }

        public void close() throws IOException {
            this.inStream.close();
        }

        public void mark(int readlimit) {
            if (this.pos < 0) {
                this.pos = 0;
                this.bar = 0;
                this.end = 31;
            } else {
                this.end = (this.pos + 32 - 1) % 32;
            }
        }

        public boolean markSupported() {
            return true;
        }

        public int read() throws IOException {
            if (this.pos >= 0) {
                int cur = this.pos % 32;
                if (cur < this.bar) {
                    ++this.pos;
                    return this.buff[cur];
                }
                if (cur != this.end) {
                    this.buff[cur] = this.inStream.read();
                    this.bar = cur + 1;
                    ++this.pos;
                    return this.buff[cur];
                }
                this.pos = -1;
            }
            return this.inStream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            for (i = 0; i < len; ++i) {
                int read_b = this.read();
                if (read_b == -1) {
                    return i == 0 ? -1 : i;
                }
                b[off + i] = (byte)read_b;
            }
            return i;
        }

        public void reset() throws IOException {
            if (this.pos < 0) {
                throw new IOException("Could not reset the stream: position became invalid or stream has not been marked");
            }
            this.pos = (this.end + 1) % 32;
        }
    }
}

