/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.cert;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.utils.AlgNameMapper;
import org.apache.harmony.security.x509.Certificate;
import org.apache.harmony.security.x509.Extension;
import org.apache.harmony.security.x509.Extensions;
import org.apache.harmony.security.x509.TBSCertificate;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class X509CertImpl
extends X509Certificate {
    private static final long serialVersionUID = 2972248729446736154L;
    private final Certificate certificate;
    private final TBSCertificate tbsCert;
    private final Extensions extensions;
    private volatile long notBefore = -1L;
    private volatile long notAfter = -1L;
    private volatile BigInteger serialNumber;
    private volatile X500Principal issuer;
    private volatile X500Principal subject;
    private volatile byte[] tbsCertificate;
    private volatile byte[] signature;
    private volatile String sigAlgName;
    private volatile String sigAlgOID;
    private volatile byte[] sigAlgParams;
    private volatile boolean nullSigAlgParams;
    private volatile PublicKey publicKey;
    private volatile byte[] encoding;

    public X509CertImpl(InputStream in) throws CertificateException {
        try {
            this.certificate = (Certificate)Certificate.ASN1.decode(in);
            this.tbsCert = this.certificate.getTbsCertificate();
            this.extensions = this.tbsCert.getExtensions();
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    public X509CertImpl(Certificate certificate) {
        this.certificate = certificate;
        this.tbsCert = certificate.getTbsCertificate();
        this.extensions = this.tbsCert.getExtensions();
    }

    public X509CertImpl(byte[] encoding) throws IOException {
        this((Certificate)Certificate.ASN1.decode(encoding));
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(System.currentTimeMillis());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(date.getTime());
    }

    private void checkValidity(long time) throws CertificateExpiredException, CertificateNotYetValidException {
        if (time < this.getNotBeforeInternal()) {
            throw new CertificateNotYetValidException("current time: " + new Date(time) + ", validation time: " + new Date(this.getNotBeforeInternal()));
        }
        if (time > this.getNotAfterInternal()) {
            throw new CertificateExpiredException("current time: " + new Date(time) + ", expiration time: " + new Date(this.getNotAfterInternal()));
        }
    }

    @Override
    public int getVersion() {
        return this.tbsCert.getVersion() + 1;
    }

    @Override
    public BigInteger getSerialNumber() {
        BigInteger result = this.serialNumber;
        if (result == null) {
            this.serialNumber = result = this.tbsCert.getSerialNumber();
        }
        return result;
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        X500Principal result = this.issuer;
        if (result == null) {
            this.issuer = result = this.tbsCert.getIssuer().getX500Principal();
        }
        return result;
    }

    @Override
    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        X500Principal result = this.subject;
        if (result == null) {
            this.subject = result = this.tbsCert.getSubject().getX500Principal();
        }
        return result;
    }

    @Override
    public Date getNotBefore() {
        return new Date(this.getNotBeforeInternal());
    }

    private long getNotBeforeInternal() {
        long result = this.notBefore;
        if (result == -1L) {
            this.notBefore = result = this.tbsCert.getValidity().getNotBefore().getTime();
        }
        return result;
    }

    @Override
    public Date getNotAfter() {
        return new Date(this.getNotAfterInternal());
    }

    private long getNotAfterInternal() {
        long result = this.notAfter;
        if (result == -1L) {
            this.notAfter = result = this.tbsCert.getValidity().getNotAfter().getTime();
        }
        return result;
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return (byte[])this.getTbsCertificateInternal().clone();
    }

    private byte[] getTbsCertificateInternal() {
        byte[] result = this.tbsCertificate;
        if (result == null) {
            this.tbsCertificate = result = this.tbsCert.getEncoded();
        }
        return result;
    }

    @Override
    public byte[] getSignature() {
        return (byte[])this.getSignatureInternal().clone();
    }

    private byte[] getSignatureInternal() {
        byte[] result = this.signature;
        if (result == null) {
            this.signature = result = this.certificate.getSignatureValue();
        }
        return result;
    }

    @Override
    public String getSigAlgName() {
        String result = this.sigAlgName;
        if (result == null) {
            String sigAlgOIDLocal = this.getSigAlgOID();
            result = AlgNameMapper.map2AlgName(sigAlgOIDLocal);
            if (result == null) {
                result = sigAlgOIDLocal;
            }
            this.sigAlgName = result;
        }
        return result;
    }

    @Override
    public String getSigAlgOID() {
        String result = this.sigAlgOID;
        if (result == null) {
            this.sigAlgOID = result = this.tbsCert.getSignature().getAlgorithm();
        }
        return result;
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.nullSigAlgParams) {
            return null;
        }
        byte[] result = this.sigAlgParams;
        if (result == null) {
            result = this.tbsCert.getSignature().getParameters();
            if (result == null) {
                this.nullSigAlgParams = true;
                return null;
            }
            this.sigAlgParams = result;
        }
        return result;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.tbsCert.getIssuerUniqueID();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.tbsCert.getSubjectUniqueID();
    }

    @Override
    public boolean[] getKeyUsage() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.valueOfKeyUsage();
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        if (this.extensions == null) {
            return null;
        }
        try {
            return this.extensions.valueOfExtendedKeyUsage();
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    @Override
    public int getBasicConstraints() {
        if (this.extensions == null) {
            return Integer.MAX_VALUE;
        }
        return this.extensions.valueOfBasicConstrains();
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        if (this.extensions == null) {
            return null;
        }
        try {
            return this.extensions.valueOfSubjectAlternativeName();
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        if (this.extensions == null) {
            return null;
        }
        try {
            return this.extensions.valueOfIssuerAlternativeName();
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.getEncodedInternal().clone();
    }

    private byte[] getEncodedInternal() throws CertificateEncodingException {
        byte[] result = this.encoding;
        if (this.encoding == null) {
            this.encoding = result = this.certificate.getEncoded();
        }
        return result;
    }

    @Override
    public PublicKey getPublicKey() {
        PublicKey result = this.publicKey;
        if (result == null) {
            this.publicKey = result = this.tbsCert.getSubjectPublicKeyInfo().getPublicKey();
        }
        return result;
    }

    @Override
    public String toString() {
        return this.certificate.toString();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = OpenSSLSignature.getInstance(this.getSigAlgName());
        }
        catch (NoSuchAlgorithmException ignored) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        signature.initVerify(key);
        byte[] tbsCertificateLocal = this.getTbsCertificateInternal();
        signature.update(tbsCertificateLocal, 0, tbsCertificateLocal.length);
        if (!signature.verify(this.certificate.getSignatureValue())) {
            throw new SignatureException("Signature was not verified");
        }
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = sigProvider == null ? OpenSSLSignature.getInstance(this.getSigAlgName()) : Signature.getInstance(this.getSigAlgName(), sigProvider);
        }
        catch (NoSuchAlgorithmException ignored) {
            signature = Signature.getInstance(this.getSigAlgName(), sigProvider);
        }
        signature.initVerify(key);
        byte[] tbsCertificateLocal = this.getTbsCertificateInternal();
        signature.update(tbsCertificateLocal, 0, tbsCertificateLocal.length);
        if (!signature.verify(this.certificate.getSignatureValue())) {
            throw new SignatureException("Signature was not verified");
        }
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getNonCriticalExtensions();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getCriticalExtensions();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        Extension ext = this.extensions.getExtensionByOID(oid);
        return ext == null ? null : ext.getRawExtnValue();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCritical();
    }
}

