/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.cert;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.pkcs7.ContentInfo;
import org.apache.harmony.security.pkcs7.SignedData;
import org.apache.harmony.security.provider.cert.X509CertImpl;
import org.apache.harmony.security.x509.Certificate;

public class X509CertPathImpl
extends CertPath {
    private static final long serialVersionUID = 7989755106209515436L;
    public static final int PKI_PATH = 0;
    public static final int PKCS7 = 1;
    private static final String[] encodingsArr = new String[]{"PkiPath", "PKCS7"};
    static final List encodings = Collections.unmodifiableList(Arrays.asList(encodingsArr));
    private final List certificates;
    private byte[] pkiPathEncoding;
    private byte[] pkcs7Encoding;
    public static final ASN1SequenceOf ASN1 = new ASN1SequenceOf(ASN1Any.getInstance()){

        public Object getDecodedObject(BerInputStream in) throws IOException {
            List encodings = (List)in.content;
            int size = encodings.size();
            ArrayList<X509CertImpl> certificates = new ArrayList<X509CertImpl>(size);
            for (int i = 0; i < size; ++i) {
                certificates.add(new X509CertImpl((Certificate)Certificate.ASN1.decode((byte[])encodings.get(i))));
            }
            return new X509CertPathImpl(certificates, 0, in.getEncoded());
        }

        public Collection getValues(Object object) {
            X509CertPathImpl cp = (X509CertPathImpl)object;
            if (cp.certificates == null) {
                return new ArrayList();
            }
            int size = cp.certificates.size();
            ArrayList<byte[]> encodings = new ArrayList<byte[]>(size);
            try {
                for (int i = 0; i < size; ++i) {
                    encodings.add(((X509Certificate)cp.certificates.get(i)).getEncoded());
                }
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Encoding Error occurred");
            }
            return encodings;
        }
    };
    private static final ASN1Sequence ASN1_SIGNED_DATA = new ASN1Sequence(new ASN1Type[]{ASN1Any.getInstance(), new ASN1Implicit(0, ASN1), ASN1Any.getInstance()}){
        private final byte[] PRECALCULATED_HEAD = new byte[]{2, 1, 1, 49, 0, 48, 3, 6, 1, 0};
        private final byte[] SIGNERS_INFO = new byte[]{49, 0};

        protected void getValues(Object object, Object[] values) {
            values[0] = this.PRECALCULATED_HEAD;
            values[1] = object;
            values[2] = this.SIGNERS_INFO;
        }

        public Object decode(BerInputStream in) throws IOException {
            throw new RuntimeException("Invalid use of encoder for PKCS#7 SignedData object");
        }
    };
    private static final ASN1Sequence PKCS7_SIGNED_DATA_OBJECT = new ASN1Sequence(new ASN1Type[]{ASN1Any.getInstance(), new ASN1Explicit(0, ASN1_SIGNED_DATA)}){
        private final byte[] SIGNED_DATA_OID = ASN1Oid.getInstance().encode(ContentInfo.SIGNED_DATA);

        protected void getValues(Object object, Object[] values) {
            values[0] = this.SIGNED_DATA_OID;
            values[1] = object;
        }

        public Object decode(BerInputStream in) throws IOException {
            throw new RuntimeException("Invalid use of encoder for PKCS#7 SignedData object");
        }
    };

    public X509CertPathImpl(List certs) throws CertificateException {
        super("X.509");
        int size = certs.size();
        this.certificates = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object cert = certs.get(i);
            if (!(cert instanceof X509Certificate)) {
                throw new CertificateException("One of the provided certificates is not an X509 certificate");
            }
            this.certificates.add(cert);
        }
    }

    private X509CertPathImpl(List certs, int type, byte[] encoding) {
        super("X.509");
        if (type == 0) {
            this.pkiPathEncoding = encoding;
        } else {
            this.pkcs7Encoding = encoding;
        }
        this.certificates = certs;
    }

    public static X509CertPathImpl getInstance(InputStream in) throws CertificateException {
        try {
            return (X509CertPathImpl)ASN1.decode(in);
        }
        catch (IOException e) {
            throw new CertificateException("Incorrect encoded form: " + e.getMessage());
        }
    }

    public static X509CertPathImpl getInstance(InputStream in, String encoding) throws CertificateException {
        if (!encodings.contains(encoding)) {
            throw new CertificateException("Unsupported encoding");
        }
        try {
            if (encodingsArr[0].equals(encoding)) {
                return (X509CertPathImpl)ASN1.decode(in);
            }
            ContentInfo ci = (ContentInfo)ContentInfo.ASN1.decode(in);
            SignedData sd = ci.getSignedData();
            if (sd == null) {
                throw new CertificateException("Incorrect PKCS7 encoded form: missing signed data");
            }
            List<Certificate> certs = sd.getCertificates();
            if (certs == null) {
                certs = new ArrayList<Certificate>();
            }
            ArrayList<X509CertImpl> result = new ArrayList<X509CertImpl>();
            for (Certificate cert : certs) {
                result.add(new X509CertImpl(cert));
            }
            return new X509CertPathImpl(result, 1, ci.getEncoded());
        }
        catch (IOException e) {
            throw new CertificateException("Incorrect encoded form: " + e.getMessage());
        }
    }

    public static X509CertPathImpl getInstance(byte[] in) throws CertificateException {
        try {
            return (X509CertPathImpl)ASN1.decode(in);
        }
        catch (IOException e) {
            throw new CertificateException("Incorrect encoded form: " + e.getMessage());
        }
    }

    public static X509CertPathImpl getInstance(byte[] in, String encoding) throws CertificateException {
        if (!encodings.contains(encoding)) {
            throw new CertificateException("Unsupported encoding");
        }
        try {
            if (encodingsArr[0].equals(encoding)) {
                return (X509CertPathImpl)ASN1.decode(in);
            }
            ContentInfo ci = (ContentInfo)ContentInfo.ASN1.decode(in);
            SignedData sd = ci.getSignedData();
            if (sd == null) {
                throw new CertificateException("Incorrect PKCS7 encoded form: missing signed data");
            }
            List<Certificate> certs = sd.getCertificates();
            if (certs == null) {
                certs = new ArrayList<Certificate>();
            }
            ArrayList<X509CertImpl> result = new ArrayList<X509CertImpl>();
            for (Certificate cert : certs) {
                result.add(new X509CertImpl(cert));
            }
            return new X509CertPathImpl(result, 1, ci.getEncoded());
        }
        catch (IOException e) {
            throw new CertificateException("Incorrect encoded form: " + e.getMessage());
        }
    }

    public List getCertificates() {
        return Collections.unmodifiableList(this.certificates);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        if (this.pkiPathEncoding == null) {
            this.pkiPathEncoding = ASN1.encode(this);
        }
        byte[] result = new byte[this.pkiPathEncoding.length];
        System.arraycopy(this.pkiPathEncoding, 0, result, 0, this.pkiPathEncoding.length);
        return result;
    }

    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if (!encodings.contains(encoding)) {
            throw new CertificateEncodingException("Unsupported encoding");
        }
        if (encodingsArr[0].equals(encoding)) {
            return this.getEncoded();
        }
        if (this.pkcs7Encoding == null) {
            this.pkcs7Encoding = PKCS7_SIGNED_DATA_OBJECT.encode(this);
        }
        byte[] result = new byte[this.pkcs7Encoding.length];
        System.arraycopy(this.pkcs7Encoding, 0, result, 0, this.pkcs7Encoding.length);
        return result;
    }

    public Iterator getEncodings() {
        return encodings.iterator();
    }
}

