/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.ProviderException;
import org.apache.harmony.security.provider.crypto.SHA1_Data;

public class RandomBitsSupplier
implements SHA1_Data {
    private static FileInputStream fis = null;
    private static File randomFile = null;
    private static boolean serviceAvailable = false;
    private static final String[] DEVICE_NAMES;

    static boolean isServiceAvailable() {
        return serviceAvailable;
    }

    private static synchronized byte[] getUnixDeviceRandom(int numBytes) {
        byte[] bytes = new byte[numBytes];
        int total = 0;
        int offset = 0;
        try {
            int bytesRead;
            do {
                if ((bytesRead = fis.read(bytes, offset, numBytes - total)) == -1) {
                    throw new ProviderException("bytesRead == -1");
                }
                offset += bytesRead;
            } while ((total += bytesRead) < numBytes);
        }
        catch (IOException e) {
            throw new ProviderException("ATTENTION: IOException in RandomBitsSupplier.getLinuxRandomBits(): " + e);
        }
        return bytes;
    }

    public static byte[] getRandomBits(int numBytes) {
        if (numBytes <= 0) {
            throw new IllegalArgumentException(Integer.toString(numBytes));
        }
        if (!serviceAvailable) {
            throw new ProviderException("ATTENTION: service is not available : no random devices");
        }
        return RandomBitsSupplier.getUnixDeviceRandom(numBytes);
    }

    static {
        for (String deviceName : DEVICE_NAMES = new String[]{"/dev/urandom"}) {
            try {
                File file = new File(deviceName);
                if (!file.canRead()) continue;
                fis = new FileInputStream(file);
                randomFile = file;
                serviceAvailable = true;
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }
}

