/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.utils;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.pkcs7.ContentInfo;
import org.apache.harmony.security.pkcs7.SignedData;
import org.apache.harmony.security.pkcs7.SignerInfo;
import org.apache.harmony.security.provider.cert.X509CertImpl;
import org.apache.harmony.security.x501.AttributeTypeAndValue;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSignature;

public class JarUtils {
    private static final int[] MESSAGE_DIGEST_OID = new int[]{1, 2, 840, 113549, 1, 9, 4};

    public static Certificate[] verifySignature(InputStream signature, InputStream signatureBlock) throws IOException, GeneralSecurityException {
        BerInputStream bis = new BerInputStream(signatureBlock);
        ContentInfo info = (ContentInfo)ContentInfo.ASN1.decode(bis);
        SignedData signedData = info.getSignedData();
        if (signedData == null) {
            throw new IOException("No SignedData found");
        }
        List<org.apache.harmony.security.x509.Certificate> encCerts = signedData.getCertificates();
        if (encCerts.isEmpty()) {
            return null;
        }
        X509Certificate[] certs = new X509Certificate[encCerts.size()];
        int i = 0;
        for (org.apache.harmony.security.x509.Certificate encCert : encCerts) {
            certs[i++] = new X509CertImpl(encCert);
        }
        List<SignerInfo> sigInfos = signedData.getSignerInfos();
        if (sigInfos.isEmpty()) {
            return null;
        }
        SignerInfo sigInfo = sigInfos.get(0);
        X500Principal issuer = sigInfo.getIssuer();
        BigInteger snum = sigInfo.getSerialNumber();
        int issuerSertIndex = 0;
        for (i = 0; i < certs.length; ++i) {
            if (!issuer.equals(certs[i].getIssuerDN()) || !snum.equals(certs[i].getSerialNumber())) continue;
            issuerSertIndex = i;
            break;
        }
        if (i == certs.length) {
            return null;
        }
        if (certs[issuerSertIndex].hasUnsupportedCriticalExtension()) {
            throw new SecurityException("Can not recognize a critical extension");
        }
        Signature sig = null;
        String da = sigInfo.getDigestAlgorithm();
        String dea = sigInfo.getDigestEncryptionAlgorithm();
        String alg = null;
        if (da != null && dea != null) {
            alg = da + "with" + dea;
            try {
                sig = OpenSSLSignature.getInstance(alg);
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
        }
        if (sig == null) {
            alg = da;
            if (alg == null) {
                return null;
            }
            try {
                sig = OpenSSLSignature.getInstance(alg);
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
        sig.initVerify(certs[issuerSertIndex]);
        List<AttributeTypeAndValue> atr = sigInfo.getAuthenticatedAttributes();
        byte[] sfBytes = new byte[signature.available()];
        signature.read(sfBytes);
        if (atr == null) {
            sig.update(sfBytes);
        } else {
            MessageDigest md;
            byte[] computedDigest;
            sig.update(sigInfo.getEncodedAuthenticatedAttributes());
            byte[] existingDigest = null;
            for (AttributeTypeAndValue a : atr) {
                if (!Arrays.equals(a.getType().getOid(), MESSAGE_DIGEST_OID)) continue;
            }
            if (existingDigest != null && !Arrays.equals(existingDigest, computedDigest = (md = MessageDigest.getInstance(sigInfo.getDigestAlgorithm())).digest(sfBytes))) {
                throw new SecurityException("Incorrect MD");
            }
        }
        if (!sig.verify(sigInfo.getEncryptedDigest())) {
            throw new SecurityException("Incorrect signature");
        }
        return JarUtils.createChain(certs[issuerSertIndex], certs);
    }

    private static X509Certificate[] createChain(X509Certificate signer, X509Certificate[] candidates) {
        X509Certificate issuerCert;
        LinkedList<X509Certificate> chain = new LinkedList<X509Certificate>();
        chain.add(0, signer);
        if (((Object)signer.getSubjectDN()).equals(signer.getIssuerDN())) {
            return chain.toArray(new X509Certificate[1]);
        }
        Principal issuer = signer.getIssuerDN();
        int count = 1;
        while ((issuerCert = JarUtils.findCert(issuer, candidates)) != null) {
            chain.add(issuerCert);
            ++count;
            if (((Object)issuerCert.getSubjectDN()).equals(issuerCert.getIssuerDN())) break;
            issuer = issuerCert.getIssuerDN();
        }
        return chain.toArray(new X509Certificate[count]);
    }

    private static X509Certificate findCert(Principal issuer, X509Certificate[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (!((Object)issuer).equals(candidates[i].getSubjectDN())) continue;
            return candidates[i];
        }
        return null;
    }
}

