/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x501;

import java.io.IOException;
import java.nio.charset.Charsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;
import org.apache.harmony.security.x501.AttributeValue;
import org.apache.harmony.security.x501.DirectoryString;

public final class AttributeTypeAndValue {
    private static final HashMap<String, org.apache.harmony.security.utils.ObjectIdentifier> RFC1779_NAMES = new HashMap(10);
    private static final HashMap<String, org.apache.harmony.security.utils.ObjectIdentifier> KNOWN_NAMES = new HashMap(30);
    private static final HashMap<String, org.apache.harmony.security.utils.ObjectIdentifier> RFC2253_NAMES = new HashMap(10);
    private static final HashMap<String, org.apache.harmony.security.utils.ObjectIdentifier> RFC2459_NAMES = new HashMap(10);
    private static final org.apache.harmony.security.utils.ObjectIdentifier C = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 6}, "C", RFC1779_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier CN = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 3}, "CN", RFC1779_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier DC = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{0, 9, 2342, 19200300, 100, 1, 25}, "DC", RFC2253_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier DNQ = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 46}, "DNQ", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier DNQUALIFIER = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 46}, "DNQUALIFIER", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier EMAILADDRESS = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 9, 1}, "EMAILADDRESS", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier GENERATION = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 44}, "GENERATION", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier GIVENNAME = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 42}, "GIVENNAME", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier INITIALS = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 43}, "INITIALS", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier L = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 7}, "L", RFC1779_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier O = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 10}, "O", RFC1779_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier OU = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 11}, "OU", RFC1779_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier SERIALNUMBER = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 5}, "SERIALNUMBER", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier ST = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 8}, "ST", RFC1779_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier STREET = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 9}, "STREET", RFC1779_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier SURNAME = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 4}, "SURNAME", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier T = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 12}, "T", RFC2459_NAMES);
    private static final org.apache.harmony.security.utils.ObjectIdentifier UID = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{0, 9, 2342, 19200300, 100, 1, 1}, "UID", RFC2253_NAMES);
    private static final int CAPACITY = 10;
    private static final int SIZE = 10;
    private static final org.apache.harmony.security.utils.ObjectIdentifier[][] KNOWN_OIDS = new org.apache.harmony.security.utils.ObjectIdentifier[10][10];
    private final org.apache.harmony.security.utils.ObjectIdentifier oid;
    private final AttributeValue value;
    public static final ASN1Type attributeValue;
    public static final ASN1Sequence ASN1;

    private AttributeTypeAndValue(int[] oid, AttributeValue value) throws IOException {
        org.apache.harmony.security.utils.ObjectIdentifier thisOid = AttributeTypeAndValue.getOID(oid);
        if (thisOid == null) {
            thisOid = new org.apache.harmony.security.utils.ObjectIdentifier(oid);
        }
        this.oid = thisOid;
        this.value = value;
    }

    public AttributeTypeAndValue(String sOid, AttributeValue value) throws IOException {
        if (sOid.charAt(0) >= '0' && sOid.charAt(0) <= '9') {
            int[] array = ObjectIdentifier.toIntArray(sOid);
            org.apache.harmony.security.utils.ObjectIdentifier thisOid = AttributeTypeAndValue.getOID(array);
            if (thisOid == null) {
                thisOid = new org.apache.harmony.security.utils.ObjectIdentifier(array);
            }
            this.oid = thisOid;
        } else {
            this.oid = KNOWN_NAMES.get(sOid.toUpperCase(Locale.US));
            if (this.oid == null) {
                throw new IOException("Unrecognizable attribute name: " + sOid);
            }
        }
        this.value = value;
    }

    public void appendName(String attrFormat, StringBuilder sb) {
        boolean hexFormat = false;
        if ("RFC1779".equals(attrFormat)) {
            if (RFC1779_NAMES == this.oid.getGroup()) {
                sb.append(this.oid.getName());
            } else {
                sb.append(this.oid.toOIDString());
            }
            sb.append('=');
            if (this.value.escapedString == this.value.getHexString()) {
                sb.append(this.value.getHexString().toUpperCase(Locale.US));
            } else if (this.value.escapedString.length() != this.value.rawString.length()) {
                this.value.appendQEString(sb);
            } else {
                sb.append(this.value.escapedString);
            }
        } else {
            Object group = this.oid.getGroup();
            if (RFC1779_NAMES == group || RFC2253_NAMES == group) {
                int tag;
                sb.append(this.oid.getName());
                if ("CANONICAL".equals(attrFormat) && !ASN1StringType.UTF8STRING.checkTag(tag = this.value.getTag()) && !ASN1StringType.PRINTABLESTRING.checkTag(tag) && !ASN1StringType.TELETEXSTRING.checkTag(tag)) {
                    hexFormat = true;
                }
            } else {
                sb.append(this.oid.toString());
                hexFormat = true;
            }
            sb.append('=');
            if (hexFormat) {
                sb.append(this.value.getHexString());
            } else if ("CANONICAL".equals(attrFormat)) {
                sb.append(this.value.makeCanonical());
            } else {
                sb.append(this.value.escapedString);
            }
        }
    }

    public org.apache.harmony.security.utils.ObjectIdentifier getType() {
        return this.oid;
    }

    private static org.apache.harmony.security.utils.ObjectIdentifier getOID(int[] oid) {
        int index = AttributeTypeAndValue.hashIntArray(oid) % 10;
        org.apache.harmony.security.utils.ObjectIdentifier[] list = KNOWN_OIDS[index];
        int i = 0;
        while (list[i] != null) {
            if (Arrays.equals(oid, list[i].getOid())) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    private static void addOID(org.apache.harmony.security.utils.ObjectIdentifier oid) {
        int[] newOid = oid.getOid();
        int index = AttributeTypeAndValue.hashIntArray(newOid) % 10;
        org.apache.harmony.security.utils.ObjectIdentifier[] list = KNOWN_OIDS[index];
        int i = 0;
        while (list[i] != null) {
            if (Arrays.equals(newOid, list[i].getOid())) {
                throw new Error("ObjectIdentifier: invalid static initialization; duplicate OIDs: " + oid.getName() + " " + list[i].getName());
            }
            ++i;
        }
        if (i == 9) {
            throw new Error("ObjectIdentifier: invalid static initialization; small OID pool capacity");
        }
        list[i] = oid;
    }

    private static int hashIntArray(int[] oid) {
        int intHash = 0;
        for (int i = 0; i < oid.length && i < 4; ++i) {
            intHash += oid[i] << 8 * i;
        }
        return intHash & Integer.MAX_VALUE;
    }

    static {
        RFC1779_NAMES.put(CN.getName(), CN);
        RFC1779_NAMES.put(L.getName(), L);
        RFC1779_NAMES.put(ST.getName(), ST);
        RFC1779_NAMES.put(O.getName(), O);
        RFC1779_NAMES.put(OU.getName(), OU);
        RFC1779_NAMES.put(C.getName(), C);
        RFC1779_NAMES.put(STREET.getName(), STREET);
        RFC2253_NAMES.putAll(RFC1779_NAMES);
        RFC2253_NAMES.put(DC.getName(), DC);
        RFC2253_NAMES.put(UID.getName(), UID);
        RFC2459_NAMES.put(DNQ.getName(), DNQ);
        RFC2459_NAMES.put(DNQUALIFIER.getName(), DNQUALIFIER);
        RFC2459_NAMES.put(EMAILADDRESS.getName(), EMAILADDRESS);
        RFC2459_NAMES.put(GENERATION.getName(), GENERATION);
        RFC2459_NAMES.put(GIVENNAME.getName(), GIVENNAME);
        RFC2459_NAMES.put(INITIALS.getName(), INITIALS);
        RFC2459_NAMES.put(SERIALNUMBER.getName(), SERIALNUMBER);
        RFC2459_NAMES.put(SURNAME.getName(), SURNAME);
        RFC2459_NAMES.put(T.getName(), T);
        for (org.apache.harmony.security.utils.ObjectIdentifier objectIdentifier : RFC2253_NAMES.values()) {
            AttributeTypeAndValue.addOID(objectIdentifier);
        }
        for (org.apache.harmony.security.utils.ObjectIdentifier o : RFC2459_NAMES.values()) {
            if (o == DNQUALIFIER) continue;
            AttributeTypeAndValue.addOID(o);
        }
        KNOWN_NAMES.putAll(RFC2253_NAMES);
        KNOWN_NAMES.putAll(RFC2459_NAMES);
        attributeValue = new ASN1Type(19){

            public boolean checkTag(int tag) {
                return true;
            }

            public Object decode(BerInputStream in) throws IOException {
                String str = null;
                if (DirectoryString.ASN1.checkTag(in.tag)) {
                    str = (String)DirectoryString.ASN1.decode(in);
                } else {
                    in.readContent();
                }
                byte[] bytesEncoded = new byte[in.getOffset() - in.getTagOffset()];
                System.arraycopy(in.getBuffer(), in.getTagOffset(), bytesEncoded, 0, bytesEncoded.length);
                return new AttributeValue(str, bytesEncoded, in.tag);
            }

            public Object getDecodedObject(BerInputStream in) throws IOException {
                throw new RuntimeException("AttributeValue getDecodedObject MUST NOT be invoked");
            }

            public void encodeASN(BerOutputStream out) {
                AttributeValue av = (AttributeValue)out.content;
                if (av.encoded != null) {
                    out.content = av.encoded;
                    out.encodeANY();
                } else {
                    out.encodeTag(av.getTag());
                    out.content = av.bytes;
                    out.encodeString();
                }
            }

            public void setEncodingContent(BerOutputStream out) {
                AttributeValue av = (AttributeValue)out.content;
                if (av.encoded != null) {
                    out.length = av.encoded.length;
                } else if (av.getTag() == 12) {
                    out.content = av.rawString;
                    ASN1StringType.UTF8STRING.setEncodingContent(out);
                    av.bytes = (byte[])out.content;
                    out.content = av;
                } else {
                    av.bytes = av.rawString.getBytes(Charsets.UTF_8);
                    out.length = av.bytes.length;
                }
            }

            public void encodeContent(BerOutputStream out) {
                throw new RuntimeException("AttributeValue encodeContent MUST NOT be invoked");
            }

            public int getEncodedLength(BerOutputStream out) {
                AttributeValue av = (AttributeValue)out.content;
                if (av.encoded != null) {
                    return out.length;
                }
                return super.getEncodedLength(out);
            }
        };
        ASN1 = new ASN1Sequence(new ASN1Type[]{ASN1Oid.getInstance(), attributeValue}){

            protected Object getDecodedObject(BerInputStream in) throws IOException {
                Object[] values = (Object[])in.content;
                return new AttributeTypeAndValue((int[])values[0], (AttributeValue)values[1]);
            }

            protected void getValues(Object object, Object[] values) {
                AttributeTypeAndValue atav = (AttributeTypeAndValue)object;
                values[0] = atav.oid.getOid();
                values[1] = atav.value;
            }
        };
    }
}

