/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.BasicConstraints;
import org.apache.harmony.security.x509.CertificateIssuer;
import org.apache.harmony.security.x509.ExtendedKeyUsage;
import org.apache.harmony.security.x509.Extension;
import org.apache.harmony.security.x509.GeneralNames;
import org.apache.harmony.security.x509.KeyUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Extensions {
    private static List SUPPORTED_CRITICAL = Arrays.asList("2.5.29.15", "2.5.29.19", "2.5.29.32", "2.5.29.17", "2.5.29.30", "2.5.29.36", "2.5.29.37", "2.5.29.54");
    private List<Extension> extensions;
    private Set<String> critical;
    private Set<String> noncritical;
    private boolean hasUnsupported;
    private HashMap<String, Extension> oidMap;
    private byte[] encoding;
    public static final ASN1Type ASN1 = new ASN1SequenceOf(Extension.ASN1){

        public Object getDecodedObject(BerInputStream in) {
            return new Extensions((List)in.content);
        }

        public Collection getValues(Object object) {
            Extensions extensions = (Extensions)object;
            return extensions.extensions == null ? new ArrayList() : extensions.extensions;
        }
    };

    public Extensions() {
    }

    public Extensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public int size() {
        return this.extensions == null ? 0 : this.extensions.size();
    }

    public Set<String> getCriticalExtensions() {
        if (this.critical == null) {
            this.makeOidsLists();
        }
        return this.critical;
    }

    public Set<String> getNonCriticalExtensions() {
        if (this.noncritical == null) {
            this.makeOidsLists();
        }
        return this.noncritical;
    }

    public boolean hasUnsupportedCritical() {
        if (this.critical == null) {
            this.makeOidsLists();
        }
        return this.hasUnsupported;
    }

    private void makeOidsLists() {
        if (this.extensions == null) {
            return;
        }
        int size = this.extensions.size();
        this.critical = new HashSet<String>(size);
        this.noncritical = new HashSet<String>(size);
        for (Extension extension : this.extensions) {
            String oid = extension.getExtnID();
            if (extension.getCritical()) {
                if (!SUPPORTED_CRITICAL.contains(oid)) {
                    this.hasUnsupported = true;
                }
                this.critical.add(oid);
                continue;
            }
            this.noncritical.add(oid);
        }
    }

    public Extension getExtensionByOID(String oid) {
        if (this.extensions == null) {
            return null;
        }
        if (this.oidMap == null) {
            this.oidMap = new HashMap();
            for (Extension extension : this.extensions) {
                this.oidMap.put(extension.getExtnID(), extension);
            }
        }
        return this.oidMap.get(oid);
    }

    public boolean[] valueOfKeyUsage() {
        KeyUsage kUsage;
        Extension extension = this.getExtensionByOID("2.5.29.15");
        if (extension == null || (kUsage = extension.getKeyUsageValue()) == null) {
            return null;
        }
        return kUsage.getKeyUsage();
    }

    public List<String> valueOfExtendedKeyUsage() throws IOException {
        Extension extension = this.getExtensionByOID("2.5.29.37");
        if (extension == null) {
            return null;
        }
        return ((ExtendedKeyUsage)extension.getDecodedExtensionValue()).getExtendedKeyUsage();
    }

    public int valueOfBasicConstrains() {
        BasicConstraints bc;
        Extension extension = this.getExtensionByOID("2.5.29.19");
        if (extension == null || (bc = extension.getBasicConstraintsValue()) == null) {
            return Integer.MAX_VALUE;
        }
        return bc.getPathLenConstraint();
    }

    public Collection<List<?>> valueOfSubjectAlternativeName() throws IOException {
        Extension extension = this.getExtensionByOID("2.5.29.17");
        if (extension == null) {
            return null;
        }
        return ((GeneralNames)GeneralNames.ASN1.decode(extension.getExtnValue())).getPairsList();
    }

    public Collection<List<?>> valueOfIssuerAlternativeName() throws IOException {
        Extension extension = this.getExtensionByOID("2.5.29.18");
        if (extension == null) {
            return null;
        }
        return ((GeneralNames)GeneralNames.ASN1.decode(extension.getExtnValue())).getPairsList();
    }

    public X500Principal valueOfCertificateIssuerExtension() throws IOException {
        Extension extension = this.getExtensionByOID("2.5.29.29");
        if (extension == null) {
            return null;
        }
        return ((CertificateIssuer)extension.getDecodedExtensionValue()).getIssuer();
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Extensions)) {
            return false;
        }
        Extensions that = (Extensions)other;
        return this.extensions == null || this.extensions.isEmpty() ? that.extensions == null || that.extensions.isEmpty() : ((Object)this.extensions).equals(that.extensions);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.extensions != null) {
            hashCode = ((Object)this.extensions).hashCode();
        }
        return hashCode;
    }

    public void dumpValue(StringBuilder sb, String prefix) {
        if (this.extensions == null) {
            return;
        }
        int num = 1;
        for (Extension extension : this.extensions) {
            sb.append('\n').append(prefix).append('[').append(num++).append("]: ");
            extension.dumpValue(sb, prefix);
        }
    }
}

