/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import org.xml.sax.Attributes;

abstract class ExpatAttributes
implements Attributes {
    private static final String CDATA = "CDATA";

    ExpatAttributes() {
    }

    public abstract int getLength();

    abstract int getParserPointer();

    public abstract int getPointer();

    public String getURI(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return ExpatAttributes.getURI(this.getParserPointer(), this.getPointer(), index);
    }

    public String getLocalName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getLocalName(this.getParserPointer(), this.getPointer(), index);
    }

    public String getQName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getQName(this.getParserPointer(), this.getPointer(), index);
    }

    public String getType(int index) {
        return index < 0 || index >= this.getLength() ? null : CDATA;
    }

    public String getValue(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getValueByIndex(this.getPointer(), index);
    }

    public int getIndex(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (localName == null) {
            throw new NullPointerException("local name");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return -1;
        }
        return ExpatAttributes.getIndex(pointer, uri, localName);
    }

    public int getIndex(String qName) {
        if (qName == null) {
            throw new NullPointerException("uri");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return -1;
        }
        return ExpatAttributes.getIndexForQName(pointer, qName);
    }

    public String getType(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (localName == null) {
            throw new NullPointerException("local name");
        }
        return this.getIndex(uri, localName) == -1 ? null : CDATA;
    }

    public String getType(String qName) {
        return this.getIndex(qName) == -1 ? null : CDATA;
    }

    public String getValue(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (localName == null) {
            throw new NullPointerException("local name");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return null;
        }
        return ExpatAttributes.getValue(pointer, uri, localName);
    }

    public String getValue(String qName) {
        if (qName == null) {
            throw new NullPointerException("qName");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return null;
        }
        return ExpatAttributes.getValueForQName(pointer, qName);
    }

    private static native String getURI(int var0, int var1, int var2);

    private static native String getLocalName(int var0, int var1, int var2);

    private static native String getQName(int var0, int var1, int var2);

    private static native String getValueByIndex(int var0, int var1);

    private static native int getIndex(int var0, String var1, String var2);

    private static native int getIndexForQName(int var0, String var1);

    private static native String getValue(int var0, String var1, String var2);

    private static native String getValueForQName(int var0, String var1);

    protected native void freeAttributes(int var1);
}

