/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import org.apache.harmony.xml.dom.DocumentImpl;
import org.apache.harmony.xml.dom.TextImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;

public final class CDATASectionImpl
extends TextImpl
implements CDATASection {
    public CDATASectionImpl(DocumentImpl document, String data) {
        super(document, data);
    }

    public String getNodeName() {
        return "#cdata-section";
    }

    public short getNodeType() {
        return 4;
    }

    public void split() {
        if (!this.needsSplitting()) {
            return;
        }
        Node parent = this.getParentNode();
        String[] parts = this.getData().split("\\]\\]>");
        parent.insertBefore(new CDATASectionImpl(this.document, parts[0] + "]]"), this);
        for (int p = 1; p < parts.length - 1; ++p) {
            parent.insertBefore(new CDATASectionImpl(this.document, ">" + parts[p] + "]]"), this);
        }
        this.setData(">" + parts[parts.length - 1]);
    }

    public boolean needsSplitting() {
        return this.buffer.indexOf("]]>") != -1;
    }

    public TextImpl replaceWithText() {
        TextImpl replacement = new TextImpl(this.document, this.getData());
        this.parent.insertBefore(replacement, this);
        this.parent.removeChild(this);
        return replacement;
    }
}

