/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import java.util.ArrayList;
import java.util.List;
import libcore.util.Objects;
import org.apache.harmony.xml.dom.AttrImpl;
import org.apache.harmony.xml.dom.DocumentImpl;
import org.apache.harmony.xml.dom.InnerNodeImpl;
import org.apache.harmony.xml.dom.LeafNodeImpl;
import org.apache.harmony.xml.dom.NodeListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends InnerNodeImpl
implements Element {
    boolean namespaceAware;
    String namespaceURI;
    String prefix;
    String localName;
    private List<AttrImpl> attributes = new ArrayList<AttrImpl>();

    ElementImpl(DocumentImpl document, String namespaceURI, String qualifiedName) {
        super(document);
        ElementImpl.setNameNS(this, namespaceURI, qualifiedName);
    }

    ElementImpl(DocumentImpl document, String name) {
        super(document);
        ElementImpl.setName(this, name);
    }

    private int indexOfAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttrImpl attr = this.attributes.get(i);
            if (!Objects.equal(name, attr.getNodeName())) continue;
            return i;
        }
        return -1;
    }

    private int indexOfAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttrImpl attr = this.attributes.get(i);
            if (!Objects.equal(namespaceURI, attr.getNamespaceURI()) || !Objects.equal(localName, attr.getLocalName())) continue;
            return i;
        }
        return -1;
    }

    public String getAttribute(String name) {
        AttrImpl attr = this.getAttributeNode(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        AttrImpl attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public AttrImpl getAttributeNode(String name) {
        int i = this.indexOfAttribute(name);
        if (i == -1) {
            return null;
        }
        return this.attributes.get(i);
    }

    public AttrImpl getAttributeNodeNS(String namespaceURI, String localName) {
        int i = this.indexOfAttributeNS(namespaceURI, localName);
        if (i == -1) {
            return null;
        }
        return this.attributes.get(i);
    }

    public NamedNodeMap getAttributes() {
        return new ElementAttrNamedNodeMapImpl();
    }

    Element getElementById(String name) {
        for (AttrImpl attr : this.attributes) {
            if (!attr.isId() || !name.equals(attr.getValue())) continue;
            return this;
        }
        if (name.equals(this.getAttribute("id"))) {
            return this;
        }
        for (LeafNodeImpl node : this.children) {
            Element element;
            if (node.getNodeType() != 1 || (element = ((ElementImpl)node).getElementById(name)) == null) continue;
            return element;
        }
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        NodeListImpl result = new NodeListImpl();
        this.getElementsByTagName(result, name);
        return result;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        NodeListImpl result = new NodeListImpl();
        this.getElementsByTagNameNS(result, namespaceURI, localName);
        return result;
    }

    public String getLocalName() {
        return this.namespaceAware ? this.localName : null;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public short getNodeType() {
        return 1;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTagName() {
        return this.prefix != null ? this.prefix + ":" + this.localName : this.localName;
    }

    public boolean hasAttribute(String name) {
        return this.indexOfAttribute(name) != -1;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.indexOfAttributeNS(namespaceURI, localName) != -1;
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public void removeAttribute(String name) throws DOMException {
        int i = this.indexOfAttribute(name);
        if (i != -1) {
            this.attributes.remove(i);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        int i = this.indexOfAttributeNS(namespaceURI, localName);
        if (i != -1) {
            this.attributes.remove(i);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        AttrImpl oldAttrImpl = (AttrImpl)oldAttr;
        if (oldAttrImpl.getOwnerElement() != this) {
            throw new DOMException(8, null);
        }
        this.attributes.remove(oldAttrImpl);
        oldAttrImpl.ownerElement = null;
        return oldAttrImpl;
    }

    public void setAttribute(String name, String value) throws DOMException {
        AttrImpl attr = this.getAttributeNode(name);
        if (attr == null) {
            attr = this.document.createAttribute(name);
            this.setAttributeNode(attr);
        }
        attr.setValue(value);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttrImpl attr = this.getAttributeNodeNS(namespaceURI, qualifiedName);
        if (attr == null) {
            attr = this.document.createAttributeNS(namespaceURI, qualifiedName);
            this.setAttributeNodeNS(attr);
        }
        attr.setValue(value);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        AttrImpl newAttrImpl = (AttrImpl)newAttr;
        if (newAttrImpl.document != this.document) {
            throw new DOMException(4, null);
        }
        if (newAttrImpl.getOwnerElement() != null) {
            throw new DOMException(10, null);
        }
        AttrImpl oldAttrImpl = null;
        int i = this.indexOfAttribute(newAttr.getName());
        if (i != -1) {
            oldAttrImpl = this.attributes.get(i);
            this.attributes.remove(i);
        }
        this.attributes.add(newAttrImpl);
        newAttrImpl.ownerElement = this;
        return oldAttrImpl;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        AttrImpl newAttrImpl = (AttrImpl)newAttr;
        if (newAttrImpl.document != this.document) {
            throw new DOMException(4, null);
        }
        if (newAttrImpl.getOwnerElement() != null) {
            throw new DOMException(10, null);
        }
        AttrImpl oldAttrImpl = null;
        int i = this.indexOfAttributeNS(newAttr.getNamespaceURI(), newAttr.getLocalName());
        if (i != -1) {
            oldAttrImpl = this.attributes.get(i);
            this.attributes.remove(i);
        }
        this.attributes.add(newAttrImpl);
        newAttrImpl.ownerElement = this;
        return oldAttrImpl;
    }

    public void setPrefix(String prefix) {
        this.prefix = ElementImpl.validatePrefix(prefix, this.namespaceAware, this.namespaceURI);
    }

    public TypeInfo getSchemaTypeInfo() {
        return NULL_TYPE_INFO;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        AttrImpl attr = this.getAttributeNode(name);
        if (attr == null) {
            throw new DOMException(8, "No such attribute: " + name);
        }
        attr.isId = isId;
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        AttrImpl attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr == null) {
            throw new DOMException(8, "No such attribute: " + namespaceURI + " " + localName);
        }
        attr.isId = isId;
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        ((AttrImpl)idAttr).isId = isId;
    }

    public class ElementAttrNamedNodeMapImpl
    implements NamedNodeMap {
        public int getLength() {
            return ElementImpl.this.attributes.size();
        }

        private int indexOfItem(String name) {
            return ElementImpl.this.indexOfAttribute(name);
        }

        private int indexOfItemNS(String namespaceURI, String localName) {
            return ElementImpl.this.indexOfAttributeNS(namespaceURI, localName);
        }

        public Node getNamedItem(String name) {
            return ElementImpl.this.getAttributeNode(name);
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            return ElementImpl.this.getAttributeNodeNS(namespaceURI, localName);
        }

        public Node item(int index) {
            return (Node)ElementImpl.this.attributes.get(index);
        }

        public Node removeNamedItem(String name) throws DOMException {
            int i = this.indexOfItem(name);
            if (i == -1) {
                throw new DOMException(8, null);
            }
            return (Node)ElementImpl.this.attributes.remove(i);
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            int i = this.indexOfItemNS(namespaceURI, localName);
            if (i == -1) {
                throw new DOMException(8, null);
            }
            return (Node)ElementImpl.this.attributes.remove(i);
        }

        public Node setNamedItem(Node arg) throws DOMException {
            if (!(arg instanceof Attr)) {
                throw new DOMException(3, null);
            }
            return ElementImpl.this.setAttributeNode((Attr)arg);
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            if (!(arg instanceof Attr)) {
                throw new DOMException(3, null);
            }
            return ElementImpl.this.setAttributeNodeNS((Attr)arg);
        }
    }
}

