/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Vector;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.harmony.xnet.provider.jsse.AlertException;
import org.apache.harmony.xnet.provider.jsse.CertificateMessage;
import org.apache.harmony.xnet.provider.jsse.CertificateRequest;
import org.apache.harmony.xnet.provider.jsse.CertificateVerify;
import org.apache.harmony.xnet.provider.jsse.ClientHello;
import org.apache.harmony.xnet.provider.jsse.ClientKeyExchange;
import org.apache.harmony.xnet.provider.jsse.DelegatedTask;
import org.apache.harmony.xnet.provider.jsse.Finished;
import org.apache.harmony.xnet.provider.jsse.HandshakeIODataStream;
import org.apache.harmony.xnet.provider.jsse.Message;
import org.apache.harmony.xnet.provider.jsse.PRF;
import org.apache.harmony.xnet.provider.jsse.SSLEngineImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;
import org.apache.harmony.xnet.provider.jsse.SSLRecordProtocol;
import org.apache.harmony.xnet.provider.jsse.SSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.SSLSocketImpl;
import org.apache.harmony.xnet.provider.jsse.SSLv3Constants;
import org.apache.harmony.xnet.provider.jsse.ServerHello;
import org.apache.harmony.xnet.provider.jsse.ServerHelloDone;
import org.apache.harmony.xnet.provider.jsse.ServerKeyExchange;

public abstract class HandshakeProtocol {
    public static final int NEED_UNWRAP = 1;
    public static final int NOT_HANDSHAKING = 2;
    public static final int FINISHED = 3;
    public static final int NEED_TASK = 4;
    protected int status = 2;
    protected HandshakeIODataStream io_stream = new HandshakeIODataStream();
    protected SSLRecordProtocol recordProtocol;
    protected SSLParametersImpl parameters;
    protected Vector<DelegatedTask> delegatedTasks = new Vector();
    protected boolean nonBlocking;
    protected SSLSessionImpl session;
    protected ClientHello clientHello;
    protected ServerHello serverHello;
    protected CertificateMessage serverCert;
    protected ServerKeyExchange serverKeyExchange;
    protected CertificateRequest certificateRequest;
    protected ServerHelloDone serverHelloDone;
    protected CertificateMessage clientCert;
    protected ClientKeyExchange clientKeyExchange;
    protected CertificateVerify certificateVerify;
    protected Finished clientFinished;
    protected Finished serverFinished;
    protected boolean changeCipherSpecReceived = false;
    protected boolean isResuming = false;
    protected byte[] preMasterSecret;
    protected Exception delegatedTaskErr;
    private byte[] verify_data = new byte[12];
    private byte[] master_secret_bytes = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    private boolean needSendCCSpec = false;
    protected boolean needSendHelloRequest = false;
    public SSLEngineImpl engineOwner;
    public SSLSocketImpl socketOwner;

    protected HandshakeProtocol(Object owner) {
        if (owner instanceof SSLEngineImpl) {
            this.engineOwner = (SSLEngineImpl)owner;
            this.nonBlocking = true;
            this.parameters = this.engineOwner.sslParameters;
        } else if (owner instanceof SSLSocketImpl) {
            this.socketOwner = (SSLSocketImpl)owner;
            this.nonBlocking = false;
            this.parameters = this.socketOwner.sslParameters;
        }
    }

    public void setRecordProtocol(SSLRecordProtocol recordProtocol) {
        this.recordProtocol = recordProtocol;
    }

    public abstract void start();

    protected void stop() {
        this.clearMessages();
        this.status = 2;
    }

    public SSLEngineResult.HandshakeStatus getStatus() {
        if (this.io_stream.hasData() || this.needSendCCSpec || this.needSendHelloRequest || this.delegatedTaskErr != null) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (!this.delegatedTasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        switch (this.status) {
            case 1: {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            case 3: {
                this.status = 2;
                this.clearMessages();
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public SSLSessionImpl getSession() {
        return this.session;
    }

    protected void sendChangeCipherSpec() {
        this.needSendCCSpec = true;
    }

    protected void sendHelloRequest() {
        this.needSendHelloRequest = true;
    }

    abstract void receiveChangeCipherSpec();

    abstract void makeFinished();

    public abstract void unwrap(byte[] var1);

    public abstract void unwrapSSLv2(byte[] var1);

    public byte[] wrap() {
        if (this.delegatedTaskErr != null) {
            Exception e = this.delegatedTaskErr;
            this.delegatedTaskErr = null;
            this.fatalAlert((byte)40, "Error occured in delegated task:" + e.getMessage(), e);
        }
        if (this.io_stream.hasData()) {
            return this.recordProtocol.wrap((byte)22, this.io_stream);
        }
        if (this.needSendCCSpec) {
            this.makeFinished();
            this.needSendCCSpec = false;
            return this.recordProtocol.getChangeCipherSpecMesage(this.getSession());
        }
        if (this.needSendHelloRequest) {
            this.needSendHelloRequest = false;
            return this.recordProtocol.wrap((byte)22, new byte[]{0, 0, 0, 0}, 0, 4);
        }
        return null;
    }

    protected void sendWarningAlert(byte description) {
        this.recordProtocol.alert((byte)1, description);
    }

    protected void fatalAlert(byte description, String reason) {
        throw new AlertException(description, new SSLHandshakeException(reason));
    }

    protected void fatalAlert(byte description, String reason, Exception cause) {
        throw new AlertException(description, new SSLException(reason, cause));
    }

    protected void fatalAlert(byte description, SSLException cause) {
        throw new AlertException(description, cause);
    }

    protected void computerReferenceVerifyDataTLS(String label) {
        this.computerVerifyDataTLS(label, this.verify_data);
    }

    protected void computerVerifyDataTLS(String label, byte[] buf) {
        byte[] md5_digest = this.io_stream.getDigestMD5();
        byte[] sha_digest = this.io_stream.getDigestSHA();
        byte[] digest = new byte[md5_digest.length + sha_digest.length];
        System.arraycopy(md5_digest, 0, digest, 0, md5_digest.length);
        System.arraycopy(sha_digest, 0, digest, md5_digest.length, sha_digest.length);
        try {
            PRF.computePRF(buf, this.session.master_secret, label.getBytes(), digest);
        }
        catch (GeneralSecurityException e) {
            this.fatalAlert((byte)80, "PRF error", e);
        }
    }

    protected void computerReferenceVerifyDataSSLv3(byte[] sender) {
        this.verify_data = new byte[36];
        this.computerVerifyDataSSLv3(sender, this.verify_data);
    }

    protected void computerVerifyDataSSLv3(byte[] sender, byte[] buf) {
        MessageDigest sha;
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            this.fatalAlert((byte)80, "Could not initialize the Digest Algorithms.", e);
            return;
        }
        try {
            byte[] handshake_messages = this.io_stream.getMessages();
            md5.update(handshake_messages);
            md5.update(sender);
            md5.update(this.session.master_secret);
            byte[] b = md5.digest(SSLv3Constants.MD5pad1);
            md5.update(this.session.master_secret);
            md5.update(SSLv3Constants.MD5pad2);
            System.arraycopy(md5.digest(b), 0, buf, 0, 16);
            sha.update(handshake_messages);
            sha.update(sender);
            sha.update(this.session.master_secret);
            b = sha.digest(SSLv3Constants.SHApad1);
            sha.update(this.session.master_secret);
            sha.update(SSLv3Constants.SHApad2);
            System.arraycopy(sha.digest(b), 0, buf, 16, 20);
        }
        catch (Exception e) {
            this.fatalAlert((byte)80, "INTERNAL ERROR", e);
        }
    }

    protected void verifyFinished(byte[] data) {
        if (!Arrays.equals(this.verify_data, data)) {
            this.fatalAlert((byte)40, "Incorrect FINISED");
        }
    }

    protected void unexpectedMessage() {
        this.fatalAlert((byte)10, "UNEXPECTED MESSAGE");
    }

    public void send(Message message) {
        this.io_stream.writeUint8(message.getType());
        this.io_stream.writeUint24(message.length());
        message.send(this.io_stream);
    }

    public void computerMasterSecret() {
        byte[] seed = new byte[64];
        System.arraycopy(this.clientHello.getRandom(), 0, seed, 0, 32);
        System.arraycopy(this.serverHello.getRandom(), 0, seed, 32, 32);
        this.session.master_secret = new byte[48];
        if (this.serverHello.server_version[1] == 1) {
            try {
                PRF.computePRF(this.session.master_secret, this.preMasterSecret, this.master_secret_bytes, seed);
            }
            catch (GeneralSecurityException e) {
                this.fatalAlert((byte)80, "PRF error", e);
            }
        } else {
            PRF.computePRF_SSLv3(this.session.master_secret, this.preMasterSecret, seed);
        }
        Arrays.fill(this.preMasterSecret, (byte)0);
        this.preMasterSecret = null;
    }

    public Runnable getTask() {
        if (this.delegatedTasks.isEmpty()) {
            return null;
        }
        return this.delegatedTasks.remove(0);
    }

    protected void clearMessages() {
        this.io_stream.clearBuffer();
        this.clientHello = null;
        this.serverHello = null;
        this.serverCert = null;
        this.serverKeyExchange = null;
        this.certificateRequest = null;
        this.serverHelloDone = null;
        this.clientCert = null;
        this.clientKeyExchange = null;
        this.certificateVerify = null;
        this.clientFinished = null;
        this.serverFinished = null;
    }

    protected static int getRSAKeyLength(PublicKey pk) throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger mod;
        if (pk instanceof RSAKey) {
            mod = ((RSAKey)((Object)pk)).getModulus();
        } else {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            mod = kf.getKeySpec(pk, RSAPublicKeySpec.class).getModulus();
        }
        return mod.bitLength();
    }

    protected void shutdown() {
        this.clearMessages();
        this.session = null;
        this.preMasterSecret = null;
        this.delegatedTasks.clear();
    }
}

