/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.security.auth.x500.X500Principal;
import libcore.io.Memory;

public final class NativeCrypto {
    public static final int RAND_SEED_LENGTH_IN_BYTES = 1024;
    private static final String SUPPORTED_PROTOCOL_SSLV3 = "SSLv3";
    private static final String SUPPORTED_PROTOCOL_TLSV1 = "TLSv1";
    public static final Map<String, String> OPENSSL_TO_STANDARD_CIPHER_SUITES;
    public static final Map<String, String> STANDARD_TO_OPENSSL_CIPHER_SUITES;
    public static final String TLS_EMPTY_RENEGOTIATION_INFO_SCSV = "TLS_EMPTY_RENEGOTIATION_INFO_SCSV";
    private static final String[] SUPPORTED_CIPHER_SUITES;
    public static final long SSL_MODE_HANDSHAKE_CUTTHROUGH = 64L;
    public static final long SSL_OP_NO_TICKET = 16384L;
    public static final long SSL_OP_NO_COMPRESSION = 131072L;
    public static final long SSL_OP_NO_SSLv3 = 0x2000000L;
    public static final long SSL_OP_NO_TLSv1 = 0x4000000L;
    private static final String SUPPORTED_COMPRESSION_METHOD_ZLIB = "ZLIB";
    private static final String SUPPORTED_COMPRESSION_METHOD_NULL = "NULL";
    private static final String[] SUPPORTED_COMPRESSION_METHODS;
    public static final int SSL_VERIFY_NONE = 0;
    public static final int SSL_VERIFY_PEER = 1;
    public static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = 2;

    private static native void clinit();

    public static native int EVP_PKEY_new_DSA(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public static native int EVP_PKEY_new_RSA(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public static native void EVP_PKEY_free(int var0);

    public static native int EVP_get_digestbyname(String var0);

    public static native int EVP_MD_size(int var0);

    public static native int EVP_MD_block_size(int var0);

    public static native void EVP_MD_CTX_destroy(int var0);

    public static native int EVP_MD_CTX_copy(int var0);

    public static native int EVP_DigestInit(int var0);

    public static native void EVP_DigestUpdate(int var0, byte[] var1, int var2, int var3);

    public static native int EVP_DigestFinal(int var0, byte[] var1, int var2);

    public static native int EVP_VerifyInit(String var0);

    public static native void EVP_VerifyUpdate(int var0, byte[] var1, int var2, int var3);

    public static native int EVP_VerifyFinal(int var0, byte[] var1, int var2, int var3, int var4);

    public static native void RAND_seed(byte[] var0);

    public static native int RAND_load_file(String var0, long var1);

    public static int X509_NAME_hash(X500Principal principal) {
        return NativeCrypto.X509_NAME_hash(principal, "SHA1");
    }

    public static int X509_NAME_hash_old(X500Principal principal) {
        return NativeCrypto.X509_NAME_hash(principal, "MD5");
    }

    private static int X509_NAME_hash(X500Principal principal, String algorithm) {
        try {
            byte[] digest = MessageDigest.getInstance(algorithm).digest(principal.getEncoded());
            return Memory.peekInt(digest, 0, ByteOrder.LITTLE_ENDIAN);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void add(String standard, String openssl) {
        OPENSSL_TO_STANDARD_CIPHER_SUITES.put(openssl, standard);
        STANDARD_TO_OPENSSL_CIPHER_SUITES.put(standard, openssl);
    }

    public static native int SSL_CTX_new();

    public static String[] getDefaultCipherSuites() {
        return new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", TLS_EMPTY_RENEGOTIATION_INFO_SCSV};
    }

    public static String[] getSupportedCipherSuites() {
        return (String[])SUPPORTED_CIPHER_SUITES.clone();
    }

    public static native void SSL_CTX_free(int var0);

    public static native int SSL_new(int var0) throws SSLException;

    public static byte[][] encodeCertificates(Certificate[] certificates) throws CertificateEncodingException {
        byte[][] certificateBytes = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            certificateBytes[i] = certificates[i].getEncoded();
        }
        return certificateBytes;
    }

    public static native void SSL_use_certificate(int var0, byte[][] var1);

    public static native void SSL_use_PrivateKey(int var0, byte[] var1);

    public static native void SSL_check_private_key(int var0) throws SSLException;

    public static byte[][] encodeIssuerX509Principals(X509Certificate[] certificates) throws CertificateEncodingException {
        byte[][] principalBytes = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            principalBytes[i] = certificates[i].getIssuerX500Principal().getEncoded();
        }
        return principalBytes;
    }

    public static native void SSL_set_client_CA_list(int var0, byte[][] var1);

    public static native long SSL_get_mode(int var0);

    public static native long SSL_set_mode(int var0, long var1);

    public static native long SSL_clear_mode(int var0, long var1);

    public static native long SSL_get_options(int var0);

    public static native long SSL_set_options(int var0, long var1);

    public static native long SSL_clear_options(int var0, long var1);

    public static String[] getSupportedProtocols() {
        return new String[]{SUPPORTED_PROTOCOL_SSLV3, SUPPORTED_PROTOCOL_TLSV1};
    }

    public static void setEnabledProtocols(int ssl, String[] protocols) {
        NativeCrypto.checkEnabledProtocols(protocols);
        long optionsToSet = 0x6000000L;
        long optionsToClear = 0L;
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            if (protocol.equals(SUPPORTED_PROTOCOL_SSLV3)) {
                optionsToSet &= 0xFFFFFFFFFDFFFFFFL;
                optionsToClear |= 0x2000000L;
                continue;
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_TLSV1)) {
                optionsToSet &= 0xFFFFFFFFFBFFFFFFL;
                optionsToClear |= 0x4000000L;
                continue;
            }
            throw new IllegalStateException();
        }
        NativeCrypto.SSL_set_options(ssl, optionsToSet);
        NativeCrypto.SSL_clear_options(ssl, optionsToClear);
    }

    public static String[] checkEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException("protocols == null");
        }
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            if (protocol == null) {
                throw new IllegalArgumentException("protocols[" + i + "] == null");
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_SSLV3) || protocol.equals(SUPPORTED_PROTOCOL_TLSV1)) continue;
            throw new IllegalArgumentException("protocol " + protocol + " is not supported");
        }
        return protocols;
    }

    public static native void SSL_set_cipher_lists(int var0, String[] var1);

    public static void setEnabledCipherSuites(int ssl, String[] cipherSuites) {
        NativeCrypto.checkEnabledCipherSuites(cipherSuites);
        ArrayList<String> opensslSuites = new ArrayList<String>();
        for (int i = 0; i < cipherSuites.length; ++i) {
            String cipherSuite = cipherSuites[i];
            if (cipherSuite.equals(TLS_EMPTY_RENEGOTIATION_INFO_SCSV)) continue;
            String openssl = STANDARD_TO_OPENSSL_CIPHER_SUITES.get(cipherSuite);
            String cs = openssl == null ? cipherSuite : openssl;
            opensslSuites.add(cs);
        }
        NativeCrypto.SSL_set_cipher_lists(ssl, opensslSuites.toArray(new String[opensslSuites.size()]));
    }

    public static String[] checkEnabledCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null) {
            throw new IllegalArgumentException("cipherSuites == null");
        }
        for (int i = 0; i < cipherSuites.length; ++i) {
            String cipherSuite = cipherSuites[i];
            if (cipherSuite == null) {
                throw new IllegalArgumentException("cipherSuites[" + i + "] == null");
            }
            if (cipherSuite.equals(TLS_EMPTY_RENEGOTIATION_INFO_SCSV) || STANDARD_TO_OPENSSL_CIPHER_SUITES.containsKey(cipherSuite) || OPENSSL_TO_STANDARD_CIPHER_SUITES.containsKey(cipherSuite)) continue;
            throw new IllegalArgumentException("cipherSuite " + cipherSuite + " is not supported.");
        }
        return cipherSuites;
    }

    public static String[] getSupportedCompressionMethods() {
        return (String[])SUPPORTED_COMPRESSION_METHODS.clone();
    }

    public static final String[] getDefaultCompressionMethods() {
        return new String[]{SUPPORTED_COMPRESSION_METHOD_NULL};
    }

    public static String[] checkEnabledCompressionMethods(String[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException("methods == null");
        }
        if (methods.length < 1 && !methods[methods.length - 1].equals(SUPPORTED_COMPRESSION_METHOD_NULL)) {
            throw new IllegalArgumentException("last method must be NULL");
        }
        for (int i = 0; i < methods.length; ++i) {
            String method = methods[i];
            if (method == null) {
                throw new IllegalArgumentException("methods[" + i + "] == null");
            }
            if (method.equals(SUPPORTED_COMPRESSION_METHOD_ZLIB) || method.equals(SUPPORTED_COMPRESSION_METHOD_NULL)) continue;
            throw new IllegalArgumentException("method " + method + " is not supported");
        }
        return methods;
    }

    public static void setEnabledCompressionMethods(int ssl, String[] methods) {
        NativeCrypto.checkEnabledCompressionMethods(methods);
        long optionsToSet = 131072L;
        long optionsToClear = 0L;
        for (int i = 0; i < methods.length; ++i) {
            String method = methods[i];
            if (method.equals(SUPPORTED_COMPRESSION_METHOD_NULL)) continue;
            if (method.equals(SUPPORTED_COMPRESSION_METHOD_ZLIB)) {
                optionsToSet &= 0xFFFFFFFFFFFDFFFFL;
                optionsToClear |= 0x20000L;
                continue;
            }
            throw new IllegalStateException();
        }
        NativeCrypto.SSL_set_options(ssl, optionsToSet);
        NativeCrypto.SSL_clear_options(ssl, optionsToClear);
    }

    public static native void SSL_set_verify(int var0, int var1);

    public static native void SSL_set_session(int var0, int var1) throws SSLException;

    public static native void SSL_set_session_creation_enabled(int var0, boolean var1) throws SSLException;

    public static native void SSL_set_tlsext_host_name(int var0, String var1) throws SSLException;

    public static native String SSL_get_servername(int var0);

    public static native int SSL_do_handshake(int var0, FileDescriptor var1, SSLHandshakeCallbacks var2, int var3, boolean var4) throws SSLException, SocketTimeoutException, CertificateException;

    public static native void SSL_renegotiate(int var0) throws SSLException;

    public static native byte[][] SSL_get_certificate(int var0);

    public static native byte[][] SSL_get_peer_cert_chain(int var0);

    public static native int SSL_read(int var0, FileDescriptor var1, SSLHandshakeCallbacks var2, byte[] var3, int var4, int var5, int var6) throws IOException;

    public static native void SSL_write(int var0, FileDescriptor var1, SSLHandshakeCallbacks var2, byte[] var3, int var4, int var5) throws IOException;

    public static native void SSL_interrupt(int var0);

    public static native void SSL_shutdown(int var0, FileDescriptor var1, SSLHandshakeCallbacks var2) throws IOException;

    public static native void SSL_free(int var0);

    public static native byte[] SSL_SESSION_session_id(int var0);

    public static native long SSL_SESSION_get_time(int var0);

    public static native String SSL_SESSION_get_version(int var0);

    public static native String SSL_SESSION_cipher(int var0);

    public static native String SSL_SESSION_compress_meth(int var0, int var1);

    public static native void SSL_SESSION_free(int var0);

    public static native byte[] i2d_SSL_SESSION(int var0);

    public static native int d2i_SSL_SESSION(byte[] var0);

    static {
        NativeCrypto.clinit();
        OPENSSL_TO_STANDARD_CIPHER_SUITES = new HashMap<String, String>();
        STANDARD_TO_OPENSSL_CIPHER_SUITES = new LinkedHashMap<String, String>();
        NativeCrypto.add("SSL_RSA_WITH_RC4_128_MD5", "RC4-MD5");
        NativeCrypto.add("SSL_RSA_WITH_RC4_128_SHA", "RC4-SHA");
        NativeCrypto.add("TLS_RSA_WITH_AES_128_CBC_SHA", "AES128-SHA");
        NativeCrypto.add("TLS_RSA_WITH_AES_256_CBC_SHA", "AES256-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "ECDH-ECDSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "ECDH-ECDSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "ECDH-ECDSA-AES256-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_RC4_128_SHA", "ECDH-RSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "ECDH-RSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "ECDH-RSA-AES256-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "ECDHE-ECDSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "ECDHE-ECDSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "ECDHE-ECDSA-AES256-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA", "ECDHE-RSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "ECDHE-RSA-AES256-SHA");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "DHE-RSA-AES128-SHA");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "DHE-RSA-AES256-SHA");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "DHE-DSS-AES128-SHA");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "DHE-DSS-AES256-SHA");
        NativeCrypto.add("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "ECDH-ECDSA-DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "ECDH-RSA-DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "ECDHE-ECDSA-DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "ECDHE-RSA-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "EDH-RSA-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "EDH-DSS-DES-CBC3-SHA");
        NativeCrypto.add("SSL_RSA_WITH_DES_CBC_SHA", "DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", "EDH-RSA-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", "EDH-DSS-DES-CBC-SHA");
        NativeCrypto.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", "EXP-RC4-MD5");
        NativeCrypto.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-RSA-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-DSS-DES-CBC-SHA");
        NativeCrypto.add("SSL_RSA_WITH_NULL_MD5", "NULL-MD5");
        NativeCrypto.add("SSL_RSA_WITH_NULL_SHA", "NULL-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_NULL_SHA", "ECDH-ECDSA-NULL-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_NULL_SHA", "ECDH-RSA-NULL-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_NULL_SHA", "ECDHE-ECDSA-NULL-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_NULL_SHA", "ECDHE-RSA-NULL-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_RC4_128_MD5", "ADH-RC4-MD5");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_128_CBC_SHA", "ADH-AES128-SHA");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_256_CBC_SHA", "ADH-AES256-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "ADH-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_DES_CBC_SHA", "ADH-DES-CBC-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_RC4_128_SHA", "AECDH-RC4-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "AECDH-AES128-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "AECDH-AES256-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "AECDH-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "EXP-ADH-RC4-MD5");
        NativeCrypto.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "EXP-ADH-DES-CBC-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_NULL_SHA", "AECDH-NULL-SHA");
        int size = STANDARD_TO_OPENSSL_CIPHER_SUITES.size();
        SUPPORTED_CIPHER_SUITES = new String[size + 1];
        STANDARD_TO_OPENSSL_CIPHER_SUITES.keySet().toArray(SUPPORTED_CIPHER_SUITES);
        NativeCrypto.SUPPORTED_CIPHER_SUITES[size] = TLS_EMPTY_RENEGOTIATION_INFO_SCSV;
        SUPPORTED_COMPRESSION_METHODS = new String[]{SUPPORTED_COMPRESSION_METHOD_ZLIB, SUPPORTED_COMPRESSION_METHOD_NULL};
    }

    public static interface SSLHandshakeCallbacks {
        public void verifyCertificateChain(byte[][] var1, String var2) throws CertificateException;

        public void clientCertificateRequested(byte[] var1, byte[][] var2) throws CertificateEncodingException, SSLException;

        public void handshakeCompleted();
    }
}

