/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;

public class OpenSSLSignature
extends Signature {
    private static Map<String, Class<? extends OpenSSLSignature>> jdkToOpenSsl = new HashMap<String, Class<? extends OpenSSLSignature>>();
    private int ctx;
    private int dsa;
    private int rsa;
    private final String evpAlgorithm;
    private final byte[] singleByte = new byte[1];

    public static OpenSSLSignature getInstance(String algorithm) throws NoSuchAlgorithmException {
        Class<? extends OpenSSLSignature> clazz = jdkToOpenSsl.get(algorithm);
        if (clazz == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(algorithm, e);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(algorithm, e);
        }
    }

    private OpenSSLSignature(String algorithm) throws NoSuchAlgorithmException {
        super(algorithm);
        if ("RSA-MD2".equals(algorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        this.evpAlgorithm = algorithm;
    }

    protected void engineUpdate(byte input) {
        this.singleByte[0] = input;
        this.engineUpdate(this.singleByte, 0, 1);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        if (this.state == 2) {
            throw new UnsupportedOperationException();
        }
        NativeCrypto.EVP_VerifyUpdate(this.ctx, input, offset, len);
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof DSAPublicKey) {
            try {
                DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
                DSAParams dsaParams = dsaPublicKey.getParams();
                this.dsa = NativeCrypto.EVP_PKEY_new_DSA(dsaParams.getP().toByteArray(), dsaParams.getQ().toByteArray(), dsaParams.getG().toByteArray(), dsaPublicKey.getY().toByteArray(), null);
            }
            catch (Exception e) {
                throw new InvalidKeyException(e);
            }
        } else if (publicKey instanceof RSAPublicKey) {
            try {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                this.rsa = NativeCrypto.EVP_PKEY_new_RSA(rsaPublicKey.getModulus().toByteArray(), rsaPublicKey.getPublicExponent().toByteArray(), null, null, null);
            }
            catch (Exception e) {
                throw new InvalidKeyException(e);
            }
        } else {
            throw new InvalidKeyException("Need DSA or RSA public key");
        }
        try {
            this.ctx = NativeCrypto.EVP_VerifyInit(this.evpAlgorithm);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected byte[] engineSign() throws SignatureException {
        throw new UnsupportedOperationException();
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        int handle;
        int n = handle = this.rsa != 0 ? this.rsa : this.dsa;
        if (handle == 0) {
            throw new SignatureException("Need DSA or RSA public key");
        }
        try {
            int result = NativeCrypto.EVP_VerifyFinal(this.ctx, sigBytes, 0, sigBytes.length, handle);
            return result == 1;
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.dsa != 0) {
                NativeCrypto.EVP_PKEY_free(this.dsa);
            }
            if (this.rsa != 0) {
                NativeCrypto.EVP_PKEY_free(this.rsa);
            }
            if (this.ctx != 0) {
                NativeCrypto.EVP_MD_CTX_destroy(this.ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        jdkToOpenSsl.put("MD5WithRSAEncryption", MD5RSA.class);
        jdkToOpenSsl.put("MD5WithRSA", MD5RSA.class);
        jdkToOpenSsl.put("MD5/RSA", MD5RSA.class);
        jdkToOpenSsl.put("1.2.840.113549.1.1.4", MD5RSA.class);
        jdkToOpenSsl.put("1.2.840.113549.2.5with1.2.840.113549.1.1.1", MD5RSA.class);
        jdkToOpenSsl.put("SHA1WithRSAEncryption", SHA1RSA.class);
        jdkToOpenSsl.put("SHA1WithRSA", SHA1RSA.class);
        jdkToOpenSsl.put("SHA1/RSA", SHA1RSA.class);
        jdkToOpenSsl.put("SHA-1/RSA", SHA1RSA.class);
        jdkToOpenSsl.put("1.2.840.113549.1.1.5", SHA1RSA.class);
        jdkToOpenSsl.put("1.3.14.3.2.26with1.2.840.113549.1.1.1", SHA1RSA.class);
        jdkToOpenSsl.put("1.3.14.3.2.26with1.2.840.113549.1.1.5", SHA1RSA.class);
        jdkToOpenSsl.put("1.3.14.3.2.29", SHA1RSA.class);
        jdkToOpenSsl.put("SHA256WithRSAEncryption", SHA256RSA.class);
        jdkToOpenSsl.put("SHA256WithRSA", SHA256RSA.class);
        jdkToOpenSsl.put("1.2.840.113549.1.1.11", SHA256RSA.class);
        jdkToOpenSsl.put("SHA384WithRSAEncryption", SHA384RSA.class);
        jdkToOpenSsl.put("SHA384WithRSA", SHA384RSA.class);
        jdkToOpenSsl.put("1.2.840.113549.1.1.12", SHA384RSA.class);
        jdkToOpenSsl.put("SHA512WithRSAEncryption", SHA512RSA.class);
        jdkToOpenSsl.put("SHA512WithRSA", SHA512RSA.class);
        jdkToOpenSsl.put("1.2.840.113549.1.1.13", SHA512RSA.class);
        jdkToOpenSsl.put("SHA1withDSA", SHA1DSA.class);
        jdkToOpenSsl.put("SHA/DSA", SHA1DSA.class);
        jdkToOpenSsl.put("DSA", SHA1DSA.class);
        jdkToOpenSsl.put("1.3.14.3.2.26with1.2.840.10040.4.1", SHA1DSA.class);
        jdkToOpenSsl.put("1.3.14.3.2.26with1.2.840.10040.4.3", SHA1DSA.class);
        jdkToOpenSsl.put("DSAWithSHA1", SHA1DSA.class);
        jdkToOpenSsl.put("1.2.840.10040.4.3", SHA1DSA.class);
    }

    public static final class SHA1DSA
    extends OpenSSLSignature {
        public SHA1DSA() throws NoSuchAlgorithmException {
            super("DSA-SHA1");
        }
    }

    public static final class SHA512RSA
    extends OpenSSLSignature {
        public SHA512RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA512");
        }
    }

    public static final class SHA384RSA
    extends OpenSSLSignature {
        public SHA384RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA384");
        }
    }

    public static final class SHA256RSA
    extends OpenSSLSignature {
        public SHA256RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA256");
        }
    }

    public static final class SHA1RSA
    extends OpenSSLSignature {
        public SHA1RSA() throws NoSuchAlgorithmException {
            super("RSA-SHA1");
        }
    }

    public static final class MD5RSA
    extends OpenSSLSignature {
        public MD5RSA() throws NoSuchAlgorithmException {
            super("RSA-MD5");
        }
    }
}

