/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import libcore.util.EmptyArray;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.ProtocolVersion;

public final class SSLSessionImpl
implements SSLSession,
Cloneable {
    public static final SSLSessionImpl NULL_SESSION = new SSLSessionImpl(null);
    private long creationTime;
    private boolean isValid = true;
    private final Map<String, Object> values = new HashMap<String, Object>();
    byte[] id;
    long lastAccessedTime = this.creationTime = System.currentTimeMillis();
    ProtocolVersion protocol;
    CipherSuite cipherSuite;
    SSLSessionContext context;
    java.security.cert.X509Certificate[] localCertificates;
    java.security.cert.X509Certificate[] peerCertificates;
    private String peerHost;
    private int peerPort = -1;
    byte[] master_secret;
    byte[] clientRandom;
    byte[] serverRandom;
    final boolean isServer;

    public SSLSessionImpl(CipherSuite cipher_suite, SecureRandom secureRandom) {
        if (cipher_suite == null) {
            this.cipherSuite = CipherSuite.SSL_NULL_WITH_NULL_NULL;
            this.id = EmptyArray.BYTE;
            this.isServer = false;
            this.isValid = false;
        } else {
            this.cipherSuite = cipher_suite;
            this.id = new byte[32];
            secureRandom.nextBytes(this.id);
            long time = this.creationTime / 1000L;
            this.id[28] = (byte)((time & 0xFFFFFFFFFF000000L) >>> 24);
            this.id[29] = (byte)((time & 0xFF0000L) >>> 16);
            this.id[30] = (byte)((time & 0xFF00L) >>> 8);
            this.id[31] = (byte)(time & 0xFFL);
            this.isServer = true;
        }
    }

    public SSLSessionImpl(SecureRandom secureRandom) {
        this(null, secureRandom);
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String getCipherSuite() {
        return this.cipherSuite.getName();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    public Principal getLocalPrincipal() {
        if (this.localCertificates != null && this.localCertificates.length > 0) {
            return this.localCertificates[0].getSubjectX500Principal();
        }
        return null;
    }

    public int getPacketBufferSize() {
        return 18437;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        X509Certificate[] certs = new X509Certificate[this.peerCertificates.length];
        for (int i = 0; i < certs.length; ++i) {
            try {
                certs[i] = X509Certificate.getInstance(this.peerCertificates[i].getEncoded());
                continue;
            }
            catch (CertificateException ignored) {
                continue;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return certs;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        return this.peerCertificates;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null) {
            throw new SSLPeerUnverifiedException("No peer certificate");
        }
        return this.peerCertificates[0].getSubjectX500Principal();
    }

    public String getProtocol() {
        return this.protocol == null ? "NONE" : this.protocol.name;
    }

    public SSLSessionContext getSessionContext() {
        return this.context;
    }

    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        return this.values.get(name);
    }

    public String[] getValueNames() {
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    public void invalidate() {
        this.isValid = false;
        this.context = null;
    }

    public boolean isValid() {
        if (this.isValid && this.context != null && this.context.getSessionTimeout() != 0 && this.lastAccessedTime + (long)this.context.getSessionTimeout() > System.currentTimeMillis()) {
            this.isValid = false;
        }
        return this.isValid;
    }

    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name == null || value == null");
        }
        Object old = this.values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        Object old = this.values.remove(name);
        if (old instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)old;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    void setPeer(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }
}

