/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.apache.harmony.xnet.provider.jsse.TrustedCertificateIndex;
import org.apache.harmony.xnet.provider.jsse.TrustedCertificateStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrustManagerImpl
implements X509TrustManager {
    private final KeyStore rootKeyStore;
    private final TrustedCertificateStore trustedCertificateStore;
    private final CertPathValidator validator;
    private final TrustedCertificateIndex trustedCertificateIndex;
    private final X509Certificate[] acceptedIssuers;
    private final Exception err;
    private final CertificateFactory factory;

    public TrustManagerImpl(KeyStore keyStore) {
        CertPathValidator validatorLocal = null;
        CertificateFactory factoryLocal = null;
        KeyStore rootKeyStoreLocal = null;
        TrustedCertificateStore trustedCertificateStoreLocal = null;
        TrustedCertificateIndex trustedCertificateIndexLocal = null;
        X509Certificate[] acceptedIssuersLocal = null;
        Exception errLocal = null;
        try {
            validatorLocal = CertPathValidator.getInstance("PKIX");
            factoryLocal = CertificateFactory.getInstance("X509");
            if ("AndroidCAStore".equals(keyStore.getType())) {
                rootKeyStoreLocal = keyStore;
                trustedCertificateStoreLocal = new TrustedCertificateStore();
                acceptedIssuersLocal = null;
                trustedCertificateIndexLocal = new TrustedCertificateIndex();
            } else {
                rootKeyStoreLocal = null;
                trustedCertificateStoreLocal = null;
                acceptedIssuersLocal = TrustManagerImpl.acceptedIssuers(keyStore);
                trustedCertificateIndexLocal = new TrustedCertificateIndex(TrustManagerImpl.trustAnchors(acceptedIssuersLocal));
            }
        }
        catch (Exception e) {
            errLocal = e;
        }
        this.rootKeyStore = rootKeyStoreLocal;
        this.trustedCertificateStore = trustedCertificateStoreLocal;
        this.validator = validatorLocal;
        this.factory = factoryLocal;
        this.trustedCertificateIndex = trustedCertificateIndexLocal;
        this.acceptedIssuers = acceptedIssuersLocal;
        this.err = errLocal;
    }

    private static X509Certificate[] acceptedIssuers(KeyStore ks) {
        try {
            ArrayList<X509Certificate> trusted = new ArrayList<X509Certificate>();
            Enumeration<String> en = ks.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                if (cert == null) continue;
                trusted.add(cert);
            }
            return trusted.toArray(new X509Certificate[trusted.size()]);
        }
        catch (KeyStoreException e) {
            return new X509Certificate[0];
        }
    }

    private static Set<TrustAnchor> trustAnchors(X509Certificate[] certs) {
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>(certs.length);
        for (X509Certificate cert : certs) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        return trustAnchors;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType);
    }

    private void checkTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0 || authType == null || authType.length() == 0) {
            throw new IllegalArgumentException("null or zero-length parameter");
        }
        if (this.err != null) {
            throw new CertificateException(this.err);
        }
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        X509Certificate[] newChain = this.cleanupCertChainAndFindTrustAnchors(chain, trustAnchors);
        if (newChain.length == 0) {
            return;
        }
        CertPath certPath = this.factory.generateCertPath(Arrays.asList(newChain));
        if (trustAnchors.isEmpty()) {
            throw new CertificateException(new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1));
        }
        try {
            PKIXParameters params = new PKIXParameters(trustAnchors);
            params.setRevocationEnabled(false);
            this.validator.validate(certPath, params);
            for (int i = 1; i < newChain.length; ++i) {
                this.trustedCertificateIndex.index(newChain[i]);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException(e);
        }
    }

    private X509Certificate[] cleanupCertChainAndFindTrustAnchors(X509Certificate[] chain, Set<TrustAnchor> trustAnchors) {
        TrustAnchor trustAnchor;
        int chainLength;
        X509Certificate[] newChain;
        int currIndex;
        X509Certificate[] original = chain;
        for (currIndex = 0; currIndex < chain.length; ++currIndex) {
            TrustAnchor trustAnchor2 = this.findTrustAnchorBySubjectAndPublicKey(chain[currIndex]);
            if (trustAnchor2 != null) {
                trustAnchors.add(trustAnchor2);
                --currIndex;
                break;
            }
            boolean foundNext = false;
            for (int nextIndex = currIndex + 1; nextIndex < chain.length; ++nextIndex) {
                if (!((Object)chain[currIndex].getIssuerDN()).equals(chain[nextIndex].getSubjectDN())) continue;
                foundNext = true;
                if (nextIndex == currIndex + 1) break;
                if (chain == original) {
                    chain = (X509Certificate[])original.clone();
                }
                X509Certificate tempCertificate = chain[nextIndex];
                chain[nextIndex] = chain[currIndex + 1];
                chain[currIndex + 1] = tempCertificate;
                break;
            }
            if (!foundNext) break;
        }
        X509Certificate[] x509CertificateArray = newChain = (chainLength = currIndex + 1) == chain.length ? chain : Arrays.copyOf(chain, chainLength);
        if (trustAnchors.isEmpty() && (trustAnchor = this.findTrustAnchorByIssuerAndSignature(newChain[chainLength - 1])) != null) {
            trustAnchors.add(trustAnchor);
        }
        return newChain;
    }

    private TrustAnchor findTrustAnchorBySubjectAndPublicKey(X509Certificate cert) {
        TrustAnchor trustAnchor = this.trustedCertificateIndex.findBySubjectAndPublicKey(cert);
        if (trustAnchor != null) {
            return trustAnchor;
        }
        if (this.trustedCertificateStore == null) {
            return null;
        }
        if (this.trustedCertificateStore.isTrustAnchor(cert)) {
            return this.trustedCertificateIndex.index(cert);
        }
        return null;
    }

    private TrustAnchor findTrustAnchorByIssuerAndSignature(X509Certificate lastCert) {
        TrustAnchor trustAnchor = this.trustedCertificateIndex.findByIssuerAndSignature(lastCert);
        if (trustAnchor != null) {
            return trustAnchor;
        }
        if (this.trustedCertificateStore == null) {
            return null;
        }
        X509Certificate issuer = this.trustedCertificateStore.findIssuer(lastCert);
        if (issuer != null) {
            return this.trustedCertificateIndex.index(issuer);
        }
        return null;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers != null ? (X509Certificate[])this.acceptedIssuers.clone() : TrustManagerImpl.acceptedIssuers(this.rootKeyStore);
    }
}

