/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActionBar;
import android.app.Application;
import android.app.Dialog;
import android.app.Fragment;
import android.app.Instrumentation;
import android.app.PendingIntent;
import android.app.SearchManager;
import android.app.TaskStackBuilder;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.text.Selection;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class Activity
extends ContextThemeWrapper
implements LayoutInflater.Factory2,
Window.Callback,
KeyEvent.Callback,
View.OnCreateContextMenuListener,
ComponentCallbacks2 {
    private static final String TAG = "Activity";
    private static final boolean DEBUG_LIFECYCLE = false;
    public static final int RESULT_CANCELED = 0;
    public static final int RESULT_OK = -1;
    public static final int RESULT_FIRST_USER = 1;
    static final String FRAGMENTS_TAG = "android:fragments";
    private static final String WINDOW_HIERARCHY_TAG = "android:viewHierarchyState";
    private static final String SAVED_DIALOG_IDS_KEY = "android:savedDialogIds";
    private static final String SAVED_DIALOGS_TAG = "android:savedDialogs";
    private static final String SAVED_DIALOG_KEY_PREFIX = "android:dialog_";
    private static final String SAVED_DIALOG_ARGS_KEY_PREFIX = "android:dialog_args_";
    private SparseArray<ManagedDialog> mManagedDialogs;
    private Instrumentation mInstrumentation;
    private IBinder mToken;
    private int mIdent;
    String mEmbeddedID;
    private Application mApplication;
    Intent mIntent;
    private ComponentName mComponent;
    ActivityInfo mActivityInfo;
    Activity mParent;
    boolean mCalled;
    boolean mCheckedForLoaderManager;
    boolean mLoadersStarted;
    boolean mResumed;
    private boolean mStopped;
    boolean mFinished;
    boolean mStartedActivity;
    private boolean mDestroyed;
    boolean mTemporaryPause = false;
    boolean mChangingConfigurations = false;
    int mConfigChangeFlags;
    Configuration mCurrentConfig;
    private SearchManager mSearchManager;
    private MenuInflater mMenuInflater;
    NonConfigurationInstances mLastNonConfigurationInstances;
    private Window mWindow;
    private WindowManager mWindowManager;
    View mDecor = null;
    boolean mWindowAdded = false;
    boolean mVisibleFromServer = false;
    boolean mVisibleFromClient = true;
    private boolean mEnableDefaultActionBarUp;
    private CharSequence mTitle;
    private int mTitleColor = 0;
    private final ArrayList<ManagedCursor> mManagedCursors = new ArrayList();
    int mResultCode = 0;
    private boolean mTitleReady = false;
    private int mDefaultKeyMode = 0;
    private SpannableStringBuilder mDefaultKeySsb = null;
    protected static final int[] FOCUSED_STATE_SET = new int[0];
    private Thread mUiThread;
    final Handler mHandler = new Handler();
    public static final int DEFAULT_KEYS_DISABLE = 0;
    public static final int DEFAULT_KEYS_DIALER = 1;
    public static final int DEFAULT_KEYS_SHORTCUT = 2;
    public static final int DEFAULT_KEYS_SEARCH_LOCAL = 3;
    public static final int DEFAULT_KEYS_SEARCH_GLOBAL = 4;

    public Intent getIntent() {
        return this.mIntent;
    }

    public void setIntent(Intent intent) {
        this.mIntent = intent;
    }

    public final Application getApplication() {
        return this.mApplication;
    }

    public final boolean isChild() {
        return this.mParent != null;
    }

    public final Activity getParent() {
        return this.mParent;
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public View getCurrentFocus() {
        return this.mWindow != null ? this.mWindow.getCurrentFocus() : null;
    }

    protected void onCreate(Bundle bundle) {
    }

    final void performRestoreInstanceState(Bundle bundle) {
        this.onRestoreInstanceState(bundle);
        this.restoreManagedDialogs(bundle);
    }

    protected void onRestoreInstanceState(Bundle bundle) {
        Bundle bundle2;
        if (this.mWindow != null && (bundle2 = bundle.getBundle(WINDOW_HIERARCHY_TAG)) != null) {
            this.mWindow.restoreHierarchyState(bundle2);
        }
    }

    private void restoreManagedDialogs(Bundle bundle) {
        Bundle bundle2 = bundle.getBundle(SAVED_DIALOGS_TAG);
        if (bundle2 == null) {
            return;
        }
        int[] nArray = bundle2.getIntArray(SAVED_DIALOG_IDS_KEY);
        int n = nArray.length;
        this.mManagedDialogs = new SparseArray(n);
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray[i];
            Bundle bundle3 = bundle2.getBundle(Activity.savedDialogKeyFor(n2));
            if (bundle3 == null) continue;
            ManagedDialog managedDialog = new ManagedDialog();
            managedDialog.mArgs = bundle2.getBundle(Activity.savedDialogArgsKeyFor(n2));
            managedDialog.mDialog = this.createDialog(n2, bundle3, managedDialog.mArgs);
            if (managedDialog.mDialog == null) continue;
            this.mManagedDialogs.put(n2, managedDialog);
            this.onPrepareDialog(n2, managedDialog.mDialog, managedDialog.mArgs);
            managedDialog.mDialog.onRestoreInstanceState(bundle3);
        }
    }

    private Dialog createDialog(Integer n, Bundle bundle, Bundle bundle2) {
        return null;
    }

    private static String savedDialogKeyFor(int n) {
        return SAVED_DIALOG_KEY_PREFIX + n;
    }

    private static String savedDialogArgsKeyFor(int n) {
        return SAVED_DIALOG_ARGS_KEY_PREFIX + n;
    }

    protected void onPostCreate(Bundle bundle) {
        if (!this.isChild()) {
            this.mTitleReady = true;
            this.onTitleChanged(this.getTitle(), this.getTitleColor());
        }
        this.mCalled = true;
    }

    protected void onStart() {
    }

    protected void onRestart() {
        this.mCalled = true;
    }

    protected void onResume() {
    }

    protected void onPostResume() {
    }

    protected void onNewIntent(Intent intent) {
    }

    final void performSaveInstanceState(Bundle bundle) {
    }

    protected void onSaveInstanceState(Bundle bundle) {
    }

    private void saveManagedDialogs(Bundle bundle) {
        if (this.mManagedDialogs == null) {
            return;
        }
        int n = this.mManagedDialogs.size();
        if (n == 0) {
            return;
        }
        Bundle bundle2 = new Bundle();
        int[] nArray = new int[this.mManagedDialogs.size()];
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = this.mManagedDialogs.keyAt(i);
            ManagedDialog managedDialog = this.mManagedDialogs.valueAt(i);
            bundle2.putBundle(Activity.savedDialogKeyFor(n2), managedDialog.mDialog.onSaveInstanceState());
            if (managedDialog.mArgs == null) continue;
            bundle2.putBundle(Activity.savedDialogArgsKeyFor(n2), managedDialog.mArgs);
        }
        bundle2.putIntArray(SAVED_DIALOG_IDS_KEY, nArray);
        bundle.putBundle(SAVED_DIALOGS_TAG, bundle2);
    }

    protected void onPause() {
    }

    protected void onUserLeaveHint() {
    }

    public boolean onCreateThumbnail(Bitmap bitmap, Canvas canvas) {
        return false;
    }

    public CharSequence onCreateDescription() {
        return null;
    }

    protected void onStop() {
    }

    protected void onDestroy() {
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
    }

    public int getChangingConfigurations() {
        return this.mConfigChangeFlags;
    }

    @Deprecated
    public Object getLastNonConfigurationInstance() {
        return this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.activity : null;
    }

    public Object onRetainNonConfigurationInstance() {
        return null;
    }

    HashMap<String, Object> getLastNonConfigurationChildInstances() {
        return this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.children : null;
    }

    HashMap<String, Object> onRetainNonConfigurationChildInstances() {
        return null;
    }

    NonConfigurationInstances retainNonConfigurationInstances() {
        return null;
    }

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int n) {
    }

    void invalidateFragment(String string2) {
    }

    public void onAttachFragment(Fragment fragment) {
    }

    @Deprecated
    public final Cursor managedQuery(Uri uri, String[] stringArray, String string2, String string3) {
        Cursor cursor = this.getContentResolver().query(uri, stringArray, string2, null, string3);
        if (cursor != null) {
            this.startManagingCursor(cursor);
        }
        return cursor;
    }

    @Deprecated
    public final Cursor managedQuery(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        Cursor cursor = this.getContentResolver().query(uri, stringArray, string2, stringArray2, string3);
        if (cursor != null) {
            this.startManagingCursor(cursor);
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void startManagingCursor(Cursor cursor) {
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            this.mManagedCursors.add(new ManagedCursor(cursor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void stopManagingCursor(Cursor cursor) {
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            int n = this.mManagedCursors.size();
            for (int i = 0; i < n; ++i) {
                ManagedCursor managedCursor = this.mManagedCursors.get(i);
                if (managedCursor.mCursor != cursor) continue;
                this.mManagedCursors.remove(i);
                break;
            }
        }
    }

    @Deprecated
    public void setPersistent(boolean bl) {
    }

    public View findViewById(int n) {
        return this.getWindow().findViewById(n);
    }

    public ActionBar getActionBar() {
        return null;
    }

    private void initActionBar() {
    }

    public void setContentView(int n) {
        this.getWindow().setContentView(n);
    }

    public void setContentView(View view) {
        this.getWindow().setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.getWindow().setContentView(view, layoutParams);
    }

    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.getWindow().addContentView(view, layoutParams);
    }

    public void setFinishOnTouchOutside(boolean bl) {
    }

    public final void setDefaultKeyMode(int n) {
        this.mDefaultKeyMode = n;
        switch (n) {
            case 0: 
            case 2: {
                this.mDefaultKeySsb = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mDefaultKeySsb = new SpannableStringBuilder();
                Selection.setSelection(this.mDefaultKeySsb, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        boolean bl;
        if (n == 4) {
            if (this.getApplicationInfo().targetSdkVersion >= 5) {
                keyEvent.startTracking();
            } else {
                this.onBackPressed();
            }
            return true;
        }
        if (this.mDefaultKeyMode == 0) {
            return false;
        }
        if (this.mDefaultKeyMode == 2) {
            return this.getWindow().performPanelShortcut(0, n, keyEvent, 2);
        }
        boolean bl2 = false;
        if (keyEvent.getRepeatCount() != 0 || keyEvent.isSystem()) {
            bl2 = true;
            bl = false;
        } else {
            bl = TextKeyListener.getInstance().onKeyDown(null, this.mDefaultKeySsb, n, keyEvent);
            if (bl && this.mDefaultKeySsb.length() > 0) {
                String string2 = this.mDefaultKeySsb.toString();
                bl2 = true;
                switch (this.mDefaultKeyMode) {
                    case 1: {
                        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse("tel:" + string2));
                        intent.addFlags(0x10000000);
                        this.startActivity(intent);
                        break;
                    }
                    case 3: {
                        this.startSearch(string2, false, null, false);
                        break;
                    }
                    case 4: {
                        this.startSearch(string2, false, null, true);
                    }
                }
            }
        }
        if (bl2) {
            this.mDefaultKeySsb.clear();
            this.mDefaultKeySsb.clearSpans();
            Selection.setSelection(this.mDefaultKeySsb, 0);
        }
        return bl;
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (this.getApplicationInfo().targetSdkVersion >= 5 && n == 4 && keyEvent.isTracking() && !keyEvent.isCanceled()) {
            this.onBackPressed();
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return false;
    }

    public void onBackPressed() {
    }

    public boolean onKeyShortcut(int n, KeyEvent keyEvent) {
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return false;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return false;
    }

    public void onUserInteraction() {
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        View view;
        if (this.mParent == null && (view = this.mDecor) != null && view.getParent() != null) {
            this.getWindowManager().updateViewLayout(view, layoutParams);
        }
    }

    @Override
    public void onContentChanged() {
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
    }

    @Override
    public void onAttachedToWindow() {
    }

    @Override
    public void onDetachedFromWindow() {
    }

    public boolean hasWindowFocus() {
        View view;
        Window window = this.getWindow();
        if (window != null && (view = window.getDecorView()) != null) {
            return view.hasWindowFocus();
        }
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        this.onUserInteraction();
        Window window = this.getWindow();
        if (window.superDispatchKeyEvent(keyEvent)) {
            return true;
        }
        View view = this.mDecor;
        if (view == null) {
            view = window.getDecorView();
        }
        return keyEvent.dispatch(this, view != null ? view.getKeyDispatcherState() : null, this);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchKeyShortcutEvent(keyEvent)) {
            return true;
        }
        return this.onKeyShortcut(keyEvent.getKeyCode(), keyEvent);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.onUserInteraction();
        }
        if (this.getWindow().superDispatchTouchEvent(motionEvent)) {
            return true;
        }
        return this.onTouchEvent(motionEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchTrackballEvent(motionEvent)) {
            return true;
        }
        return this.onTrackballEvent(motionEvent);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchGenericMotionEvent(motionEvent)) {
            return true;
        }
        return this.onGenericMotionEvent(motionEvent);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        accessibilityEvent.setClassName(this.getClass().getName());
        accessibilityEvent.setPackageName(this.getPackageName());
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        boolean bl = layoutParams.width == -1 && layoutParams.height == -1;
        accessibilityEvent.setFullScreen(bl);
        CharSequence charSequence = this.getTitle();
        if (!TextUtils.isEmpty(charSequence)) {
            accessibilityEvent.getText().add(charSequence);
        }
        return true;
    }

    @Override
    public View onCreatePanelView(int n) {
        return null;
    }

    @Override
    public boolean onCreatePanelMenu(int n, Menu menu2) {
        return false;
    }

    @Override
    public boolean onPreparePanel(int n, View view, Menu menu2) {
        return true;
    }

    @Override
    public boolean onMenuOpened(int n, Menu menu2) {
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int n, MenuItem menuItem) {
        return true;
    }

    @Override
    public void onPanelClosed(int n, Menu menu2) {
    }

    public void invalidateOptionsMenu() {
        this.mWindow.invalidatePanelMenu(0);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.mParent != null) {
            return this.mParent.onCreateOptionsMenu(menu2);
        }
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (this.mParent != null) {
            return this.mParent.onPrepareOptionsMenu(menu2);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (this.mParent != null) {
            return this.mParent.onOptionsItemSelected(menuItem);
        }
        return false;
    }

    public boolean onNavigateUp() {
        Intent intent = this.getParentActivityIntent();
        if (intent != null) {
            if (this.mActivityInfo.taskAffinity == null) {
                this.finish();
            } else if (this.shouldUpRecreateTask(intent)) {
                TaskStackBuilder taskStackBuilder = TaskStackBuilder.create(this);
                this.onCreateNavigateUpTaskStack(taskStackBuilder);
                this.onPrepareNavigateUpTaskStack(taskStackBuilder);
                taskStackBuilder.startActivities();
                if (this.mResultCode != 0) {
                    Log.i(TAG, "onNavigateUp only finishing topmost activity to return a result");
                    this.finish();
                } else {
                    this.finishAffinity();
                }
            } else {
                this.navigateUpTo(intent);
            }
            return true;
        }
        return false;
    }

    public boolean onNavigateUpFromChild(Activity activity) {
        return this.onNavigateUp();
    }

    public void onCreateNavigateUpTaskStack(TaskStackBuilder taskStackBuilder) {
        taskStackBuilder.addParentStack(this);
    }

    public void onPrepareNavigateUpTaskStack(TaskStackBuilder taskStackBuilder) {
    }

    public void onOptionsMenuClosed(Menu menu2) {
        if (this.mParent != null) {
            this.mParent.onOptionsMenuClosed(menu2);
        }
    }

    public void openOptionsMenu() {
        this.mWindow.openPanel(0, null);
    }

    public void closeOptionsMenu() {
        this.mWindow.closePanel(0);
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    public void openContextMenu(View view) {
        view.showContextMenu();
    }

    public void closeContextMenu() {
        this.mWindow.closePanel(6);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        if (this.mParent != null) {
            return this.mParent.onContextItemSelected(menuItem);
        }
        return false;
    }

    public void onContextMenuClosed(Menu menu2) {
        if (this.mParent != null) {
            this.mParent.onContextMenuClosed(menu2);
        }
    }

    @Deprecated
    protected Dialog onCreateDialog(int n) {
        return null;
    }

    @Deprecated
    protected Dialog onCreateDialog(int n, Bundle bundle) {
        return this.onCreateDialog(n);
    }

    @Deprecated
    protected void onPrepareDialog(int n, Dialog dialog) {
        dialog.setOwnerActivity(this);
    }

    @Deprecated
    protected void onPrepareDialog(int n, Dialog dialog, Bundle bundle) {
        this.onPrepareDialog(n, dialog);
    }

    @Deprecated
    public final void showDialog(int n) {
        this.showDialog(n, null);
    }

    @Deprecated
    public final boolean showDialog(int n, Bundle bundle) {
        ManagedDialog managedDialog;
        if (this.mManagedDialogs == null) {
            this.mManagedDialogs = new SparseArray();
        }
        if ((managedDialog = this.mManagedDialogs.get(n)) == null) {
            managedDialog = new ManagedDialog();
            managedDialog.mDialog = this.createDialog(n, null, bundle);
            if (managedDialog.mDialog == null) {
                return false;
            }
            this.mManagedDialogs.put(n, managedDialog);
        }
        managedDialog.mArgs = bundle;
        this.onPrepareDialog(n, managedDialog.mDialog, bundle);
        managedDialog.mDialog.show();
        return true;
    }

    @Deprecated
    public final void dismissDialog(int n) {
        if (this.mManagedDialogs == null) {
            throw this.missingDialog(n);
        }
        ManagedDialog managedDialog = this.mManagedDialogs.get(n);
        if (managedDialog == null) {
            throw this.missingDialog(n);
        }
        managedDialog.mDialog.dismiss();
    }

    private IllegalArgumentException missingDialog(int n) {
        return new IllegalArgumentException("no dialog with id " + n + " was ever " + "shown via Activity#showDialog");
    }

    @Deprecated
    public final void removeDialog(int n) {
        ManagedDialog managedDialog;
        if (this.mManagedDialogs != null && (managedDialog = this.mManagedDialogs.get(n)) != null) {
            managedDialog.mDialog.dismiss();
            this.mManagedDialogs.remove(n);
        }
    }

    @Override
    public boolean onSearchRequested() {
        this.startSearch(null, false, null, false);
        return true;
    }

    public void startSearch(String string2, boolean bl, Bundle bundle, boolean bl2) {
        this.ensureSearchManager();
        this.mSearchManager.startSearch(string2, bl, this.getComponentName(), bundle, bl2);
    }

    public void triggerSearch(String string2, Bundle bundle) {
        this.ensureSearchManager();
        this.mSearchManager.triggerSearch(string2, this.getComponentName(), bundle);
    }

    public void takeKeyEvents(boolean bl) {
        this.getWindow().takeKeyEvents(bl);
    }

    public final boolean requestWindowFeature(int n) {
        return this.getWindow().requestFeature(n);
    }

    public final void setFeatureDrawableResource(int n, int n2) {
        this.getWindow().setFeatureDrawableResource(n, n2);
    }

    public final void setFeatureDrawableUri(int n, Uri uri) {
        this.getWindow().setFeatureDrawableUri(n, uri);
    }

    public final void setFeatureDrawable(int n, Drawable drawable2) {
        this.getWindow().setFeatureDrawable(n, drawable2);
    }

    public final void setFeatureDrawableAlpha(int n, int n2) {
        this.getWindow().setFeatureDrawableAlpha(n, n2);
    }

    public LayoutInflater getLayoutInflater() {
        return this.getWindow().getLayoutInflater();
    }

    public MenuInflater getMenuInflater() {
        return this.mMenuInflater;
    }

    @Override
    protected void onApplyThemeResource(Resources.Theme theme, int n, boolean bl) {
        if (this.mParent == null) {
            super.onApplyThemeResource(theme, n, bl);
        } else {
            try {
                theme.setTo(this.mParent.getTheme());
            }
            catch (Exception exception) {
                // empty catch block
            }
            theme.applyStyle(n, false);
        }
    }

    public void startActivityForResult(Intent intent, int n) {
        this.startActivityForResult(intent, n, null);
    }

    public void startActivityForResult(Intent intent, int n, Bundle bundle) {
    }

    public void startIntentSenderForResult(IntentSender intentSender, int n, Intent intent, int n2, int n3, int n4) throws IntentSender.SendIntentException {
        this.startIntentSenderForResult(intentSender, n, intent, n2, n3, n4, null);
    }

    public void startIntentSenderForResult(IntentSender intentSender, int n, Intent intent, int n2, int n3, int n4, Bundle bundle) throws IntentSender.SendIntentException {
        if (this.mParent == null) {
            this.startIntentSenderForResultInner(intentSender, n, intent, n2, n3, this, bundle);
        } else if (bundle != null) {
            this.mParent.startIntentSenderFromChild(this, intentSender, n, intent, n2, n3, n4, bundle);
        } else {
            this.mParent.startIntentSenderFromChild(this, intentSender, n, intent, n2, n3, n4);
        }
    }

    private void startIntentSenderForResultInner(IntentSender intentSender, int n, Intent intent, int n2, int n3, Activity activity, Bundle bundle) {
    }

    @Override
    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    @Override
    public void startActivity(Intent intent, Bundle bundle) {
        if (bundle != null) {
            this.startActivityForResult(intent, -1, bundle);
        } else {
            this.startActivityForResult(intent, -1);
        }
    }

    @Override
    public void startActivities(Intent[] intentArray) {
        this.startActivities(intentArray, null);
    }

    @Override
    public void startActivities(Intent[] intentArray, Bundle bundle) {
    }

    @Override
    public void startIntentSender(IntentSender intentSender, Intent intent, int n, int n2, int n3) throws IntentSender.SendIntentException {
        this.startIntentSender(intentSender, intent, n, n2, n3, null);
    }

    @Override
    public void startIntentSender(IntentSender intentSender, Intent intent, int n, int n2, int n3, Bundle bundle) throws IntentSender.SendIntentException {
        if (bundle != null) {
            this.startIntentSenderForResult(intentSender, -1, intent, n, n2, n3, bundle);
        } else {
            this.startIntentSenderForResult(intentSender, -1, intent, n, n2, n3);
        }
    }

    public boolean startActivityIfNeeded(Intent intent, int n) {
        return this.startActivityIfNeeded(intent, n, null);
    }

    public boolean startActivityIfNeeded(Intent intent, int n, Bundle bundle) {
        return true;
    }

    public boolean startNextMatchingActivity(Intent intent) {
        return this.startNextMatchingActivity(intent, null);
    }

    public boolean startNextMatchingActivity(Intent intent, Bundle bundle) {
        return true;
    }

    public void startActivityFromChild(Activity activity, Intent intent, int n) {
        this.startActivityFromChild(activity, intent, n, null);
    }

    public void startActivityFromChild(Activity activity, Intent intent, int n, Bundle bundle) {
    }

    public void startActivityFromFragment(Fragment fragment, Intent intent, int n) {
        this.startActivityFromFragment(fragment, intent, n, null);
    }

    public void startActivityFromFragment(Fragment fragment, Intent intent, int n, Bundle bundle) {
    }

    public void startIntentSenderFromChild(Activity activity, IntentSender intentSender, int n, Intent intent, int n2, int n3, int n4) throws IntentSender.SendIntentException {
        this.startIntentSenderFromChild(activity, intentSender, n, intent, n2, n3, n4, null);
    }

    public void startIntentSenderFromChild(Activity activity, IntentSender intentSender, int n, Intent intent, int n2, int n3, int n4, Bundle bundle) throws IntentSender.SendIntentException {
        this.startIntentSenderForResultInner(intentSender, n, intent, n2, n3, activity, bundle);
    }

    public void overridePendingTransition(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(int n) {
        Activity activity = this;
        synchronized (activity) {
            this.mResultCode = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(int n, Intent intent) {
        Activity activity = this;
        synchronized (activity) {
            this.mResultCode = n;
        }
    }

    public String getCallingPackage() {
        return null;
    }

    public ComponentName getCallingActivity() {
        return null;
    }

    public void setVisible(boolean bl) {
        if (this.mVisibleFromClient != bl) {
            this.mVisibleFromClient = bl;
            if (this.mVisibleFromServer) {
                if (bl) {
                    this.makeVisible();
                } else {
                    this.mDecor.setVisibility(4);
                }
            }
        }
    }

    void makeVisible() {
        if (!this.mWindowAdded) {
            WindowManager windowManager = this.getWindowManager();
            windowManager.addView(this.mDecor, this.getWindow().getAttributes());
            this.mWindowAdded = true;
        }
        this.mDecor.setVisibility(0);
    }

    public boolean isFinishing() {
        return this.mFinished;
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public boolean isChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public void recreate() {
    }

    public void finish() {
    }

    public void finishAffinity() {
    }

    public void finishFromChild(Activity activity) {
        this.finish();
    }

    public void finishActivity(int n) {
    }

    public void finishActivityFromChild(Activity activity, int n) {
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
    }

    public PendingIntent createPendingResult(int n, Intent intent, int n2) {
        return null;
    }

    public void setRequestedOrientation(int n) {
    }

    public int getRequestedOrientation() {
        return 0;
    }

    public int getTaskId() {
        return 0;
    }

    public boolean isTaskRoot() {
        return true;
    }

    public boolean moveTaskToBack(boolean bl) {
        return false;
    }

    public String getLocalClassName() {
        String string2 = this.getPackageName();
        String string3 = this.mComponent.getClassName();
        int n = string2.length();
        if (!string3.startsWith(string2) || string3.length() <= n || string3.charAt(n) != '.') {
            return string3;
        }
        return string3.substring(n + 1);
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    public SharedPreferences getPreferences(int n) {
        return this.getSharedPreferences(this.getLocalClassName(), n);
    }

    private void ensureSearchManager() {
    }

    @Override
    public Object getSystemService(String string2) {
        if (this.getBaseContext() == null) {
            throw new IllegalStateException("System services not available to Activities before onCreate()");
        }
        if ("window".equals(string2)) {
            return this.mWindowManager;
        }
        if ("search".equals(string2)) {
            this.ensureSearchManager();
            return this.mSearchManager;
        }
        return super.getSystemService(string2);
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.onTitleChanged(charSequence, this.mTitleColor);
        if (this.mParent != null) {
            this.mParent.onChildTitleChanged(this, charSequence);
        }
    }

    public void setTitle(int n) {
        this.setTitle(this.getText(n));
    }

    public void setTitleColor(int n) {
        this.mTitleColor = n;
        this.onTitleChanged(this.mTitle, n);
    }

    public final CharSequence getTitle() {
        return this.mTitle;
    }

    public final int getTitleColor() {
        return this.mTitleColor;
    }

    protected void onTitleChanged(CharSequence charSequence, int n) {
        Window window;
        if (this.mTitleReady && (window = this.getWindow()) != null) {
            window.setTitle(charSequence);
            if (n != 0) {
                window.setTitleColor(n);
            }
        }
    }

    protected void onChildTitleChanged(Activity activity, CharSequence charSequence) {
    }

    public final void setProgressBarVisibility(boolean bl) {
        this.getWindow().setFeatureInt(2, bl ? -1 : -2);
    }

    public final void setProgressBarIndeterminateVisibility(boolean bl) {
        this.getWindow().setFeatureInt(5, bl ? -1 : -2);
    }

    public final void setProgressBarIndeterminate(boolean bl) {
        this.getWindow().setFeatureInt(2, bl ? -3 : -4);
    }

    public final void setProgress(int n) {
        this.getWindow().setFeatureInt(2, n + 0);
    }

    public final void setSecondaryProgress(int n) {
        this.getWindow().setFeatureInt(2, n + 20000);
    }

    public final void setVolumeControlStream(int n) {
        this.getWindow().setVolumeControlStream(n);
    }

    public final int getVolumeControlStream() {
        return this.getWindow().getVolumeControlStream();
    }

    public final void runOnUiThread(Runnable runnable) {
        if (Thread.currentThread() != this.mUiThread) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        return null;
    }

    @Override
    public View onCreateView(View view, String string2, Context context, AttributeSet attributeSet) {
        return null;
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        this.dumpInner(string2, fileDescriptor, printWriter, stringArray);
    }

    void dumpInner(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.print(string2);
        printWriter.print("Local Activity ");
        printWriter.print(Integer.toHexString(System.identityHashCode(this)));
        printWriter.println(" State:");
        String string3 = string2 + "  ";
        printWriter.print(string3);
        printWriter.print("mResumed=");
        printWriter.print(this.mResumed);
        printWriter.print(" mStopped=");
        printWriter.print(this.mStopped);
        printWriter.print(" mFinished=");
        printWriter.println(this.mFinished);
        printWriter.print(string3);
        printWriter.print("mLoadersStarted=");
        printWriter.println(this.mLoadersStarted);
        printWriter.print(string3);
        printWriter.print("mChangingConfigurations=");
        printWriter.println(this.mChangingConfigurations);
        printWriter.print(string3);
        printWriter.print("mCurrentConfig=");
        printWriter.println(this.mCurrentConfig);
        printWriter.print(string2);
        printWriter.println("View Hierarchy:");
        this.dumpViewHierarchy(string2 + "  ", printWriter, this.getWindow().getDecorView());
    }

    private void dumpViewHierarchy(String string2, PrintWriter printWriter, View view) {
        printWriter.print(string2);
        if (view == null) {
            printWriter.println("null");
            return;
        }
        printWriter.println(view.toString());
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        int n = viewGroup.getChildCount();
        if (n <= 0) {
            return;
        }
        string2 = string2 + "  ";
        for (int i = 0; i < n; ++i) {
            this.dumpViewHierarchy(string2, printWriter, viewGroup.getChildAt(i));
        }
    }

    public boolean isImmersive() {
        return true;
    }

    public void setImmersive(boolean bl) {
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        return this.mWindow.getDecorView().startActionMode(callback);
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return null;
    }

    @Override
    public void onActionModeStarted(ActionMode actionMode) {
    }

    @Override
    public void onActionModeFinished(ActionMode actionMode) {
    }

    public boolean shouldUpRecreateTask(Intent intent) {
        return true;
    }

    public boolean navigateUpTo(Intent intent) {
        return true;
    }

    public boolean navigateUpToFromChild(Activity activity, Intent intent) {
        return this.navigateUpTo(intent);
    }

    public Intent getParentActivityIntent() {
        Intent intent = new Intent();
        intent.setClassName(this, "<ANY_CLASS>");
        return intent;
    }

    final void setParent(Activity activity) {
        this.mParent = activity;
    }

    public final IBinder getActivityToken() {
        return this.mParent != null ? this.mParent.getActivityToken() : this.mToken;
    }

    final void performCreate(Bundle bundle) {
    }

    final void performStart() {
    }

    final void performRestart() {
    }

    final void performResume() {
    }

    final void performPause() {
    }

    final void performUserLeaving() {
        this.onUserInteraction();
        this.onUserLeaveHint();
    }

    final void performStop() {
    }

    final void performDestroy() {
    }

    public final boolean isResumed() {
        return this.mResumed;
    }

    void dispatchActivityResult(String string2, int n, int n2, Intent intent) {
    }

    private static final class ManagedCursor {
        private final Cursor mCursor;
        private boolean mReleased;
        private boolean mUpdated;

        ManagedCursor(Cursor cursor) {
            this.mCursor = cursor;
            this.mReleased = false;
            this.mUpdated = false;
        }
    }

    static final class NonConfigurationInstances {
        Object activity;
        HashMap<String, Object> children;
        ArrayList<Fragment> fragments;

        NonConfigurationInstances() {
        }
    }

    private static class ManagedDialog {
        Dialog mDialog;
        Bundle mArgs;

        private ManagedDialog() {
        }
    }
}

