/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Intent
implements Parcelable,
Cloneable {
    public static final String ACTION_MAIN = "android.intent.action.MAIN";
    public static final String ACTION_VIEW = "android.intent.action.VIEW";
    public static final String ACTION_DEFAULT = "android.intent.action.VIEW";
    public static final String ACTION_ATTACH_DATA = "android.intent.action.ATTACH_DATA";
    public static final String ACTION_EDIT = "android.intent.action.EDIT";
    public static final String ACTION_INSERT_OR_EDIT = "android.intent.action.INSERT_OR_EDIT";
    public static final String ACTION_PICK = "android.intent.action.PICK";
    public static final String ACTION_CREATE_SHORTCUT = "android.intent.action.CREATE_SHORTCUT";
    public static final String EXTRA_SHORTCUT_INTENT = "android.intent.extra.shortcut.INTENT";
    public static final String EXTRA_SHORTCUT_NAME = "android.intent.extra.shortcut.NAME";
    public static final String EXTRA_SHORTCUT_ICON = "android.intent.extra.shortcut.ICON";
    public static final String EXTRA_SHORTCUT_ICON_RESOURCE = "android.intent.extra.shortcut.ICON_RESOURCE";
    public static final String ACTION_CHOOSER = "android.intent.action.CHOOSER";
    public static final String ACTION_GET_CONTENT = "android.intent.action.GET_CONTENT";
    public static final String ACTION_DIAL = "android.intent.action.DIAL";
    public static final String ACTION_CALL = "android.intent.action.CALL";
    public static final String ACTION_CALL_EMERGENCY = "android.intent.action.CALL_EMERGENCY";
    public static final String ACTION_CALL_PRIVILEGED = "android.intent.action.CALL_PRIVILEGED";
    public static final String ACTION_SENDTO = "android.intent.action.SENDTO";
    public static final String ACTION_SEND = "android.intent.action.SEND";
    public static final String ACTION_SEND_MULTIPLE = "android.intent.action.SEND_MULTIPLE";
    public static final String ACTION_ANSWER = "android.intent.action.ANSWER";
    public static final String ACTION_INSERT = "android.intent.action.INSERT";
    public static final String ACTION_PASTE = "android.intent.action.PASTE";
    public static final String ACTION_DELETE = "android.intent.action.DELETE";
    public static final String ACTION_RUN = "android.intent.action.RUN";
    public static final String ACTION_SYNC = "android.intent.action.SYNC";
    public static final String ACTION_PICK_ACTIVITY = "android.intent.action.PICK_ACTIVITY";
    public static final String ACTION_SEARCH = "android.intent.action.SEARCH";
    public static final String ACTION_SYSTEM_TUTORIAL = "android.intent.action.SYSTEM_TUTORIAL";
    public static final String ACTION_WEB_SEARCH = "android.intent.action.WEB_SEARCH";
    public static final String ACTION_ASSIST = "android.intent.action.ASSIST";
    public static final String ACTION_ALL_APPS = "android.intent.action.ALL_APPS";
    public static final String ACTION_SET_WALLPAPER = "android.intent.action.SET_WALLPAPER";
    public static final String ACTION_BUG_REPORT = "android.intent.action.BUG_REPORT";
    public static final String ACTION_FACTORY_TEST = "android.intent.action.FACTORY_TEST";
    public static final String ACTION_CALL_BUTTON = "android.intent.action.CALL_BUTTON";
    public static final String ACTION_VOICE_COMMAND = "android.intent.action.VOICE_COMMAND";
    public static final String ACTION_SEARCH_LONG_PRESS = "android.intent.action.SEARCH_LONG_PRESS";
    public static final String ACTION_APP_ERROR = "android.intent.action.APP_ERROR";
    public static final String ACTION_POWER_USAGE_SUMMARY = "android.intent.action.POWER_USAGE_SUMMARY";
    public static final String ACTION_UPGRADE_SETUP = "android.intent.action.UPGRADE_SETUP";
    public static final String ACTION_MANAGE_NETWORK_USAGE = "android.intent.action.MANAGE_NETWORK_USAGE";
    public static final String ACTION_INSTALL_PACKAGE = "android.intent.action.INSTALL_PACKAGE";
    public static final String EXTRA_INSTALLER_PACKAGE_NAME = "android.intent.extra.INSTALLER_PACKAGE_NAME";
    public static final String EXTRA_NOT_UNKNOWN_SOURCE = "android.intent.extra.NOT_UNKNOWN_SOURCE";
    @Deprecated
    public static final String EXTRA_ALLOW_REPLACE = "android.intent.extra.ALLOW_REPLACE";
    public static final String EXTRA_RETURN_RESULT = "android.intent.extra.RETURN_RESULT";
    public static final String EXTRA_INSTALL_RESULT = "android.intent.extra.INSTALL_RESULT";
    public static final String ACTION_UNINSTALL_PACKAGE = "android.intent.action.UNINSTALL_PACKAGE";
    public static final String METADATA_SETUP_VERSION = "android.SETUP_VERSION";
    public static final String ACTION_SCREEN_OFF = "android.intent.action.SCREEN_OFF";
    public static final String ACTION_SCREEN_ON = "android.intent.action.SCREEN_ON";
    public static final String ACTION_USER_PRESENT = "android.intent.action.USER_PRESENT";
    public static final String ACTION_TIME_TICK = "android.intent.action.TIME_TICK";
    public static final String ACTION_TIME_CHANGED = "android.intent.action.TIME_SET";
    public static final String ACTION_DATE_CHANGED = "android.intent.action.DATE_CHANGED";
    public static final String ACTION_TIMEZONE_CHANGED = "android.intent.action.TIMEZONE_CHANGED";
    public static final String ACTION_CLEAR_DNS_CACHE = "android.intent.action.CLEAR_DNS_CACHE";
    public static final String ACTION_ALARM_CHANGED = "android.intent.action.ALARM_CHANGED";
    public static final String ACTION_SYNC_STATE_CHANGED = "android.intent.action.SYNC_STATE_CHANGED";
    public static final String ACTION_BOOT_COMPLETED = "android.intent.action.BOOT_COMPLETED";
    public static final String ACTION_CLOSE_SYSTEM_DIALOGS = "android.intent.action.CLOSE_SYSTEM_DIALOGS";
    @Deprecated
    public static final String ACTION_PACKAGE_INSTALL = "android.intent.action.PACKAGE_INSTALL";
    public static final String ACTION_PACKAGE_ADDED = "android.intent.action.PACKAGE_ADDED";
    public static final String ACTION_PACKAGE_REPLACED = "android.intent.action.PACKAGE_REPLACED";
    public static final String ACTION_MY_PACKAGE_REPLACED = "android.intent.action.MY_PACKAGE_REPLACED";
    public static final String ACTION_PACKAGE_REMOVED = "android.intent.action.PACKAGE_REMOVED";
    public static final String ACTION_PACKAGE_FULLY_REMOVED = "android.intent.action.PACKAGE_FULLY_REMOVED";
    public static final String ACTION_PACKAGE_CHANGED = "android.intent.action.PACKAGE_CHANGED";
    public static final String ACTION_QUERY_PACKAGE_RESTART = "android.intent.action.QUERY_PACKAGE_RESTART";
    public static final String ACTION_PACKAGE_RESTARTED = "android.intent.action.PACKAGE_RESTARTED";
    public static final String ACTION_PACKAGE_DATA_CLEARED = "android.intent.action.PACKAGE_DATA_CLEARED";
    public static final String ACTION_UID_REMOVED = "android.intent.action.UID_REMOVED";
    public static final String ACTION_PACKAGE_FIRST_LAUNCH = "android.intent.action.PACKAGE_FIRST_LAUNCH";
    public static final String ACTION_PACKAGE_NEEDS_VERIFICATION = "android.intent.action.PACKAGE_NEEDS_VERIFICATION";
    public static final String ACTION_EXTERNAL_APPLICATIONS_AVAILABLE = "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE";
    public static final String ACTION_EXTERNAL_APPLICATIONS_UNAVAILABLE = "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
    public static final String ACTION_WALLPAPER_CHANGED = "android.intent.action.WALLPAPER_CHANGED";
    public static final String ACTION_CONFIGURATION_CHANGED = "android.intent.action.CONFIGURATION_CHANGED";
    public static final String ACTION_LOCALE_CHANGED = "android.intent.action.LOCALE_CHANGED";
    public static final String ACTION_BATTERY_CHANGED = "android.intent.action.BATTERY_CHANGED";
    public static final String ACTION_BATTERY_LOW = "android.intent.action.BATTERY_LOW";
    public static final String ACTION_BATTERY_OKAY = "android.intent.action.BATTERY_OKAY";
    public static final String ACTION_POWER_CONNECTED = "android.intent.action.ACTION_POWER_CONNECTED";
    public static final String ACTION_POWER_DISCONNECTED = "android.intent.action.ACTION_POWER_DISCONNECTED";
    public static final String ACTION_SHUTDOWN = "android.intent.action.ACTION_SHUTDOWN";
    public static final String ACTION_REQUEST_SHUTDOWN = "android.intent.action.ACTION_REQUEST_SHUTDOWN";
    public static final String ACTION_DEVICE_STORAGE_LOW = "android.intent.action.DEVICE_STORAGE_LOW";
    public static final String ACTION_DEVICE_STORAGE_OK = "android.intent.action.DEVICE_STORAGE_OK";
    public static final String ACTION_DEVICE_STORAGE_FULL = "android.intent.action.DEVICE_STORAGE_FULL";
    public static final String ACTION_DEVICE_STORAGE_NOT_FULL = "android.intent.action.DEVICE_STORAGE_NOT_FULL";
    public static final String ACTION_MANAGE_PACKAGE_STORAGE = "android.intent.action.MANAGE_PACKAGE_STORAGE";
    @Deprecated
    public static final String ACTION_UMS_CONNECTED = "android.intent.action.UMS_CONNECTED";
    @Deprecated
    public static final String ACTION_UMS_DISCONNECTED = "android.intent.action.UMS_DISCONNECTED";
    public static final String ACTION_MEDIA_REMOVED = "android.intent.action.MEDIA_REMOVED";
    public static final String ACTION_MEDIA_UNMOUNTED = "android.intent.action.MEDIA_UNMOUNTED";
    public static final String ACTION_MEDIA_CHECKING = "android.intent.action.MEDIA_CHECKING";
    public static final String ACTION_MEDIA_NOFS = "android.intent.action.MEDIA_NOFS";
    public static final String ACTION_MEDIA_MOUNTED = "android.intent.action.MEDIA_MOUNTED";
    public static final String ACTION_MEDIA_SHARED = "android.intent.action.MEDIA_SHARED";
    public static final String ACTION_MEDIA_UNSHARED = "android.intent.action.MEDIA_UNSHARED";
    public static final String ACTION_MEDIA_BAD_REMOVAL = "android.intent.action.MEDIA_BAD_REMOVAL";
    public static final String ACTION_MEDIA_UNMOUNTABLE = "android.intent.action.MEDIA_UNMOUNTABLE";
    public static final String ACTION_MEDIA_EJECT = "android.intent.action.MEDIA_EJECT";
    public static final String ACTION_MEDIA_SCANNER_STARTED = "android.intent.action.MEDIA_SCANNER_STARTED";
    public static final String ACTION_MEDIA_SCANNER_FINISHED = "android.intent.action.MEDIA_SCANNER_FINISHED";
    public static final String ACTION_MEDIA_SCANNER_SCAN_FILE = "android.intent.action.MEDIA_SCANNER_SCAN_FILE";
    public static final String ACTION_MEDIA_BUTTON = "android.intent.action.MEDIA_BUTTON";
    public static final String ACTION_CAMERA_BUTTON = "android.intent.action.CAMERA_BUTTON";
    public static final String ACTION_GTALK_SERVICE_CONNECTED = "android.intent.action.GTALK_CONNECTED";
    public static final String ACTION_GTALK_SERVICE_DISCONNECTED = "android.intent.action.GTALK_DISCONNECTED";
    public static final String ACTION_INPUT_METHOD_CHANGED = "android.intent.action.INPUT_METHOD_CHANGED";
    public static final String ACTION_AIRPLANE_MODE_CHANGED = "android.intent.action.AIRPLANE_MODE";
    public static final String ACTION_PROVIDER_CHANGED = "android.intent.action.PROVIDER_CHANGED";
    public static final String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    public static final String ACTION_ANALOG_AUDIO_DOCK_PLUG = "android.intent.action.ANALOG_AUDIO_DOCK_PLUG";
    public static final String ACTION_DIGITAL_AUDIO_DOCK_PLUG = "android.intent.action.DIGITAL_AUDIO_DOCK_PLUG";
    public static final String ACTION_HDMI_AUDIO_PLUG = "android.intent.action.HDMI_AUDIO_PLUG";
    public static final String ACTION_USB_AUDIO_ACCESSORY_PLUG = "android.intent.action.USB_AUDIO_ACCESSORY_PLUG";
    public static final String ACTION_USB_AUDIO_DEVICE_PLUG = "android.intent.action.USB_AUDIO_DEVICE_PLUG";
    public static final String ACTION_ADVANCED_SETTINGS_CHANGED = "android.intent.action.ADVANCED_SETTINGS";
    public static final String ACTION_NEW_OUTGOING_CALL = "android.intent.action.NEW_OUTGOING_CALL";
    public static final String ACTION_REBOOT = "android.intent.action.REBOOT";
    public static final String ACTION_DOCK_EVENT = "android.intent.action.DOCK_EVENT";
    public static final String ACTION_REMOTE_INTENT = "com.google.android.c2dm.intent.RECEIVE";
    public static final String ACTION_PRE_BOOT_COMPLETED = "android.intent.action.PRE_BOOT_COMPLETED";
    public static final String ACTION_USER_ADDED = "android.intent.action.USER_ADDED";
    public static final String ACTION_USER_REMOVED = "android.intent.action.USER_REMOVED";
    public static final String ACTION_USER_SWITCHED = "android.intent.action.USER_SWITCHED";
    public static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    public static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    public static final String CATEGORY_ALTERNATIVE = "android.intent.category.ALTERNATIVE";
    public static final String CATEGORY_SELECTED_ALTERNATIVE = "android.intent.category.SELECTED_ALTERNATIVE";
    public static final String CATEGORY_TAB = "android.intent.category.TAB";
    public static final String CATEGORY_LAUNCHER = "android.intent.category.LAUNCHER";
    public static final String CATEGORY_INFO = "android.intent.category.INFO";
    public static final String CATEGORY_HOME = "android.intent.category.HOME";
    public static final String CATEGORY_PREFERENCE = "android.intent.category.PREFERENCE";
    public static final String CATEGORY_DEVELOPMENT_PREFERENCE = "android.intent.category.DEVELOPMENT_PREFERENCE";
    public static final String CATEGORY_EMBED = "android.intent.category.EMBED";
    public static final String CATEGORY_APP_MARKET = "android.intent.category.APP_MARKET";
    public static final String CATEGORY_MONKEY = "android.intent.category.MONKEY";
    public static final String CATEGORY_TEST = "android.intent.category.TEST";
    public static final String CATEGORY_UNIT_TEST = "android.intent.category.UNIT_TEST";
    public static final String CATEGORY_SAMPLE_CODE = "android.intent.category.SAMPLE_CODE";
    public static final String CATEGORY_OPENABLE = "android.intent.category.OPENABLE";
    public static final String CATEGORY_FRAMEWORK_INSTRUMENTATION_TEST = "android.intent.category.FRAMEWORK_INSTRUMENTATION_TEST";
    public static final String CATEGORY_CAR_DOCK = "android.intent.category.CAR_DOCK";
    public static final String CATEGORY_DESK_DOCK = "android.intent.category.DESK_DOCK";
    public static final String CATEGORY_LE_DESK_DOCK = "android.intent.category.LE_DESK_DOCK";
    public static final String CATEGORY_HE_DESK_DOCK = "android.intent.category.HE_DESK_DOCK";
    public static final String CATEGORY_CAR_MODE = "android.intent.category.CAR_MODE";
    public static final String CATEGORY_APP_BROWSER = "android.intent.category.APP_BROWSER";
    public static final String CATEGORY_APP_CALCULATOR = "android.intent.category.APP_CALCULATOR";
    public static final String CATEGORY_APP_CALENDAR = "android.intent.category.APP_CALENDAR";
    public static final String CATEGORY_APP_CONTACTS = "android.intent.category.APP_CONTACTS";
    public static final String CATEGORY_APP_EMAIL = "android.intent.category.APP_EMAIL";
    public static final String CATEGORY_APP_GALLERY = "android.intent.category.APP_GALLERY";
    public static final String CATEGORY_APP_MAPS = "android.intent.category.APP_MAPS";
    public static final String CATEGORY_APP_MESSAGING = "android.intent.category.APP_MESSAGING";
    public static final String CATEGORY_APP_MUSIC = "android.intent.category.APP_MUSIC";
    public static final String EXTRA_TEMPLATE = "android.intent.extra.TEMPLATE";
    public static final String EXTRA_TEXT = "android.intent.extra.TEXT";
    public static final String EXTRA_HTML_TEXT = "android.intent.extra.HTML_TEXT";
    public static final String EXTRA_STREAM = "android.intent.extra.STREAM";
    public static final String EXTRA_EMAIL = "android.intent.extra.EMAIL";
    public static final String EXTRA_CC = "android.intent.extra.CC";
    public static final String EXTRA_BCC = "android.intent.extra.BCC";
    public static final String EXTRA_SUBJECT = "android.intent.extra.SUBJECT";
    public static final String EXTRA_INTENT = "android.intent.extra.INTENT";
    public static final String EXTRA_TITLE = "android.intent.extra.TITLE";
    public static final String EXTRA_INITIAL_INTENTS = "android.intent.extra.INITIAL_INTENTS";
    public static final String EXTRA_KEY_EVENT = "android.intent.extra.KEY_EVENT";
    public static final String EXTRA_KEY_CONFIRM = "android.intent.extra.KEY_CONFIRM";
    public static final String EXTRA_DONT_KILL_APP = "android.intent.extra.DONT_KILL_APP";
    public static final String EXTRA_PHONE_NUMBER = "android.intent.extra.PHONE_NUMBER";
    public static final String EXTRA_UID = "android.intent.extra.UID";
    public static final String EXTRA_PACKAGES = "android.intent.extra.PACKAGES";
    public static final String EXTRA_DATA_REMOVED = "android.intent.extra.DATA_REMOVED";
    public static final String EXTRA_REPLACING = "android.intent.extra.REPLACING";
    public static final String EXTRA_ALARM_COUNT = "android.intent.extra.ALARM_COUNT";
    public static final String EXTRA_DOCK_STATE = "android.intent.extra.DOCK_STATE";
    public static final int EXTRA_DOCK_STATE_UNDOCKED = 0;
    public static final int EXTRA_DOCK_STATE_DESK = 1;
    public static final int EXTRA_DOCK_STATE_CAR = 2;
    public static final int EXTRA_DOCK_STATE_LE_DESK = 3;
    public static final int EXTRA_DOCK_STATE_HE_DESK = 4;
    public static final String METADATA_DOCK_HOME = "android.dock_home";
    public static final String EXTRA_BUG_REPORT = "android.intent.extra.BUG_REPORT";
    public static final String EXTRA_REMOTE_INTENT_TOKEN = "android.intent.extra.remote_intent_token";
    @Deprecated
    public static final String EXTRA_CHANGED_COMPONENT_NAME = "android.intent.extra.changed_component_name";
    public static final String EXTRA_CHANGED_COMPONENT_NAME_LIST = "android.intent.extra.changed_component_name_list";
    public static final String EXTRA_CHANGED_PACKAGE_LIST = "android.intent.extra.changed_package_list";
    public static final String EXTRA_CHANGED_UID_LIST = "android.intent.extra.changed_uid_list";
    public static final String EXTRA_CLIENT_LABEL = "android.intent.extra.client_label";
    public static final String EXTRA_CLIENT_INTENT = "android.intent.extra.client_intent";
    public static final String EXTRA_LOCAL_ONLY = "android.intent.extra.LOCAL_ONLY";
    public static final String EXTRA_USERID = "android.intent.extra.user_id";
    public static final int FLAG_GRANT_READ_URI_PERMISSION = 1;
    public static final int FLAG_GRANT_WRITE_URI_PERMISSION = 2;
    public static final int FLAG_FROM_BACKGROUND = 4;
    public static final int FLAG_DEBUG_LOG_RESOLUTION = 8;
    public static final int FLAG_EXCLUDE_STOPPED_PACKAGES = 16;
    public static final int FLAG_INCLUDE_STOPPED_PACKAGES = 32;
    public static final int FLAG_ACTIVITY_NO_HISTORY = 0x40000000;
    public static final int FLAG_ACTIVITY_SINGLE_TOP = 0x20000000;
    public static final int FLAG_ACTIVITY_NEW_TASK = 0x10000000;
    public static final int FLAG_ACTIVITY_MULTIPLE_TASK = 0x8000000;
    public static final int FLAG_ACTIVITY_CLEAR_TOP = 0x4000000;
    public static final int FLAG_ACTIVITY_FORWARD_RESULT = 0x2000000;
    public static final int FLAG_ACTIVITY_PREVIOUS_IS_TOP = 0x1000000;
    public static final int FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS = 0x800000;
    public static final int FLAG_ACTIVITY_BROUGHT_TO_FRONT = 0x400000;
    public static final int FLAG_ACTIVITY_RESET_TASK_IF_NEEDED = 0x200000;
    public static final int FLAG_ACTIVITY_LAUNCHED_FROM_HISTORY = 0x100000;
    public static final int FLAG_ACTIVITY_CLEAR_WHEN_TASK_RESET = 524288;
    public static final int FLAG_ACTIVITY_NO_USER_ACTION = 262144;
    public static final int FLAG_ACTIVITY_REORDER_TO_FRONT = 131072;
    public static final int FLAG_ACTIVITY_NO_ANIMATION = 65536;
    public static final int FLAG_ACTIVITY_CLEAR_TASK = 32768;
    public static final int FLAG_ACTIVITY_TASK_ON_HOME = 16384;
    public static final int FLAG_RECEIVER_REGISTERED_ONLY = 0x40000000;
    public static final int FLAG_RECEIVER_REPLACE_PENDING = 0x20000000;
    public static final int FLAG_RECEIVER_FOREGROUND = 0x10000000;
    public static final int FLAG_RECEIVER_REGISTERED_ONLY_BEFORE_BOOT = 0x8000000;
    public static final int FLAG_RECEIVER_BOOT_UPGRADE = 0x4000000;
    public static final int IMMUTABLE_FLAGS = 3;
    public static final int URI_INTENT_SCHEME = 1;
    private String mAction;
    private Uri mData;
    private String mType;
    private String mPackage;
    private ComponentName mComponent;
    private int mFlags;
    private HashSet<String> mCategories;
    private Rect mSourceBounds;
    private Intent mSelector;
    private ClipData mClipData;
    public static final int FILL_IN_ACTION = 1;
    public static final int FILL_IN_DATA = 2;
    public static final int FILL_IN_CATEGORIES = 4;
    public static final int FILL_IN_COMPONENT = 8;
    public static final int FILL_IN_PACKAGE = 16;
    public static final int FILL_IN_SOURCE_BOUNDS = 32;
    public static final int FILL_IN_SELECTOR = 64;
    public static final int FILL_IN_CLIP_DATA = 128;
    public static final Parcelable.Creator<Intent> CREATOR = new Parcelable.Creator<Intent>(){

        @Override
        public Intent createFromParcel(Parcel parcel) {
            return new Intent(parcel);
        }

        public Intent[] newArray(int n) {
            return new Intent[n];
        }
    };

    public static Intent createChooser(Intent intent, CharSequence charSequence) {
        int n;
        Intent intent2 = new Intent(ACTION_CHOOSER);
        intent2.putExtra(EXTRA_INTENT, intent);
        if (charSequence != null) {
            intent2.putExtra(EXTRA_TITLE, charSequence);
        }
        if ((n = intent.getFlags() & 3) != 0) {
            ClipData clipData = intent.getClipData();
            if (clipData == null && intent.getData() != null) {
                ClipData.Item item = new ClipData.Item(intent.getData());
                String[] stringArray = intent.getType() != null ? new String[]{intent.getType()} : new String[]{};
                clipData = new ClipData(null, stringArray, item);
            }
            if (clipData != null) {
                intent2.setClipData(clipData);
                intent2.addFlags(n);
            }
        }
        return intent2;
    }

    public Intent() {
    }

    public Intent(Intent intent) {
        this.mAction = intent.mAction;
        this.mData = intent.mData;
        this.mType = intent.mType;
        this.mPackage = intent.mPackage;
        this.mComponent = intent.mComponent;
        this.mFlags = intent.mFlags;
        if (intent.mCategories != null) {
            this.mCategories = new HashSet<String>(intent.mCategories);
        }
        if (intent.mSourceBounds != null) {
            this.mSourceBounds = new Rect(intent.mSourceBounds);
        }
        if (intent.mSelector != null) {
            this.mSelector = new Intent(intent.mSelector);
        }
        if (intent.mClipData != null) {
            this.mClipData = new ClipData(intent.mClipData);
        }
    }

    public Object clone() {
        return new Intent(this);
    }

    private Intent(Intent intent, boolean bl) {
        this.mAction = intent.mAction;
        this.mData = intent.mData;
        this.mType = intent.mType;
        this.mPackage = intent.mPackage;
        this.mComponent = intent.mComponent;
        if (intent.mCategories != null) {
            this.mCategories = new HashSet<String>(intent.mCategories);
        }
    }

    public Intent cloneFilter() {
        return new Intent(this, false);
    }

    public Intent(String string2) {
        this.setAction(string2);
    }

    public Intent(String string2, Uri uri) {
        this.setAction(string2);
        this.mData = uri;
    }

    public Intent(Context context, Class<?> clazz) {
        this.mComponent = new ComponentName(context, clazz);
    }

    public Intent(String string2, Uri uri, Context context, Class<?> clazz) {
        this.setAction(string2);
        this.mData = uri;
        this.mComponent = new ComponentName(context, clazz);
    }

    public static Intent makeMainActivity(ComponentName componentName) {
        Intent intent = new Intent(ACTION_MAIN);
        intent.setComponent(componentName);
        intent.addCategory(CATEGORY_LAUNCHER);
        return intent;
    }

    public static Intent makeMainSelectorActivity(String string2, String string3) {
        Intent intent = new Intent(ACTION_MAIN);
        intent.addCategory(CATEGORY_LAUNCHER);
        Intent intent2 = new Intent();
        intent2.setAction(string2);
        intent2.addCategory(string3);
        intent.setSelector(intent2);
        return intent;
    }

    public static Intent makeRestartActivityTask(ComponentName componentName) {
        Intent intent = Intent.makeMainActivity(componentName);
        intent.addFlags(0x10008000);
        return intent;
    }

    @Deprecated
    public static Intent getIntent(String string2) throws URISyntaxException {
        return Intent.parseUri(string2, 0);
    }

    public static Intent parseUri(String string2, int n) throws URISyntaxException {
        int n2 = 0;
        try {
            Intent intent;
            if ((n & 1) != 0 && !string2.startsWith("intent:")) {
                Intent intent2 = new Intent("android.intent.action.VIEW");
                try {
                    intent2.setData(Uri.parse(string2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new URISyntaxException(string2, illegalArgumentException.getMessage());
                }
                return intent2;
            }
            n2 = string2.lastIndexOf("#");
            if (n2 == -1) {
                return new Intent("android.intent.action.VIEW", Uri.parse(string2));
            }
            if (!string2.startsWith("#Intent;", n2)) {
                return Intent.getIntentOld(string2);
            }
            Intent intent3 = intent = new Intent("android.intent.action.VIEW");
            String string3 = n2 >= 0 ? string2.substring(0, n2) : null;
            String string4 = null;
            n2 += "#Intent;".length();
            while (!string2.startsWith("end", n2)) {
                int n3;
                String string5;
                int n4 = string2.indexOf(61, n2);
                if (n4 < 0) {
                    n4 = n2 - 1;
                }
                String string6 = string5 = n4 < (n3 = string2.indexOf(59, n2)) ? Uri.decode(string2.substring(n4 + 1, n3)) : "";
                if (string2.startsWith("action=", n2)) {
                    intent.setAction(string5);
                } else if (string2.startsWith("category=", n2)) {
                    intent.addCategory(string5);
                } else if (string2.startsWith("type=", n2)) {
                    intent.mType = string5;
                } else if (string2.startsWith("launchFlags=", n2)) {
                    intent.mFlags = Integer.decode(string5);
                } else if (string2.startsWith("package=", n2)) {
                    intent.mPackage = string5;
                } else if (string2.startsWith("component=", n2)) {
                    intent.mComponent = ComponentName.unflattenFromString(string5);
                } else if (string2.startsWith("scheme=", n2)) {
                    string4 = string5;
                } else if (string2.startsWith("sourceBounds=", n2)) {
                    intent.mSourceBounds = Rect.unflattenFromString(string5);
                } else if (n3 == n2 + 3 && string2.startsWith("SEL", n2)) {
                    intent = new Intent();
                }
                n2 = n3 + 1;
            }
            if (intent != intent3) {
                intent3.setSelector(intent);
                intent = intent3;
            }
            if (string3 != null) {
                if (string3.startsWith("intent:")) {
                    string3 = string3.substring(7);
                    if (string4 != null) {
                        string3 = string4 + ':' + string3;
                    }
                }
                if (string3.length() > 0) {
                    try {
                        intent.mData = Uri.parse(string3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new URISyntaxException(string2, illegalArgumentException.getMessage());
                    }
                }
            }
            return intent;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new URISyntaxException(string2, "illegal Intent URI format", n2);
        }
    }

    public static Intent getIntentOld(String string2) throws URISyntaxException {
        Intent intent;
        int n = string2.lastIndexOf(35);
        if (n >= 0) {
            String string3;
            int n2;
            int n3;
            String string4 = null;
            int n4 = n++;
            boolean bl = false;
            if (string2.regionMatches(n, "action(", 0, 7)) {
                bl = true;
                n3 = string2.indexOf(41, n += 7);
                string4 = string2.substring(n, n3);
                n = n3 + 1;
            }
            intent = new Intent(string4);
            if (string2.regionMatches(n, "categories(", 0, 11)) {
                bl = true;
                n3 = string2.indexOf(41, n += 11);
                while (n < n3) {
                    n2 = string2.indexOf(33, n);
                    if (n2 < 0) {
                        n2 = n3;
                    }
                    if (n < n2) {
                        intent.addCategory(string2.substring(n, n2));
                    }
                    n = n2 + 1;
                }
                n = n3 + 1;
            }
            if (string2.regionMatches(n, "type(", 0, 5)) {
                bl = true;
                n3 = string2.indexOf(41, n += 5);
                intent.mType = string2.substring(n, n3);
                n = n3 + 1;
            }
            if (string2.regionMatches(n, "launchFlags(", 0, 12)) {
                bl = true;
                n3 = string2.indexOf(41, n += 12);
                intent.mFlags = Integer.decode(string2.substring(n, n3));
                n = n3 + 1;
            }
            if (string2.regionMatches(n, "component(", 0, 10)) {
                bl = true;
                n3 = string2.indexOf(41, n += 10);
                n2 = string2.indexOf(33, n);
                if (n2 >= 0 && n2 < n3) {
                    String string5 = string2.substring(n, n2);
                    string3 = string2.substring(n2 + 1, n3);
                    intent.mComponent = new ComponentName(string5, string3);
                }
                n = n3 + 1;
            }
            if (string2.regionMatches(n, "extras(", 0, 7)) {
                bl = true;
                n3 = string2.indexOf(41, n += 7);
                if (n3 == -1) {
                    throw new URISyntaxException(string2, "EXTRA missing trailing ')'", n);
                }
                while (n < n3) {
                    n2 = string2.indexOf(61, n);
                    if (n2 <= n + 1 || n >= n3) {
                        throw new URISyntaxException(string2, "EXTRA missing '='", n);
                    }
                    char c = string2.charAt(n);
                    string3 = string2.substring(++n, n2);
                    n = n2 + 1;
                    if ((n2 = string2.indexOf(33, n)) == -1 || n2 >= n3) {
                        n2 = n3;
                    }
                    if (n >= n2) {
                        throw new URISyntaxException(string2, "EXTRA missing '!'", n);
                    }
                    String string6 = string2.substring(n, n2);
                    n = n2;
                    char c2 = string2.charAt(n);
                    if (c2 == ')') break;
                    if (c2 != '!') {
                        throw new URISyntaxException(string2, "EXTRA missing '!'", n);
                    }
                    ++n;
                }
            }
            intent.mData = bl ? Uri.parse(string2.substring(0, n4)) : Uri.parse(string2);
            if (intent.mAction == null) {
                intent.mAction = "android.intent.action.VIEW";
            }
        } else {
            intent = new Intent("android.intent.action.VIEW", Uri.parse(string2));
        }
        return intent;
    }

    public String getAction() {
        return this.mAction;
    }

    public Uri getData() {
        return this.mData;
    }

    public String getDataString() {
        return this.mData != null ? this.mData.toString() : null;
    }

    public String getScheme() {
        return this.mData != null ? this.mData.getScheme() : null;
    }

    public String getType() {
        return this.mType;
    }

    public String resolveType(Context context) {
        return this.resolveType(context.getContentResolver());
    }

    public String resolveType(ContentResolver contentResolver) {
        if (this.mType != null) {
            return this.mType;
        }
        if (this.mData != null && "content".equals(this.mData.getScheme())) {
            return contentResolver.getType(this.mData);
        }
        return null;
    }

    public String resolveTypeIfNeeded(ContentResolver contentResolver) {
        if (this.mComponent != null) {
            return this.mType;
        }
        return this.resolveType(contentResolver);
    }

    public boolean hasCategory(String string2) {
        return this.mCategories != null && this.mCategories.contains(string2);
    }

    public Set<String> getCategories() {
        return this.mCategories;
    }

    public Intent getSelector() {
        return this.mSelector;
    }

    public ClipData getClipData() {
        return this.mClipData;
    }

    public void setExtrasClassLoader(ClassLoader classLoader) {
    }

    public boolean hasExtra(String string2) {
        return true;
    }

    public boolean hasFileDescriptors() {
        return true;
    }

    public void setAllowFds(boolean bl) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public Object getExtra(String string2) {
        return this.getExtra(string2, null);
    }

    public boolean getBooleanExtra(String string2, boolean bl) {
        return true;
    }

    public byte getByteExtra(String string2, byte by) {
        return 1;
    }

    public short getShortExtra(String string2, short s) {
        return 1;
    }

    public char getCharExtra(String string2, char c) {
        return '\u0001';
    }

    public int getIntExtra(String string2, int n) {
        return 1;
    }

    public long getLongExtra(String string2, long l) {
        return 1L;
    }

    public float getFloatExtra(String string2, float f) {
        return 1.0f;
    }

    public double getDoubleExtra(String string2, double d) {
        return 1.0;
    }

    public String getStringExtra(String string2) {
        return null;
    }

    public CharSequence getCharSequenceExtra(String string2) {
        return null;
    }

    public <T extends Parcelable> T getParcelableExtra(String string2) {
        return null;
    }

    public Parcelable[] getParcelableArrayExtra(String string2) {
        return null;
    }

    public <T extends Parcelable> ArrayList<T> getParcelableArrayListExtra(String string2) {
        return null;
    }

    public Serializable getSerializableExtra(String string2) {
        return null;
    }

    public ArrayList<Integer> getIntegerArrayListExtra(String string2) {
        return null;
    }

    public ArrayList<String> getStringArrayListExtra(String string2) {
        return null;
    }

    public ArrayList<CharSequence> getCharSequenceArrayListExtra(String string2) {
        return null;
    }

    public boolean[] getBooleanArrayExtra(String string2) {
        return null;
    }

    public byte[] getByteArrayExtra(String string2) {
        return null;
    }

    public short[] getShortArrayExtra(String string2) {
        return null;
    }

    public char[] getCharArrayExtra(String string2) {
        return null;
    }

    public int[] getIntArrayExtra(String string2) {
        return null;
    }

    public long[] getLongArrayExtra(String string2) {
        return null;
    }

    public float[] getFloatArrayExtra(String string2) {
        return null;
    }

    public double[] getDoubleArrayExtra(String string2) {
        return null;
    }

    public String[] getStringArrayExtra(String string2) {
        return null;
    }

    public CharSequence[] getCharSequenceArrayExtra(String string2) {
        return null;
    }

    public Bundle getBundleExtra(String string2) {
        return null;
    }

    @Deprecated
    public IBinder getIBinderExtra(String string2) {
        return null;
    }

    @Deprecated
    public Object getExtra(String string2, Object object) {
        return null;
    }

    public Bundle getExtras() {
        return null;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean isExcludingStopped() {
        return (this.mFlags & 0x30) == 16;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public ComponentName getComponent() {
        return this.mComponent;
    }

    public Rect getSourceBounds() {
        return this.mSourceBounds;
    }

    public ComponentName resolveActivity(PackageManager packageManager) {
        if (this.mComponent != null) {
            return this.mComponent;
        }
        ResolveInfo resolveInfo = packageManager.resolveActivity(this, 65536);
        if (resolveInfo != null) {
            return new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name);
        }
        return null;
    }

    public ActivityInfo resolveActivityInfo(PackageManager packageManager, int n) {
        ActivityInfo activityInfo = null;
        if (this.mComponent != null) {
            try {
                activityInfo = packageManager.getActivityInfo(this.mComponent, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        } else {
            ResolveInfo resolveInfo = packageManager.resolveActivity(this, 0x10000 | n);
            if (resolveInfo != null) {
                activityInfo = resolveInfo.activityInfo;
            }
        }
        return activityInfo;
    }

    public Intent setAction(String string2) {
        this.mAction = string2 != null ? string2.intern() : null;
        return this;
    }

    public Intent setData(Uri uri) {
        this.mData = uri;
        this.mType = null;
        return this;
    }

    public Intent setDataAndNormalize(Uri uri) {
        return this.setData(uri.normalizeScheme());
    }

    public Intent setType(String string2) {
        this.mData = null;
        this.mType = string2;
        return this;
    }

    public Intent setTypeAndNormalize(String string2) {
        return this.setType(Intent.normalizeMimeType(string2));
    }

    public Intent setDataAndType(Uri uri, String string2) {
        this.mData = uri;
        this.mType = string2;
        return this;
    }

    public Intent setDataAndTypeAndNormalize(Uri uri, String string2) {
        return this.setDataAndType(uri.normalizeScheme(), Intent.normalizeMimeType(string2));
    }

    public Intent addCategory(String string2) {
        if (this.mCategories == null) {
            this.mCategories = new HashSet();
        }
        this.mCategories.add(string2.intern());
        return this;
    }

    public void removeCategory(String string2) {
        if (this.mCategories != null) {
            this.mCategories.remove(string2);
            if (this.mCategories.size() == 0) {
                this.mCategories = null;
            }
        }
    }

    public void setSelector(Intent intent) {
        if (intent == this) {
            throw new IllegalArgumentException("Intent being set as a selector of itself");
        }
        if (intent != null && this.mPackage != null) {
            throw new IllegalArgumentException("Can't set selector when package name is already set");
        }
        this.mSelector = intent;
    }

    public void setClipData(ClipData clipData) {
        this.mClipData = clipData;
    }

    public Intent putExtra(String string2, boolean bl) {
        return this;
    }

    public Intent putExtra(String string2, byte by) {
        return this;
    }

    public Intent putExtra(String string2, char c) {
        return this;
    }

    public Intent putExtra(String string2, short s) {
        return this;
    }

    public Intent putExtra(String string2, int n) {
        return this;
    }

    public Intent putExtra(String string2, long l) {
        return this;
    }

    public Intent putExtra(String string2, float f) {
        return this;
    }

    public Intent putExtra(String string2, double d) {
        return this;
    }

    public Intent putExtra(String string2, String string3) {
        return this;
    }

    public Intent putExtra(String string2, CharSequence charSequence) {
        return this;
    }

    public Intent putExtra(String string2, Parcelable parcelable) {
        return this;
    }

    public Intent putExtra(String string2, Parcelable[] parcelableArray) {
        return this;
    }

    public Intent putParcelableArrayListExtra(String string2, ArrayList<? extends Parcelable> arrayList) {
        return this;
    }

    public Intent putIntegerArrayListExtra(String string2, ArrayList<Integer> arrayList) {
        return this;
    }

    public Intent putStringArrayListExtra(String string2, ArrayList<String> arrayList) {
        return this;
    }

    public Intent putCharSequenceArrayListExtra(String string2, ArrayList<CharSequence> arrayList) {
        return this;
    }

    public Intent putExtra(String string2, Serializable serializable) {
        return this;
    }

    public Intent putExtra(String string2, boolean[] blArray) {
        return this;
    }

    public Intent putExtra(String string2, byte[] byArray) {
        return this;
    }

    public Intent putExtra(String string2, short[] sArray) {
        return this;
    }

    public Intent putExtra(String string2, char[] cArray) {
        return this;
    }

    public Intent putExtra(String string2, int[] nArray) {
        return this;
    }

    public Intent putExtra(String string2, long[] lArray) {
        return this;
    }

    public Intent putExtra(String string2, float[] fArray) {
        return this;
    }

    public Intent putExtra(String string2, double[] dArray) {
        return this;
    }

    public Intent putExtra(String string2, String[] stringArray) {
        return this;
    }

    public Intent putExtra(String string2, CharSequence[] charSequenceArray) {
        return this;
    }

    public Intent putExtra(String string2, Bundle bundle) {
        return this;
    }

    @Deprecated
    public Intent putExtra(String string2, IBinder iBinder) {
        return this;
    }

    public Intent putExtras(Intent intent) {
        return this;
    }

    public Intent putExtras(Bundle bundle) {
        return this;
    }

    public Intent replaceExtras(Intent intent) {
        return this;
    }

    public Intent replaceExtras(Bundle bundle) {
        return this;
    }

    public void removeExtra(String string2) {
    }

    public Intent setFlags(int n) {
        this.mFlags = n;
        return this;
    }

    public Intent addFlags(int n) {
        this.mFlags |= n;
        return this;
    }

    public Intent setPackage(String string2) {
        if (string2 != null && this.mSelector != null) {
            throw new IllegalArgumentException("Can't set package name when selector is already set");
        }
        this.mPackage = string2;
        return this;
    }

    public Intent setComponent(ComponentName componentName) {
        this.mComponent = componentName;
        return this;
    }

    public Intent setClassName(Context context, String string2) {
        this.mComponent = new ComponentName(context, string2);
        return this;
    }

    public Intent setClassName(String string2, String string3) {
        this.mComponent = new ComponentName(string2, string3);
        return this;
    }

    public Intent setClass(Context context, Class<?> clazz) {
        this.mComponent = new ComponentName(context, clazz);
        return this;
    }

    public void setSourceBounds(Rect rect) {
        this.mSourceBounds = rect != null ? new Rect(rect) : null;
    }

    public int fillIn(Intent intent, int n) {
        int n2 = 0;
        if (intent.mAction != null && (this.mAction == null || (n & 1) != 0)) {
            this.mAction = intent.mAction;
            n2 |= 1;
        }
        if ((intent.mData != null || intent.mType != null) && (this.mData == null && this.mType == null || (n & 2) != 0)) {
            this.mData = intent.mData;
            this.mType = intent.mType;
            n2 |= 2;
        }
        if (intent.mCategories != null && (this.mCategories == null || (n & 4) != 0)) {
            if (intent.mCategories != null) {
                this.mCategories = new HashSet<String>(intent.mCategories);
            }
            n2 |= 4;
        }
        if (intent.mPackage != null && (this.mPackage == null || (n & 0x10) != 0) && this.mSelector == null) {
            this.mPackage = intent.mPackage;
            n2 |= 0x10;
        }
        if (intent.mSelector != null && (n & 0x40) != 0 && this.mPackage == null) {
            this.mSelector = new Intent(intent.mSelector);
            this.mPackage = null;
            n2 |= 0x40;
        }
        if (intent.mClipData != null && (this.mClipData == null || (n & 0x80) != 0)) {
            this.mClipData = intent.mClipData;
            n2 |= 0x80;
        }
        if (intent.mComponent != null && (n & 8) != 0) {
            this.mComponent = intent.mComponent;
            n2 |= 8;
        }
        this.mFlags |= intent.mFlags;
        if (intent.mSourceBounds != null && (this.mSourceBounds == null || (n & 0x20) != 0)) {
            this.mSourceBounds = new Rect(intent.mSourceBounds);
            n2 |= 0x20;
        }
        return n2;
    }

    public boolean filterEquals(Intent intent) {
        if (intent == null) {
            return false;
        }
        if (this.mAction != intent.mAction && (this.mAction != null ? !this.mAction.equals(intent.mAction) : !intent.mAction.equals(this.mAction))) {
            return false;
        }
        if (this.mData != intent.mData && (this.mData != null ? !this.mData.equals(intent.mData) : !intent.mData.equals(this.mData))) {
            return false;
        }
        if (this.mType != intent.mType && (this.mType != null ? !this.mType.equals(intent.mType) : !intent.mType.equals(this.mType))) {
            return false;
        }
        if (this.mPackage != intent.mPackage && (this.mPackage != null ? !this.mPackage.equals(intent.mPackage) : !intent.mPackage.equals(this.mPackage))) {
            return false;
        }
        if (this.mComponent != intent.mComponent && (this.mComponent != null ? !this.mComponent.equals(intent.mComponent) : !intent.mComponent.equals(this.mComponent))) {
            return false;
        }
        return this.mCategories == intent.mCategories || !(this.mCategories != null ? !this.mCategories.equals(intent.mCategories) : !intent.mCategories.equals(this.mCategories));
    }

    public int filterHashCode() {
        int n = 0;
        if (this.mAction != null) {
            n += this.mAction.hashCode();
        }
        if (this.mData != null) {
            n += this.mData.hashCode();
        }
        if (this.mType != null) {
            n += this.mType.hashCode();
        }
        if (this.mPackage != null) {
            n += this.mPackage.hashCode();
        }
        if (this.mComponent != null) {
            n += this.mComponent.hashCode();
        }
        if (this.mCategories != null) {
            n += this.mCategories.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Intent { ");
        this.toShortString(stringBuilder, true, true, true, false);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public String toInsecureString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Intent { ");
        this.toShortString(stringBuilder, false, true, true, false);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public String toInsecureStringWithClip() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Intent { ");
        this.toShortString(stringBuilder, false, true, true, true);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public String toShortString(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.toShortString(stringBuilder, bl, bl2, bl3, bl4);
        return stringBuilder.toString();
    }

    public void toShortString(StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public String toURI() {
        return this.toUri(0);
    }

    public String toUri(int n) {
        StringBuilder stringBuilder = new StringBuilder(128);
        String string2 = null;
        if (this.mData != null) {
            String string3 = this.mData.toString();
            if ((n & 1) != 0) {
                int n2 = string3.length();
                for (int i = 0; i < n2; ++i) {
                    char c = string3.charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '-') continue;
                    if (c != ':' || i <= 0) break;
                    string2 = string3.substring(0, i);
                    stringBuilder.append("intent:");
                    string3 = string3.substring(i + 1);
                    break;
                }
            }
            stringBuilder.append(string3);
        } else if ((n & 1) != 0) {
            stringBuilder.append("intent:");
        }
        stringBuilder.append("#Intent;");
        this.toUriInner(stringBuilder, string2, n);
        if (this.mSelector != null) {
            stringBuilder.append("SEL;");
            this.mSelector.toUriInner(stringBuilder, null, n);
        }
        stringBuilder.append("end");
        return stringBuilder.toString();
    }

    private void toUriInner(StringBuilder stringBuilder, String string2, int n) {
        if (string2 != null) {
            stringBuilder.append("scheme=").append(string2).append(';');
        }
        if (this.mAction != null) {
            stringBuilder.append("action=").append(Uri.encode(this.mAction)).append(';');
        }
        if (this.mCategories != null) {
            for (String string3 : this.mCategories) {
                stringBuilder.append("category=").append(Uri.encode(string3)).append(';');
            }
        }
        if (this.mType != null) {
            stringBuilder.append("type=").append(Uri.encode(this.mType, "/")).append(';');
        }
        if (this.mFlags != 0) {
            stringBuilder.append("launchFlags=0x").append(Integer.toHexString(this.mFlags)).append(';');
        }
        if (this.mPackage != null) {
            stringBuilder.append("package=").append(Uri.encode(this.mPackage)).append(';');
        }
        if (this.mComponent != null) {
            stringBuilder.append("component=").append(Uri.encode(this.mComponent.flattenToShortString(), "/")).append(';');
        }
        if (this.mSourceBounds != null) {
            stringBuilder.append("sourceBounds=").append(Uri.encode(this.mSourceBounds.flattenToString())).append(';');
        }
    }

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mAction);
        Uri.writeToParcel(parcel, this.mData);
        parcel.writeString(this.mType);
        parcel.writeInt(this.mFlags);
        parcel.writeString(this.mPackage);
        ComponentName.writeToParcel(this.mComponent, parcel);
        if (this.mSourceBounds != null) {
            parcel.writeInt(1);
            this.mSourceBounds.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        if (this.mCategories != null) {
            parcel.writeInt(this.mCategories.size());
            for (String string2 : this.mCategories) {
                parcel.writeString(string2);
            }
        } else {
            parcel.writeInt(0);
        }
        if (this.mSelector != null) {
            parcel.writeInt(1);
            this.mSelector.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        if (this.mClipData != null) {
            parcel.writeInt(1);
            this.mClipData.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
    }

    protected Intent(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public void readFromParcel(Parcel parcel) {
        throw new RuntimeException("Stub!");
    }

    public static Intent parseIntent(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        throw new RuntimeException("Stub!");
    }

    public static String normalizeMimeType(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = (string2 = string2.trim().toLowerCase(Locale.US)).indexOf(59);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public boolean migrateExtraStreamToClipData() {
        throw new RuntimeException("Stub!");
    }

    private static ClipData.Item makeClipItem(ArrayList<Uri> arrayList, ArrayList<CharSequence> arrayList2, ArrayList<String> arrayList3, int n) {
        Uri uri = arrayList != null ? arrayList.get(n) : null;
        CharSequence charSequence = arrayList2 != null ? arrayList2.get(n) : null;
        String string2 = arrayList3 != null ? arrayList3.get(n) : null;
        return new ClipData.Item(charSequence, string2, null, uri);
    }

    public static final class FilterComparison {
        private final Intent mIntent;
        private final int mHashCode;

        public FilterComparison(Intent intent) {
            this.mIntent = intent;
            this.mHashCode = intent.filterHashCode();
        }

        public Intent getIntent() {
            return this.mIntent;
        }

        public boolean equals(Object object) {
            if (object instanceof FilterComparison) {
                Intent intent = ((FilterComparison)object).mIntent;
                return this.mIntent.filterEquals(intent);
            }
            return false;
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }

    public static class ShortcutIconResource
    implements Parcelable {
        public String packageName;
        public String resourceName;
        public static final Parcelable.Creator<ShortcutIconResource> CREATOR = new Parcelable.Creator<ShortcutIconResource>(){

            @Override
            public ShortcutIconResource createFromParcel(Parcel parcel) {
                ShortcutIconResource shortcutIconResource = new ShortcutIconResource();
                shortcutIconResource.packageName = parcel.readString();
                shortcutIconResource.resourceName = parcel.readString();
                return shortcutIconResource;
            }

            public ShortcutIconResource[] newArray(int n) {
                return new ShortcutIconResource[n];
            }
        };

        public static ShortcutIconResource fromContext(Context context, int n) {
            ShortcutIconResource shortcutIconResource = new ShortcutIconResource();
            shortcutIconResource.packageName = context.getPackageName();
            shortcutIconResource.resourceName = context.getResources().getResourceName(n);
            return shortcutIconResource;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.packageName);
            parcel.writeString(this.resourceName);
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

